/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OByteBufferUtils;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OAbstractFile;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerLocator;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class OFileMMap
extends OAbstractFile {
    public static final String NAME = "mmap";
    protected int filledUpTo;
    protected MappedByteBuffer headerBuffer;
    protected static final Queue<ByteBuffer> bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    private static int BYTEBUFFER_POOLABLE_SIZE;
    private static OMMapManager.ALLOC_STRATEGY strategy;

    public void delete() throws IOException {
        OMMapManagerLocator.getInstance().removeFile(this);
        super.delete();
    }

    public OFileMMap init(String iFileName, String iMode) {
        super.init(iFileName, iMode);
        BYTEBUFFER_POOLABLE_SIZE = OGlobalConfiguration.FILE_MMAP_BUFFER_SIZE.getValueAsInteger();
        strategy = OMMapManager.ALLOC_STRATEGY.values()[OGlobalConfiguration.FILE_MMAP_STRATEGY.getValueAsInteger()];
        return this;
    }

    public int getFileSize() {
        return this.size;
    }

    public int getFilledUpTo() {
        return this.filledUpTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        iOffset = this.checkRegions(iOffset, iLenght);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, iLenght, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            try {
                int position = (int)(iOffset - entries[0].beginOffset);
                int remainingLength = iLenght;
                for (OMMapBufferEntry entry : entries) {
                    entry.buffer.position(position);
                    int remaining = entry.buffer.remaining();
                    int toRead = Math.min(remaining, remainingLength);
                    entry.buffer.get(iDestBuffer, iLenght - remainingLength, toRead);
                    position = 0;
                    remainingLength -= toRead;
                }
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(iLenght);
            this.channel.read(buffer, iOffset + 1024L);
            buffer.rewind();
            buffer.get(iDestBuffer);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 4, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            try {
                if (entries.length == 1) {
                    int n = entries[0].buffer.getInt((int)(iOffset - entries[0].beginOffset));
                    return n;
                }
                entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                entries[1].buffer.position(0);
                int n = OByteBufferUtils.mergeIntFromBuffers(entries[0].buffer, entries[1].buffer);
                return n;
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(4);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        int value = buffer.getInt();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 8);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 8, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            try {
                if (entries.length == 1) {
                    long l = entries[0].buffer.getLong((int)(iOffset - entries[0].beginOffset));
                    return l;
                }
                entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                entries[1].buffer.position(0);
                long l = OByteBufferUtils.mergeLongFromBuffers(entries[0].buffer, entries[1].buffer);
                return l;
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(8);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        long value = buffer.getLong();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 2);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 2, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            try {
                if (entries.length == 1) {
                    short s = entries[0].buffer.getShort((int)(iOffset - entries[0].beginOffset));
                    return s;
                }
                entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                entries[1].buffer.position(0);
                short s = OByteBufferUtils.mergeShortFromBuffers(entries[0].buffer, entries[1].buffer);
                return s;
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(2);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        short value = buffer.getShort();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 1);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 1, OMMapManager.OPERATION_TYPE.READ, strategy);
        if (entries != null) {
            try {
                byte by = entries[0].buffer.get((int)(iOffset - entries[0].beginOffset));
                return by;
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.READ);
            }
        }
        ByteBuffer buffer = this.acquireByteBuffer(1);
        this.channel.read(buffer, iOffset + 1024L);
        buffer.rewind();
        byte value = buffer.get();
        this.releaseByteBuffer(buffer);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(long iOffset, int iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 4, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entries != null) {
            try {
                if (entries.length == 1) {
                    entries[0].buffer.putInt((int)(iOffset - entries[0].beginOffset), iValue);
                }
                entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                entries[1].buffer.position(0);
                OByteBufferUtils.splitIntToBuffers(entries[0].buffer, entries[1].buffer, iValue);
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(4);
            buffer.putInt(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(long iOffset, long iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 8);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 8, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entries != null) {
            try {
                if (entries.length == 1) {
                    entries[0].buffer.putLong((int)(iOffset - entries[0].beginOffset), iValue);
                }
                entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                entries[1].buffer.position(0);
                OByteBufferUtils.splitLongToBuffers(entries[0].buffer, entries[1].buffer, iValue);
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(8);
            buffer.putLong(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(long iOffset, short iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 2);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 2, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entries != null) {
            try {
                if (entries.length == 1) {
                    entries[0].buffer.putShort((int)(iOffset - entries[0].beginOffset), iValue);
                }
                entries[0].buffer.position((int)(iOffset - entries[0].beginOffset));
                entries[1].buffer.position(0);
                OByteBufferUtils.splitShortToBuffers(entries[0].buffer, entries[1].buffer, iValue);
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(2);
            buffer.putShort(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(long iOffset, byte iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 1);
        OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, 1, OMMapManager.OPERATION_TYPE.WRITE, strategy);
        if (entries != null) {
            try {
                entries[0].buffer.put((int)(iOffset - entries[0].beginOffset), iValue);
            }
            finally {
                OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
            }
        } else {
            ByteBuffer buffer = this.acquireByteBuffer(1);
            buffer.put(iValue);
            buffer.rewind();
            this.channel.write(buffer, iOffset + 1024L);
            this.releaseByteBuffer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        block8: {
            if (iSourceBuffer == null || iSourceBuffer.length == 0) {
                return;
            }
            iOffset = this.checkRegions(iOffset, iSourceBuffer.length);
            try {
                OMMapBufferEntry[] entries = OMMapManagerLocator.getInstance().acquire(this, iOffset, iSourceBuffer.length, OMMapManager.OPERATION_TYPE.WRITE, strategy);
                if (entries != null) {
                    try {
                        int iLenght;
                        int position = (int)(iOffset - entries[0].beginOffset);
                        int remainingLength = iLenght = iSourceBuffer.length;
                        for (OMMapBufferEntry entry : entries) {
                            entry.buffer.position(position);
                            int remaining = entry.buffer.remaining();
                            int toWrite = Math.min(remaining, remainingLength);
                            entry.buffer.put(iSourceBuffer, iLenght - remainingLength, toWrite);
                            position = 0;
                            remainingLength -= toWrite;
                        }
                        break block8;
                    }
                    finally {
                        OMMapManagerLocator.getInstance().release(entries, OMMapManager.OPERATION_TYPE.WRITE);
                    }
                }
                ByteBuffer buffer = this.acquireByteBuffer(iSourceBuffer.length);
                buffer.put(iSourceBuffer);
                buffer.rewind();
                this.channel.write(buffer, iOffset + 1024L);
                this.releaseByteBuffer(buffer);
            }
            catch (BufferOverflowException e) {
                OLogManager.instance().error((Object)this, "Error on write in the range " + iOffset + "-" + (iOffset + (long)iSourceBuffer.length) + "." + this.toString(), (Throwable)e, OIOException.class, new Object[0]);
            }
        }
    }

    public void synch() {
        OMMapManagerLocator.getInstance().flushFile(this);
        this.flushHeader();
    }

    public void writeHeaderLong(int iPosition, long iValue) {
        if (this.headerBuffer != null) {
            this.headerBuffer.putLong(128 + iPosition, iValue);
            this.setHeaderDirty();
        }
    }

    public long readHeaderLong(int iPosition) {
        return this.headerBuffer.getLong(128 + iPosition);
    }

    public void close() throws IOException {
        super.close();
        OMMapManagerLocator.getInstance().flush();
        if (this.headerBuffer != null) {
            this.setSoftlyClosed(true);
            this.headerBuffer = null;
        }
    }

    public boolean isSoftlyClosed() {
        return this.headerBuffer.get(8) == 1;
    }

    public void setSoftlyClosed(boolean iValue) {
        if (this.headerBuffer == null) {
            return;
        }
        this.headerBuffer.put(8, (byte)(iValue ? 1 : 0));
        this.setHeaderDirty();
        this.flushHeader();
    }

    MappedByteBuffer map(long iBeginOffset, int iSize) throws IOException {
        return this.channel.map(this.mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, iBeginOffset + 1024L, iSize);
    }

    protected void openChannel(int iNewSize) throws IOException {
        super.openChannel(iNewSize);
        this.headerBuffer = this.channel.map(this.mode.equals("r") ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, 1024L);
    }

    public boolean isClosed() {
        return this.headerBuffer == null;
    }

    protected ByteBuffer acquireByteBuffer(int iSize) {
        if (iSize > BYTEBUFFER_POOLABLE_SIZE) {
            try {
                OProfiler.getInstance().updateStat("MMap.extraBufferSize", iSize);
                return ByteBuffer.allocate(iSize);
            }
            catch (OutOfMemoryError e) {
                OLogManager.instance().error((Object)this, "Error on allocating direct buffer of size %d bytes", (Throwable)e, iSize);
                throw e;
            }
        }
        ByteBuffer buffer = bufferPool.poll();
        if (buffer != null) {
            OProfiler.getInstance().updateCounter("system.file.mmap.pooledBuffers", -1L);
        } else {
            buffer = ByteBuffer.allocateDirect(BYTEBUFFER_POOLABLE_SIZE);
            OProfiler.getInstance().updateStat("system.file.mmap.pooledBufferSize", BYTEBUFFER_POOLABLE_SIZE);
        }
        buffer.limit(iSize);
        return buffer;
    }

    protected void releaseByteBuffer(ByteBuffer iBuffer) {
        if (iBuffer.limit() > BYTEBUFFER_POOLABLE_SIZE) {
            return;
        }
        iBuffer.rewind();
        bufferPool.add(iBuffer);
        OProfiler.getInstance().updateCounter("MMap.pooledBuffers", 1L);
    }

    protected void init() {
        this.size = this.headerBuffer.getInt(0);
        this.filledUpTo = this.headerBuffer.getInt(4);
    }

    protected void setFilledUpTo(int iHow) {
        if (iHow != this.filledUpTo) {
            this.filledUpTo = iHow;
            this.headerBuffer.putInt(4, this.filledUpTo);
            this.setHeaderDirty();
        }
    }

    public void setSize(int iSize) throws IOException {
        if (this.maxSize > 0 && iSize > this.maxSize) {
            throw new IllegalArgumentException("Cannot extend the file to " + OFileUtils.getSizeAsString(iSize) + " because the max is " + OFileUtils.getSizeAsString(this.maxSize));
        }
        if (iSize != this.size) {
            this.checkSize(iSize);
            this.size = iSize;
            this.headerBuffer.putInt(0, this.size);
            this.setHeaderDirty();
        }
    }

    protected void flushHeader() {
        if (this.headerDirty) {
            this.headerBuffer.force();
            this.headerDirty = false;
        }
    }
}

