/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.storage.fs.OAbstractFile;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OFileClassic
extends OAbstractFile {
    public static final String NAME = "classic";
    protected ByteBuffer internalWriteBuffer = ByteBuffer.allocate(8);

    public OFileClassic init(String iFileName, String iMode) {
        super.init(iFileName, iMode);
        return this;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.setSoftlyClosed(true);
        }
        super.close();
    }

    public int allocateSpace(int iSize) throws IOException {
        int currentSize = this.getFilledUpTo();
        if (this.maxSize > 0 && currentSize + iSize > this.maxSize) {
            throw new IllegalArgumentException("Cannot enlarge file since the configured max size (" + OFileUtils.getSizeAsString(this.maxSize) + ") was reached! " + this.toString());
        }
        this.size += iSize;
        return currentSize;
    }

    public void shrink(int iSize) throws IOException {
        this.channel.truncate(1024 + iSize);
        this.size = iSize;
    }

    public int getFileSize() {
        return this.size;
    }

    public int getFilledUpTo() {
        return this.size;
    }

    public void read(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        iOffset = this.checkRegions(iOffset, iLenght);
        ByteBuffer buffer = ByteBuffer.wrap(iDestBuffer);
        this.channel.read(buffer, iOffset);
    }

    public int readInt(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        return this.readData(iOffset, 4).getInt();
    }

    public long readLong(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 8);
        return this.readData(iOffset, 8).getLong();
    }

    public short readShort(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 2);
        return this.readData(iOffset, 2).getShort();
    }

    public byte readByte(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 1);
        return this.readData(iOffset, 1).get();
    }

    public void writeInt(long iOffset, int iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(4);
        buffer.putInt(iValue);
        this.writeBuffer(buffer, iOffset += 1024L);
        this.setDirty();
    }

    public void writeLong(long iOffset, long iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(8);
        buffer.putLong(iValue);
        this.writeBuffer(buffer, iOffset += 1024L);
        this.setDirty();
    }

    public void writeShort(long iOffset, short iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(2);
        buffer.putShort(iValue);
        this.writeBuffer(buffer, iOffset += 1024L);
        this.setDirty();
    }

    public void writeByte(long iOffset, byte iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(1);
        buffer.put(iValue);
        this.writeBuffer(buffer, iOffset += 1024L);
        this.setDirty();
    }

    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        if (iSourceBuffer != null) {
            this.channel.write(ByteBuffer.wrap(iSourceBuffer), iOffset += 1024L);
            this.setDirty();
        }
    }

    public void synch() throws IOException {
        this.flushHeader();
    }

    protected void flushHeader() throws IOException {
        if (this.headerDirty || this.dirty) {
            this.dirty = false;
            this.headerDirty = false;
            this.channel.force(false);
        }
    }

    public void create(int iStartSize) throws IOException {
        super.create(1024);
    }

    protected void init() throws IOException {
        this.size = (int)(this.osFile.length() - 1024L);
    }

    protected void setFilledUpTo(int iValue) throws IOException {
        this.size = iValue;
    }

    public void setSize(int iSize) throws IOException {
    }

    public void writeHeaderLong(int iPosition, long iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(8);
        buffer.putLong(iValue);
        this.writeBuffer(buffer, 128 + iPosition);
        this.setHeaderDirty();
    }

    public long readHeaderLong(int iPosition) throws IOException {
        return this.readData(128 + iPosition, 8).getLong();
    }

    public boolean isSoftlyClosed() throws IOException {
        return true;
    }

    public void setSoftlyClosed(boolean iValue) throws IOException {
    }

    protected long checkRegions(long iOffset, int iLength) {
        return super.checkRegions(iOffset, iLength) + 1024L;
    }

    private ByteBuffer readData(long iOffset, int iSize) throws IOException {
        ByteBuffer buffer = this.getBuffer(iSize);
        this.channel.read(buffer, iOffset);
        buffer.rewind();
        return buffer;
    }

    private void writeBuffer(ByteBuffer iBuffer, long iOffset) throws IOException {
        iBuffer.rewind();
        this.channel.write(iBuffer, iOffset);
    }

    private ByteBuffer getBuffer(int iLenght) {
        return ByteBuffer.allocate(iLenght);
    }

    private ByteBuffer getWriteBuffer(int iLenght) {
        this.setDirty();
        if (iLenght <= 8) {
            return (ByteBuffer)this.internalWriteBuffer.rewind();
        }
        return this.getBuffer(iLenght);
    }
}

