/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public abstract class OAbstractFile
implements OFile {
    private FileLock fileLock;
    protected File osFile;
    protected RandomAccessFile accessFile;
    protected FileChannel channel;
    protected volatile boolean dirty = false;
    protected volatile boolean headerDirty = false;
    protected int incrementSize = -50;
    protected int maxSize;
    protected byte[] securityCode = new byte[32];
    protected String mode;
    protected boolean failCheck = true;
    protected volatile int size;
    protected static final int HEADER_SIZE = 1024;
    protected static final int HEADER_DATA_OFFSET = 128;
    protected static final int DEFAULT_SIZE = 1024000;
    protected static final int DEFAULT_INCREMENT_SIZE = -50;
    private static final int OPEN_RETRY_MAX = 10;
    private static final int OPEN_DELAY_RETRY = 100;
    private static final long LOCK_WAIT_TIME = 300L;
    private static final int LOCK_MAX_RETRIES = 10;
    protected static final int SIZE_OFFSET = 0;
    protected static final int FILLEDUPTO_OFFSET = 4;
    protected static final int SOFTLY_CLOSED_OFFSET = 8;

    public abstract int getFileSize();

    public abstract int getFilledUpTo();

    public abstract void setSize(int var1) throws IOException;

    public abstract void writeHeaderLong(int var1, long var2) throws IOException;

    public abstract long readHeaderLong(int var1) throws IOException;

    public abstract void synch() throws IOException;

    public abstract void read(long var1, byte[] var3, int var4) throws IOException;

    public abstract short readShort(long var1) throws IOException;

    public abstract int readInt(long var1) throws IOException;

    public abstract long readLong(long var1) throws IOException;

    public abstract byte readByte(long var1) throws IOException;

    public abstract void writeInt(long var1, int var3) throws IOException;

    public abstract void writeLong(long var1, long var3) throws IOException;

    public abstract void writeShort(long var1, short var3) throws IOException;

    public abstract void writeByte(long var1, byte var3) throws IOException;

    public abstract void write(long var1, byte[] var3) throws IOException;

    protected abstract void init() throws IOException;

    protected abstract void setFilledUpTo(int var1) throws IOException;

    protected abstract void flushHeader() throws IOException;

    public boolean open() throws IOException {
        if (!this.osFile.exists()) {
            throw new FileNotFoundException("File: " + this.osFile.getAbsolutePath());
        }
        this.openChannel((int)this.osFile.length());
        OLogManager.instance().debug((Object)this, "Checking file integrity of " + this.osFile.getName() + "...", new Object[0]);
        this.init();
        int fileSize = this.getFileSize();
        int filledUpTo = this.getFilledUpTo();
        if (filledUpTo > 0 && filledUpTo > fileSize) {
            OLogManager.instance().warn((Object)this, "invalid filledUp value (%d) for file %s. Resetting the file size %d to the os file size: %d. Probably the file was not closed correctly last time", filledUpTo, this.getOsFile().getAbsolutePath(), fileSize, fileSize);
            this.setSize(fileSize);
        }
        if (filledUpTo > fileSize || filledUpTo < 0) {
            OLogManager.instance().error((Object)this, "Invalid filledUp size (=" + filledUpTo + "). The file could be corrupted", null, OStorageException.class, new Object[0]);
        }
        if (this.failCheck) {
            boolean softlyClosed = this.isSoftlyClosed();
            if (softlyClosed) {
                this.setSoftlyClosed(false);
            }
            return softlyClosed;
        }
        return true;
    }

    public void create(int iStartSize) throws IOException {
        if (iStartSize == -1) {
            iStartSize = 1024000;
        }
        this.openChannel(iStartSize);
        this.setFilledUpTo(0);
        this.setSize(this.maxSize > 0 && iStartSize > this.maxSize ? this.maxSize : iStartSize);
        this.setSoftlyClosed(!this.failCheck);
    }

    public void close() throws IOException {
        try {
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.unlock();
            }
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
                this.channel = null;
            }
            if (this.accessFile != null) {
                this.accessFile.close();
                this.accessFile = null;
            }
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on closing file " + this.osFile.getAbsolutePath(), (Throwable)e, OIOException.class, new Object[0]);
        }
    }

    public void delete() throws IOException {
        this.close();
        if (this.osFile != null) {
            boolean deleted = this.osFile.delete();
            while (!deleted) {
                OMemoryWatchDog.freeMemory(100L);
                deleted = this.osFile.delete();
            }
        }
    }

    public FileLock lock(long iRangeFrom, long iRangeSize, boolean iShared) throws IOException {
        return this.channel.lock(iRangeFrom, iRangeSize, iShared);
    }

    public OFile unlock(FileLock iLock) throws IOException {
        if (iLock != null) {
            try {
                iLock.release();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
        return this;
    }

    public void lock() throws IOException {
        for (int i = 0; i < 10; ++i) {
            try {
                this.fileLock = this.channel.tryLock(0L, 1L, false);
                break;
            }
            catch (OverlappingFileLockException e) {
                OLogManager.instance().debug((Object)this, "Cannot open file '" + this.osFile.getAbsolutePath() + "' because it is locked. Waiting %d ms and retrying %d/%d...", 300L, i, 10);
                OMemoryWatchDog.freeMemory(300L);
                continue;
            }
        }
        if (this.fileLock == null) {
            throw new OLockException("File '" + this.osFile.getPath() + "' is locked by another process, maybe the database is in use by another process. Use the remote mode with a OrientDB server to allow multiple access to the same database.");
        }
    }

    public void unlock() throws IOException {
        if (this.fileLock != null) {
            try {
                this.fileLock.release();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
            this.fileLock = null;
        }
    }

    protected void checkSize(int iSize) throws IOException {
        int filledUpTo;
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Changing file size to " + iSize + " bytes. " + this.toString(), new Object[0]);
        }
        if (iSize < (filledUpTo = this.getFilledUpTo())) {
            OLogManager.instance().error((Object)this, "You cannot resize down the file to " + iSize + " bytes, since it is less than current space used: " + filledUpTo + " bytes", OIOException.class);
        }
    }

    public void removeTail(int iSizeToShrink) throws IOException {
        int filledUpTo = this.getFilledUpTo();
        if (filledUpTo < iSizeToShrink) {
            iSizeToShrink = 0;
        }
        this.setFilledUpTo(filledUpTo - iSizeToShrink);
    }

    public void shrink(int iSize) throws IOException {
        int filledUpTo = this.getFilledUpTo();
        if (iSize >= filledUpTo) {
            return;
        }
        OLogManager.instance().debug((Object)this, "Shrinking filled file from " + filledUpTo + " to " + iSize + " bytes. " + this.toString(), new Object[0]);
        this.setFilledUpTo(iSize);
    }

    public int allocateSpace(int iSize) throws IOException {
        int offset = this.getFilledUpTo();
        int size = this.getFileSize();
        if (this.getFreeSpace() < iSize) {
            int stepSizeInBytes;
            if (this.maxSize > 0 && this.maxSize - size < iSize) {
                throw new IllegalArgumentException("Cannot enlarge file since the configured max size (" + OFileUtils.getSizeAsString(this.maxSize) + ") was reached! " + this.toString());
            }
            int newFileSize = size;
            if (newFileSize == 0) {
                newFileSize = 1024000;
            }
            int n = stepSizeInBytes = this.incrementSize > 0 ? this.incrementSize : -1 * size / 100 * this.incrementSize;
            while (newFileSize - offset <= iSize) {
                if ((newFileSize += stepSizeInBytes) == 0) {
                    newFileSize = iSize;
                }
                if (newFileSize <= this.maxSize || this.maxSize <= 0) continue;
                newFileSize = this.maxSize;
            }
            this.setSize(newFileSize);
        }
        this.setFilledUpTo(offset + iSize);
        return offset;
    }

    protected long checkRegions(long iOffset, int iLength) {
        if (iOffset < 0L || iOffset + (long)iLength > (long)this.getFilledUpTo()) {
            throw new OIOException("You cannot access outside the file size (" + this.getFilledUpTo() + " bytes). You have requested portion " + iOffset + "-" + (iOffset + (long)iLength) + " bytes. File: " + this.toString());
        }
        return iOffset;
    }

    public int getFreeSpace() {
        return this.getFileSize() - this.getFilledUpTo();
    }

    public boolean canOversize(int iRecordSize) {
        return this.maxSize - this.getFileSize() > iRecordSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("File: ");
        builder.append(this.osFile.getName());
        if (this.accessFile != null) {
            builder.append(" os-size=");
            try {
                builder.append(this.accessFile.length());
            }
            catch (IOException e) {
                builder.append("?");
            }
        }
        builder.append(", stored=");
        builder.append(this.getFileSize());
        builder.append(", filled=");
        builder.append(this.getFilledUpTo());
        builder.append(", max=");
        builder.append(this.maxSize);
        builder.append("");
        return builder.toString();
    }

    public File getOsFile() {
        return this.osFile;
    }

    public OAbstractFile init(String iFileName, String iMode) {
        this.mode = iMode;
        this.osFile = new File(iFileName);
        return this;
    }

    protected void openChannel(int iNewSize) throws IOException {
        OLogManager.instance().debug((Object)this, "[OFile.openChannel] opening channel for file '%s' of size: ", this.osFile, this.osFile.length());
        for (int i = 0; i < 10; ++i) {
            try {
                this.accessFile = new RandomAccessFile(this.osFile, this.mode);
                break;
            }
            catch (FileNotFoundException e) {
                if (i == 100) {
                    throw e;
                }
                this.osFile.getParentFile().mkdirs();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        if (this.accessFile == null) {
            throw new FileNotFoundException(this.osFile.getAbsolutePath());
        }
        this.accessFile.setLength(iNewSize);
        this.accessFile.seek(0L);
        this.channel = this.accessFile.getChannel();
        if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
            this.lock();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public void setIncrementSize(int incrementSize) {
        this.incrementSize = incrementSize;
    }

    public boolean isOpen() {
        return this.accessFile != null;
    }

    public boolean exists() {
        return this.osFile != null && this.osFile.exists();
    }

    public boolean isFailCheck() {
        return this.failCheck;
    }

    public void setFailCheck(boolean failCheck) {
        this.failCheck = failCheck;
    }

    protected void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
        }
    }

    protected void setHeaderDirty() {
        if (!this.headerDirty) {
            this.headerDirty = true;
        }
    }

    public String getName() {
        return this.osFile.getName();
    }

    public String getPath() {
        return this.osFile.getPath();
    }

    public String getAbsolutePath() {
        return this.osFile.getAbsolutePath();
    }

    public boolean renameTo(File newFile) {
        return this.osFile.renameTo(newFile);
    }
}

