/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordLockManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;

public abstract class OStorageEmbedded
extends OStorageAbstract {
    protected final ORecordLockManager lockManager = new ORecordLockManager(OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger());
    protected final String PROFILER_CREATE_RECORD = "db." + this.name + ".createRecord";
    protected final String PROFILER_READ_RECORD = "db." + this.name + ".readRecord";
    protected final String PROFILER_UPDATE_RECORD = "db." + this.name + ".updateRecord";
    protected final String PROFILER_DELETE_RECORD = "db." + this.name + ".deleteRecord";

    public OStorageEmbedded(String iName, String iFilePath, String iMode) {
        super(iName, iFilePath, iMode);
    }

    protected abstract ORawBuffer readRecord(OCluster var1, ORecordId var2, boolean var3);

    public abstract OCluster getClusterByName(String var1);

    public void close(boolean iForce) {
        if (this.checkForClose(iForce)) {
            this.lockManager.clear();
        }
        super.close(iForce);
    }

    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse(iCommand);
        return this.executeCommand(iCommand, executor);
    }

    public Object executeCommand(OCommandRequestText iCommand, OCommandExecutor executor) {
        if (iCommand.isIdempotent() && !executor.isIdempotent()) {
            throw new OCommandExecutionException("Cannot execute non idempotent command");
        }
        try {
            Object result = executor.execute(iCommand.getParameters());
            iCommand.setContext(executor.getContext());
            return result;
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error on execution of command: " + iCommand, e);
        }
    }

    protected void checkOpeness() {
        if (this.status != OStorage.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }
}

