/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.record.ORecordInternal;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORawBuffer
implements Externalizable {
    public byte[] buffer;
    public int version;
    public byte recordType;

    public ORawBuffer() {
    }

    public ORawBuffer(byte[] buffer, int version, byte recordType) {
        this.buffer = buffer;
        this.version = version;
        this.recordType = recordType;
    }

    public ORawBuffer(ORecordInternal<?> iRecord) {
        this.buffer = iRecord.toStream();
        this.version = iRecord.getVersion();
        this.recordType = iRecord.getRecordType();
    }

    @Override
    public void readExternal(ObjectInput iInput) throws IOException, ClassNotFoundException {
        int bufferLenght = iInput.readInt();
        if (bufferLenght > 0) {
            this.buffer = new byte[bufferLenght];
            iInput.read(this.buffer);
        } else {
            this.buffer = null;
        }
        this.version = iInput.readInt();
        this.recordType = iInput.readByte();
    }

    @Override
    public void writeExternal(ObjectOutput iOutput) throws IOException {
        int bufferLenght = this.buffer != null ? this.buffer.length : 0;
        iOutput.writeInt(bufferLenght);
        if (bufferLenght > 0) {
            iOutput.write(this.buffer);
        }
        iOutput.writeInt(this.version);
        iOutput.write(this.recordType);
    }

    public String toString() {
        return "size:" + (this.buffer != null ? Integer.valueOf(this.buffer.length) : "empty");
    }
}

