/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPhysicalPosition
implements OSerializableStream,
Comparable<OPhysicalPosition>,
Externalizable {
    public long clusterPosition;
    public int dataSegmentId;
    public long dataSegmentPos;
    public byte recordType;
    public int recordVersion = 0;
    public int recordSize;
    private static final int BINARY_SIZE = 29;

    public OPhysicalPosition() {
    }

    public OPhysicalPosition(long iClusterPosition) {
        this.clusterPosition = iClusterPosition;
    }

    public OPhysicalPosition(int iDataSegmentId, long iDataSegmentPosition, byte iRecordType) {
        this.dataSegmentId = iDataSegmentId;
        this.dataSegmentPos = iDataSegmentPosition;
        this.recordType = iRecordType;
    }

    public OPhysicalPosition(long iClusterPosition, int iVersion) {
        this.clusterPosition = iClusterPosition;
        this.recordVersion = iVersion;
    }

    public void copyTo(OPhysicalPosition iDest) {
        iDest.clusterPosition = this.clusterPosition;
        iDest.dataSegmentId = this.dataSegmentId;
        iDest.dataSegmentPos = this.dataSegmentPos;
        iDest.recordType = this.recordType;
        iDest.recordVersion = this.recordVersion;
        iDest.recordSize = this.recordSize;
    }

    public void copyFrom(OPhysicalPosition iSource) {
        iSource.copyTo(this);
    }

    public String toString() {
        return "cluster(?:" + this.clusterPosition + ") data(" + this.dataSegmentId + ":" + this.dataSegmentPos + ") record(type:" + this.recordType + " size:" + this.recordSize + " v:" + this.recordVersion + ")";
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int pos = 0;
        this.clusterPosition = OBinaryProtocol.bytes2long(iStream, pos);
        this.dataSegmentId = OBinaryProtocol.bytes2int(iStream, pos += 8);
        this.dataSegmentPos = OBinaryProtocol.bytes2long(iStream, pos += 4);
        this.recordType = iStream[pos += 8];
        this.recordSize = OBinaryProtocol.bytes2int(iStream, ++pos);
        this.recordVersion = OBinaryProtocol.bytes2int(iStream, pos += 4);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] buffer = new byte[29];
        int pos = 0;
        OBinaryProtocol.long2bytes(this.clusterPosition, buffer, pos);
        OBinaryProtocol.int2bytes(this.dataSegmentId, buffer, pos += 8);
        OBinaryProtocol.long2bytes(this.dataSegmentPos, buffer, pos += 4);
        buffer[pos += 8] = this.recordType;
        OBinaryProtocol.int2bytes(this.recordSize, buffer, ++pos);
        OBinaryProtocol.int2bytes(this.recordVersion, buffer, pos += 4);
        return buffer;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OPhysicalPosition)) {
            return false;
        }
        OPhysicalPosition other = (OPhysicalPosition)obj;
        return this.clusterPosition == other.clusterPosition && this.recordType == other.recordType && this.recordVersion == other.recordVersion && this.recordSize == other.recordSize;
    }

    @Override
    public int compareTo(OPhysicalPosition iOther) {
        return (int)(this.dataSegmentPos - iOther.dataSegmentPos);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.clusterPosition);
        out.writeInt(this.dataSegmentId);
        out.writeLong(this.dataSegmentPos);
        out.writeByte(this.recordType);
        out.writeInt(this.recordSize);
        out.writeInt(this.recordVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.clusterPosition = in.readLong();
        this.dataSegmentId = in.readInt();
        this.dataSegmentPos = in.readLong();
        this.recordType = in.readByte();
        this.recordSize = in.readInt();
        this.recordVersion = in.readInt();
    }
}

