/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorMinorEquals
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorMinorEquals() {
        super("<=", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        Object right = OType.convert(iRight, iLeft.getClass());
        if (right == null) {
            return false;
        }
        return ((Comparable)iLeft).compareTo(right) <= 0;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iRight == null || iLeft == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Object executeIndexQuery(OIndex<?> index, OQueryOperator.INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        Collection<OIdentifiable> result;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            result = fetchLimit > -1 ? index.getValuesMinor(key, true, fetchLimit) : index.getValuesMinor(key, true);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams.subList(0, keyParams.size() - 1));
            if (keyOne == null) {
                return null;
            }
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyTwo == null) {
                return null;
            }
            result = fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true);
            this.updateProfiler(index, keyParams, indexDefinition);
        }
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof ORID) {
                return (ORID)iRight;
            }
            if (iRight instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iRight).getValue(null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iRight).getValue(null, null);
            }
        }
        return null;
    }
}

