/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorContainsText
extends OQueryTargetOperator {
    private boolean ignoreCase = true;

    public OQueryOperatorContainsText(boolean iIgnoreCase) {
        super("CONTAINSTEXT", 5, false);
        this.ignoreCase = iIgnoreCase;
    }

    public OQueryOperatorContainsText() {
        super("CONTAINSTEXT", 5, false);
    }

    @Override
    public String getSyntax() {
        return "<left> CONTAINSTEXT[( noignorecase ] )] <right>";
    }

    @Override
    public Collection<OIdentifiable> filterRecords(ODatabaseComplex<?> iDatabase, List<String> iTargetClasses, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        String fieldName = iCondition.getLeft() instanceof OSQLFilterItemField ? iCondition.getLeft().toString() : iCondition.getRight().toString();
        String fieldValue = iCondition.getLeft() instanceof OSQLFilterItemField ? iCondition.getRight().toString() : iCondition.getLeft().toString();
        String className = iTargetClasses.get(0);
        OProperty prop = iDatabase.getMetadata().getSchema().getClass(className).getProperty(fieldName);
        if (prop == null) {
            return null;
        }
        OIndex<?> fullTextIndex = null;
        for (OIndex<?> indexDefinition : prop.getIndexes()) {
            if (!(indexDefinition instanceof OIndexFullText)) continue;
            fullTextIndex = indexDefinition;
            break;
        }
        if (fullTextIndex == null) {
            return null;
        }
        return (Collection)fullTextIndex.get(fieldValue);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Object executeIndexQuery(OIndex<?> index, OQueryOperator.INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (indexDefinition.getParamCount() > 1) {
            return null;
        }
        OIndexInternal<?> internalIndex = index.getInternal();
        if (internalIndex instanceof OIndexFullText) {
            Object indexResult = index.get(indexDefinition.createValue(keyParams));
            if (indexResult instanceof Collection) {
                return (Collection)indexResult;
            }
            if (indexResult == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList((OIdentifiable)indexResult);
        }
        return null;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

