/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorContainsKey
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorContainsKey() {
        super("CONTAINSKEY", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iLeft instanceof Map) {
            Map map = (Map)iLeft;
            return map.containsKey(iRight);
        }
        if (iRight instanceof Map) {
            Map map = (Map)iRight;
            return map.containsKey(iLeft);
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Object executeIndexQuery(OIndex<?> index, OQueryOperator.INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            if (!(indexDefinition instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)indexDefinition).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.KEY) {
                return null;
            }
            Object key = ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0));
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            if (indexResult instanceof Collection) {
                return (Collection)indexResult;
            }
            if (indexResult == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList((OIdentifiable)indexResult);
        }
        OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
        if (!(compositeIndexDefinition.getMultiValueDefinition() instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)compositeIndexDefinition.getMultiValueDefinition()).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.KEY) {
            return null;
        }
        OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
        if (keyOne == null) {
            return null;
        }
        OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
        Collection<OIdentifiable> result = fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true);
        this.updateProfiler(index, keyParams, indexDefinition);
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

