/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorBetween
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorBetween() {
        super("BETWEEN", 5, false, 3);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        this.validate(iRight);
        Iterator<Object> valueIterator = OMultiValue.getMultiValueIterator(iRight);
        Object right1 = OType.convert(valueIterator.next(), iLeft.getClass());
        if (right1 == null) {
            return false;
        }
        valueIterator.next();
        Object right2 = OType.convert(valueIterator.next(), iLeft.getClass());
        if (right2 == null) {
            return false;
        }
        return ((Comparable)iLeft).compareTo(right1) >= 0 && ((Comparable)iLeft).compareTo(right2) <= 0;
    }

    private void validate(Object iRight) {
        if (!OMultiValue.isMultiValue(iRight.getClass())) {
            throw new IllegalArgumentException("Found '" + iRight + "' while was expected: " + this.getSyntax());
        }
        if (OMultiValue.getSize(iRight) != 3) {
            throw new IllegalArgumentException("Found '" + OMultiValue.toString(iRight) + "' while was expected: " + this.getSyntax());
        }
    }

    @Override
    public String getSyntax() {
        return "<left> " + this.keyword + " <minRange> AND <maxRange>";
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Object executeIndexQuery(OIndex<?> index, OQueryOperator.INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        Collection<OIdentifiable> result;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object[] betweenKeys = (Object[])keyParams.get(0);
            Object keyOne = indexDefinition.createValue(Collections.singletonList(OSQLHelper.getValue(betweenKeys[0])));
            Object keyTwo = indexDefinition.createValue(Collections.singletonList(OSQLHelper.getValue(betweenKeys[2])));
            if (keyOne == null || keyTwo == null) {
                return null;
            }
            result = fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            Object[] betweenKeys = (Object[])keyParams.get(keyParams.size() - 1);
            Object betweenKeyOne = OSQLHelper.getValue(betweenKeys[0]);
            if (betweenKeyOne == null) {
                return null;
            }
            Object betweenKeyTwo = OSQLHelper.getValue(betweenKeys[2]);
            if (betweenKeyTwo == null) {
                return null;
            }
            ArrayList<Object> betweenKeyOneParams = new ArrayList<Object>(keyParams.size());
            betweenKeyOneParams.addAll(keyParams.subList(0, keyParams.size() - 1));
            betweenKeyOneParams.add(betweenKeyOne);
            ArrayList<Object> betweenKeyTwoParams = new ArrayList<Object>(keyParams.size());
            betweenKeyTwoParams.addAll(keyParams.subList(0, keyParams.size() - 1));
            betweenKeyTwoParams.add(betweenKeyTwo);
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(betweenKeyOneParams);
            if (keyOne == null) {
                return null;
            }
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(betweenKeyTwoParams);
            if (keyTwo == null) {
                return null;
            }
            result = fetchLimit > -1 ? index.getValuesBetween(keyOne, true, keyTwo, true, fetchLimit) : index.getValuesBetween(keyOne, true, keyTwo, true);
            this.updateProfiler(index, keyParams, indexDefinition);
        }
        return result;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        this.validate(iRight);
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            Iterator<Object> valueIterator = OMultiValue.getMultiValueIterator(iRight);
            Object right1 = valueIterator.next();
            if (right1 != null) {
                return (ORID)right1;
            }
            valueIterator.next();
            return (ORID)valueIterator.next();
        }
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        this.validate(iRight);
        this.validate(iRight);
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            Iterator<Object> valueIterator = OMultiValue.getMultiValueIterator(iRight);
            Object right1 = valueIterator.next();
            valueIterator.next();
            Object right2 = valueIterator.next();
            if (right2 == null) {
                return (ORID)right1;
            }
            return (ORID)right2;
        }
        return null;
    }
}

