/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorAnd;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContains;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsAll;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsKey;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsText;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsValue;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorInstanceof;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIs;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorLike;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMatches;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNot;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorOr;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorTraverse;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorDivide;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMinus;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMod;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMultiply;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorPlus;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OQueryOperator {
    protected static final Class<?>[] DEFAULT_OPERATORS_ORDER = new Class[]{OQueryOperatorEquals.class, OQueryOperatorAnd.class, OQueryOperatorOr.class, OQueryOperatorNotEquals.class, OQueryOperatorNot.class, OQueryOperatorMinorEquals.class, OQueryOperatorMinor.class, OQueryOperatorMajorEquals.class, OQueryOperatorContainsAll.class, OQueryOperatorMajor.class, OQueryOperatorLike.class, OQueryOperatorMatches.class, OQueryOperatorInstanceof.class, OQueryOperatorIs.class, OQueryOperatorIn.class, OQueryOperatorContainsKey.class, OQueryOperatorContainsValue.class, OQueryOperatorContainsText.class, OQueryOperatorContains.class, OQueryOperatorTraverse.class, OQueryOperatorBetween.class, OQueryOperatorPlus.class, OQueryOperatorMinus.class, OQueryOperatorMultiply.class, OQueryOperatorDivide.class, OQueryOperatorMod.class};
    public final String keyword;
    public final int precedence;
    public final int expectedRightWords;
    public final boolean unary;

    protected OQueryOperator(String iKeyword, int iPrecedence, boolean iUnary) {
        this.keyword = iKeyword;
        this.precedence = iPrecedence;
        this.unary = iUnary;
        this.expectedRightWords = 1;
    }

    protected OQueryOperator(String iKeyword, int iPrecedence, boolean iUnary, int iExpectedRightWords) {
        this.keyword = iKeyword;
        this.precedence = iPrecedence;
        this.unary = iUnary;
        this.expectedRightWords = iExpectedRightWords;
    }

    public abstract Object evaluateRecord(OIdentifiable var1, OSQLFilterCondition var2, Object var3, Object var4, OCommandContext var5);

    public abstract OIndexReuseType getIndexReuseType(Object var1, Object var2);

    public Object executeIndexQuery(OIndex<?> index, INDEX_OPERATION_TYPE iOperationType, List<Object> keyParams, int fetchLimit) {
        return null;
    }

    public String toString() {
        return this.keyword;
    }

    public OQueryOperator configure(List<String> iParams) {
        return this;
    }

    public String getSyntax() {
        return "<left> " + this.keyword + " <right>";
    }

    public abstract ORID getBeginRidRange(Object var1, Object var2);

    public abstract ORID getEndRidRange(Object var1, Object var2);

    public boolean isUnary() {
        return this.unary;
    }

    public ORDER compare(OQueryOperator other) {
        Class<?> thisClass = this.getClass();
        Class<?> otherClass = other.getClass();
        int thisPosition = -1;
        int otherPosition = -1;
        for (int i = 0; i < DEFAULT_OPERATORS_ORDER.length; ++i) {
            Class<?> clazz = DEFAULT_OPERATORS_ORDER[i];
            if (clazz.isAssignableFrom(thisClass)) {
                thisPosition = i;
            }
            if (!clazz.isAssignableFrom(otherClass)) continue;
            otherPosition = i;
        }
        if (thisPosition == -1 || otherPosition == -1) {
            return ORDER.UNKNOWNED;
        }
        if (thisPosition > otherPosition) {
            return ORDER.AFTER;
        }
        if (thisPosition < otherPosition) {
            return ORDER.BEFORE;
        }
        return ORDER.EQUAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum INDEX_OPERATION_TYPE {
        GET,
        COUNT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ORDER {
        UNKNOWNED,
        BEFORE,
        AFTER,
        EQUAL;

    }
}

