/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OBaseParser;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterFieldOperator;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class OSQLFilterItemAbstract
implements OSQLFilterItem {
    protected List<OPair<Integer, List<String>>> operationsChain = null;

    public OSQLFilterItemAbstract(OBaseParser iQueryToParse, String iText) {
        List<String> parts = OStringSerializerHelper.smartSplit(iText, '.', new char[0]);
        this.setRoot(iQueryToParse, parts.get(0));
        if (parts.size() > 1) {
            this.operationsChain = new ArrayList<OPair<Integer, List<String>>>();
            for (int i = 1; i < parts.size(); ++i) {
                String part = parts.get(i);
                String partUpperCase = part.toUpperCase(Locale.ENGLISH);
                if (part.indexOf(40) > -1) {
                    boolean operatorFound = false;
                    for (OSQLFilterFieldOperator op : OSQLFilterFieldOperator.OPERATORS) {
                        List<String> arguments;
                        if (!partUpperCase.startsWith(op.keyword + "(")) continue;
                        if (op.minArguments > 0) {
                            arguments = OStringSerializerHelper.getParameters(part);
                            if (arguments.size() < op.minArguments || arguments.size() > op.maxArguments) {
                                throw new OQueryParsingException(iQueryToParse.text, "Syntax error: field operator '" + op.keyword + "' needs " + (op.minArguments == op.maxArguments ? Integer.valueOf(op.minArguments) : op.minArguments + "-" + op.maxArguments) + " argument(s) while has been received " + arguments.size(), 0);
                            }
                        } else {
                            arguments = null;
                        }
                        this.operationsChain.add(new OPair<Integer, List<String>>(op.id, arguments));
                        operatorFound = true;
                        break;
                    }
                    if (operatorFound) continue;
                    throw new OQueryParsingException(iQueryToParse.text, "Syntax error: field operator not recognized between the supported ones: " + Arrays.toString((Object[])OSQLFilterFieldOperator.OPERATORS), 0);
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(part);
                this.operationsChain.add(new OPair(OSQLFilterFieldOperator.FIELD.id, list));
            }
        }
    }

    public abstract String getRoot();

    protected abstract void setRoot(OBaseParser var1, String var2);

    public Object transformValue(OIdentifiable iRecord, Object ioResult) {
        if (ioResult != null && this.operationsChain != null) {
            int operator = -2;
            try {
                for (OPair<Integer, List<String>> op : this.operationsChain) {
                    operator = (Integer)op.key;
                    if (operator == OSQLFilterFieldOperator.SIZE.id) {
                        if (ioResult != null) {
                            if (ioResult instanceof ORecord) {
                                ioResult = 1;
                                continue;
                            }
                            ioResult = OMultiValue.getSize(ioResult);
                            continue;
                        }
                        ioResult = 0;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.LENGTH.id) {
                        ioResult = ioResult != null ? ioResult.toString().length() : 0;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.TOUPPERCASE.id) {
                        ioResult = ioResult != null ? ioResult.toString().toUpperCase() : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.TOLOWERCASE.id) {
                        ioResult = ioResult != null ? ioResult.toString().toLowerCase() : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.TRIM.id) {
                        ioResult = ioResult != null ? ioResult.toString().trim() : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.FIELD.id) {
                        if (ioResult == null) continue;
                        if (ioResult instanceof String) {
                            try {
                                ioResult = new ODocument(new ORecordId((String)ioResult));
                            }
                            catch (Exception e) {
                                OLogManager.instance().error((Object)this, "Error on reading rid with value '%s'", null, ioResult);
                                ioResult = null;
                            }
                        } else if (ioResult instanceof OIdentifiable) {
                            ioResult = ((OIdentifiable)ioResult).getRecord();
                        }
                        if (ioResult == null) continue;
                        ioResult = ODocumentHelper.getFieldValue(ioResult, (String)((List)op.value).get(0));
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.CHARAT.id) {
                        int index = Integer.parseInt((String)((List)op.value).get(0));
                        ioResult = ioResult != null ? ioResult.toString().substring(index, index + 1) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.INDEXOF.id && ((String)((List)op.value).get(0)).length() > 2) {
                        String toFind = ((String)((List)op.value).get(0)).substring(1, ((String)((List)op.value).get(0)).length() - 1);
                        int startIndex = ((List)op.value).size() > 1 ? Integer.parseInt((String)((List)op.value).get(1)) : 0;
                        ioResult = ioResult != null ? Integer.valueOf(ioResult.toString().indexOf(toFind, startIndex)) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.SUBSTRING.id) {
                        int endIndex = ((List)op.value).size() > 1 ? Integer.parseInt((String)((List)op.value).get(1)) : ((String)((List)op.value).get(0)).length();
                        ioResult = ioResult != null ? ioResult.toString().substring(Integer.parseInt((String)((List)op.value).get(0)), endIndex) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.APPEND.id) {
                        Object v = this.getParameterValue(iRecord, (String)((List)op.value).get(0));
                        if (v == null) continue;
                        ioResult = ioResult != null ? ioResult.toString() + v : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.PREFIX.id) {
                        Object v = this.getParameterValue(iRecord, (String)((List)op.value).get(0));
                        if (v == null) continue;
                        ioResult = ioResult != null ? v + ioResult.toString() : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.FORMAT.id) {
                        Object v = this.getParameterValue(iRecord, (String)((List)op.value).get(0));
                        if (v == null) continue;
                        if (ioResult instanceof Date) {
                            ioResult = new SimpleDateFormat(v.toString()).format(ioResult);
                            continue;
                        }
                        ioResult = ioResult != null ? String.format(v.toString(), ioResult) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.LEFT.id) {
                        int len = Integer.parseInt((String)((List)op.value).get(0));
                        ioResult = ioResult != null ? ioResult.toString().substring(0, len <= ioResult.toString().length() ? len : ioResult.toString().length()) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.RIGHT.id) {
                        int offset = Integer.parseInt((String)((List)op.value).get(0));
                        ioResult = ioResult != null ? ioResult.toString().substring(offset < ioResult.toString().length() ? ioResult.toString().length() - offset : 0) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.ASSTRING.id) {
                        ioResult = ioResult != null ? ioResult.toString() : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.ASINTEGER.id) {
                        ioResult = ioResult != null ? new Integer(ioResult.toString()) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.ASFLOAT.id) {
                        ioResult = ioResult != null ? new Float(ioResult.toString()) : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.ASBOOLEAN.id) {
                        if (ioResult == null) continue;
                        if (ioResult instanceof String) {
                            ioResult = new Boolean((String)ioResult);
                            continue;
                        }
                        if (!(ioResult instanceof Number)) continue;
                        int bValue = ((Number)ioResult).intValue();
                        if (bValue == 0) {
                            ioResult = Boolean.FALSE;
                            continue;
                        }
                        if (bValue == 1) {
                            ioResult = Boolean.TRUE;
                            continue;
                        }
                        ioResult = null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.ASDATE.id) {
                        if (ioResult == null) continue;
                        if (ioResult instanceof Long) {
                            ioResult = new Date((Long)ioResult);
                            continue;
                        }
                        if (ioResult instanceof Date) continue;
                        ioResult = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateFormatInstance().parse(ioResult.toString());
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.ASDATETIME.id) {
                        if (ioResult == null) continue;
                        if (ioResult instanceof Long) {
                            ioResult = new Date((Long)ioResult);
                            continue;
                        }
                        if (ioResult instanceof Date) continue;
                        ioResult = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateTimeFormatInstance().parse(ioResult.toString());
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.TOJSON.id) {
                        ioResult = ioResult != null && ioResult instanceof ODocument ? ((ODocument)ioResult).toJSON() : null;
                        continue;
                    }
                    if (operator == OSQLFilterFieldOperator.KEYS.id) {
                        ioResult = ioResult != null && ioResult instanceof Map ? ((Map)ioResult).keySet() : null;
                        continue;
                    }
                    if (operator != OSQLFilterFieldOperator.VALUES.id) continue;
                    ioResult = ioResult != null && ioResult instanceof Map ? ((Map)ioResult).values() : null;
                }
            }
            catch (ParseException e) {
                OLogManager.instance().exception("Error on conversion of value '%s' using field operator %s", e, OCommandExecutionException.class, new Object[]{ioResult, OSQLFilterFieldOperator.getById(operator)});
            }
        }
        return ioResult;
    }

    public boolean hasChainOperators() {
        return this.operationsChain != null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String root = this.getRoot();
        if (root != null) {
            buffer.append(root);
        }
        if (this.operationsChain != null) {
            for (OPair<Integer, List<String>> op : this.operationsChain) {
                buffer.append('.');
                buffer.append((Object)OSQLFilterFieldOperator.getById((Integer)op.getKey()));
                if (op.getValue() == null) continue;
                List<String> values = op.getValue();
                buffer.append('(');
                int i = 0;
                for (String v : values) {
                    if (i++ > 0) {
                        buffer.append(',');
                    }
                    buffer.append(v);
                }
                buffer.append(')');
            }
        }
        return buffer.toString();
    }

    public Object getParameterValue(OIdentifiable iRecord, String iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue.charAt(0) == '\'' || iValue.charAt(0) == '\"') {
            return iValue.substring(1, iValue.length() - 1);
        }
        return ((ODocument)iRecord.getRecord()).field(iValue);
    }
}

