/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OCommandSQLResultset;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLFilter
extends OSQLPredicate
implements OCommandPredicate {
    protected Iterable<? extends OIdentifiable> targetRecords;
    protected Map<String, String> targetClusters;
    protected Map<OClass, String> targetClasses;
    protected String targetIndex;

    public OSQLFilter(String iText, OCommandContext iContext) {
        this.context = iContext;
        this.text = iText;
        this.textUpperCase = iText.toUpperCase();
        try {
            if (this.extractTargets() && this.parserOptionalKeyword("WHERE", "LIMIT", "ORDER", "SKIP")) {
                if (this.parserGetLastWord().equals("WHERE")) {
                    int lastPos = this.parserGetCurrentPosition();
                    String lastText = this.text;
                    String lastTextUpperCase = this.textUpperCase;
                    this.text(this.text.substring(lastPos));
                    this.text = lastText;
                    this.textUpperCase = lastTextUpperCase;
                    this.parserMoveCurrentPosition(lastPos);
                } else {
                    this.parserGoBack();
                }
            }
        }
        catch (OQueryParsingException e) {
            if (e.getText() == null) {
                throw new OQueryParsingException("Error on parsing query", this.text, this.parserGetCurrentPosition(), e);
            }
            throw e;
        }
        catch (Throwable t) {
            throw new OQueryParsingException("Error on parsing query", this.text, this.parserGetCurrentPosition(), t);
        }
    }

    @Override
    public boolean evaluate(ORecord<?> iRecord, OCommandContext iContext) {
        if (this.rootCondition == null) {
            return true;
        }
        return (Boolean)this.rootCondition.evaluate(iRecord, iContext);
    }

    private boolean extractTargets() {
        this.parserSkipWhiteSpaces();
        if (this.parserIsEnded()) {
            throw new OQueryParsingException("No query target found", this.text, 0);
        }
        char c = this.parserGetCurrentChar();
        if (c == '#' || Character.isDigit(c)) {
            this.targetRecords = new ArrayList<OIdentifiable>();
            ((List)this.targetRecords).add(new ORecordId(this.parserRequiredWord(true, "No valid RID")));
        } else if (c == '(') {
            StringBuilder subText = new StringBuilder();
            this.parserSetCurrentPosition(OStringSerializerHelper.getEmbedded(this.text, this.parserGetCurrentPosition(), -1, subText));
            OCommandSQLResultset subCommand = new OCommandSQLResultset(subText.toString());
            OCommandExecutor executor = OCommandManager.instance().getExecutor(subCommand);
            executor.setProgressListener(subCommand.getProgressListener());
            executor.parse(subCommand);
            subCommand.setContext(executor.getContext());
            if (!(executor instanceof Iterable)) {
                throw new OCommandSQLParsingException("Sub-query cannot be iterated because doesn't implement the Iterable interface: " + subCommand);
            }
            this.targetRecords = (Iterable)((Object)executor);
            OCommandContext subContext = subCommand.getContext();
            if (this.context != null) {
                this.context.merge(subContext);
            } else {
                this.context = subContext;
            }
        } else if (c == '[') {
            ArrayList<String> rids = new ArrayList<String>();
            this.parserSetCurrentPosition(OStringSerializerHelper.getCollection(this.text, this.parserGetCurrentPosition(), rids));
            this.targetRecords = new ArrayList<OIdentifiable>();
            for (String rid : rids) {
                ((List)this.targetRecords).add(new ORecordId(rid));
            }
            this.parserMoveCurrentPosition(1);
        } else {
            while (!this.parserIsEnded() && this.targetClasses == null && this.targetClusters == null && this.targetIndex == null) {
                OClass cls;
                String subjectName = this.parserRequiredWord(true, "Target not found");
                String alias = subjectName.equals("AS") ? this.parserRequiredWord(true, "Alias not found") : subjectName;
                String subjectToMatch = subjectName;
                if (subjectToMatch.startsWith("CLUSTER:")) {
                    if (this.targetClusters == null) {
                        this.targetClusters = new HashMap<String, String>();
                    }
                    this.targetClusters.put(subjectName.substring("CLUSTER:".length()), alias);
                    continue;
                }
                if (subjectToMatch.startsWith("INDEX:")) {
                    this.targetIndex = subjectName.substring("INDEX:".length());
                    continue;
                }
                if (subjectToMatch.startsWith("CLASS:")) {
                    subjectName = subjectName.substring("CLASS:".length());
                }
                if (this.targetClasses == null) {
                    this.targetClasses = new HashMap<OClass, String>();
                }
                if ((cls = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(subjectName)) == null) {
                    throw new OCommandExecutionException("Class '" + subjectName + "' was not found in current database");
                }
                this.targetClasses.put(cls, alias);
            }
        }
        return !this.parserIsEnded();
    }

    public Map<String, String> getTargetClusters() {
        return this.targetClusters;
    }

    public Map<OClass, String> getTargetClasses() {
        return this.targetClasses;
    }

    public Iterable<? extends OIdentifiable> getTargetRecords() {
        return this.targetRecords;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    @Override
    public OSQLFilterCondition getRootCondition() {
        return this.rootCondition;
    }

    @Override
    public String toString() {
        if (this.rootCondition != null) {
            return "Parsed: " + this.rootCondition.toString();
        }
        return "Unparsed: " + this.text;
    }
}

