/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLUpdate
extends OCommandExecutorSQLSetAware
implements OCommandResultListener {
    public static final String KEYWORD_UPDATE = "UPDATE";
    private static final String KEYWORD_ADD = "ADD";
    private static final String KEYWORD_PUT = "PUT";
    private static final String KEYWORD_REMOVE = "REMOVE";
    private static final String KEYWORD_INCREMENT = "INCREMENT";
    private Map<String, Object> setEntries = new LinkedHashMap<String, Object>();
    private List<OPair<String, Object>> addEntries = new ArrayList<OPair<String, Object>>();
    private Map<String, OPair<String, Object>> putEntries = new LinkedHashMap<String, OPair<String, Object>>();
    private List<OPair<String, Object>> removeEntries = new ArrayList<OPair<String, Object>>();
    private Map<String, Number> incrementEntries = new LinkedHashMap<String, Number>();
    private OQuery<?> query;
    private int recordCount = 0;
    private String subjectName;
    private static final Object EMPTY_VALUE = new Object();
    private OCommandParameters parameters;

    public OCommandExecutorSQLUpdate parse(OCommandRequest iRequest) {
        String additionalStatement;
        ODatabaseRecord database = OCommandExecutorSQLUpdate.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        this.setEntries.clear();
        this.addEntries.clear();
        this.putEntries.clear();
        this.removeEntries.clear();
        this.incrementEntries.clear();
        this.query = null;
        this.recordCount = 0;
        this.parserRequiredKeyword(KEYWORD_UPDATE);
        this.subjectName = this.parserRequiredWord(true, "Invalid target");
        this.parserNextWord(true);
        String word = this.parserGetLastWord();
        if (this.parserIsEnded() || !word.equals("SET") && !word.equals(KEYWORD_ADD) && !word.equals(KEYWORD_PUT) && !word.equals(KEYWORD_REMOVE) && !word.equals(KEYWORD_INCREMENT)) {
            this.throwSyntaxErrorException("Expected keyword SET,ADD,PUT,REMOVE or INCREMENT");
        }
        while (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE")) {
            word = this.parserGetLastWord();
            if (word.equals("SET")) {
                this.parseSetFields(this.setEntries);
            } else if (word.equals(KEYWORD_ADD)) {
                this.parseAddFields();
            } else if (word.equals(KEYWORD_PUT)) {
                this.parsePutFields();
            } else if (word.equals(KEYWORD_REMOVE)) {
                this.parseRemoveFields();
            } else {
                if (!word.equals(KEYWORD_INCREMENT)) break;
                this.parseIncrementFields();
            }
            this.parserNextWord(true);
        }
        this.query = (additionalStatement = this.parserGetLastWord()).equals("WHERE") || additionalStatement.equals("LIMIT") ? new OSQLAsynchQuery("select from " + this.subjectName + " " + additionalStatement + " " + this.text.substring(this.parserGetCurrentPosition()), this) : new OSQLAsynchQuery("select from " + this.subjectName, this);
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.subjectName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        this.parameters = new OCommandParameters(iArgs);
        HashMap<Integer, Object> queryArgs = new HashMap<Integer, Object>();
        for (int i = this.parameterCounter; i < this.parameters.size(); ++i) {
            if (this.parameters.getByName(i) == null) continue;
            queryArgs.put(i - this.parameterCounter, this.parameters.getByName(i));
        }
        OCommandExecutorSQLUpdate.getDatabase().query(this.query, queryArgs);
        return this.recordCount;
    }

    @Override
    public boolean result(Object iRecord) {
        Map map;
        Object v;
        Object fieldValue;
        Collection coll;
        ODocument record = (ODocument)iRecord;
        boolean recordUpdated = false;
        this.parameters.reset();
        if (!this.setEntries.isEmpty()) {
            OSQLHelper.bindParameters(record, this.setEntries, this.parameters);
            recordUpdated = true;
        }
        for (Map.Entry<String, Number> entry : this.incrementEntries.entrySet()) {
            Number prevValue = (Number)record.field(entry.getKey());
            if (prevValue == null) {
                record.field(entry.getKey(), entry.getValue());
            } else {
                record.field(entry.getKey(), OType.increment(prevValue, entry.getValue()));
            }
            recordUpdated = true;
        }
        for (OPair<String, Object> entry : this.addEntries) {
            coll = null;
            if (!record.containsField((String)entry.getKey())) {
                OProperty prop;
                if (record.getSchemaClass() != null && (prop = record.getSchemaClass().getProperty((String)entry.getKey())) != null && prop.getType() == OType.LINKSET) {
                    coll = new HashSet();
                }
                if (coll == null) {
                    coll = new ArrayList();
                }
                record.field((String)entry.getKey(), coll);
            } else {
                fieldValue = record.field((String)entry.getKey());
                if (!(fieldValue instanceof Collection)) continue;
                coll = (Collection)fieldValue;
            }
            v = entry.getValue();
            if (v instanceof OSQLFilterItem) {
                v = ((OSQLFilterItem)v).getValue(record, this.context);
            } else if (v instanceof OSQLFunctionRuntime) {
                v = ((OSQLFunctionRuntime)v).execute(record, this);
            }
            coll.add(v);
            recordUpdated = true;
        }
        for (Map.Entry<String, OPair<String, Object>> entry : this.putEntries.entrySet()) {
            fieldValue = record.field(entry.getKey());
            if (fieldValue == null) {
                OProperty property;
                if (record.getSchemaClass() != null && (property = record.getSchemaClass().getProperty(entry.getKey())) != null && property.getType() != null && !property.getType().equals((Object)OType.EMBEDDEDMAP) && !property.getType().equals((Object)OType.LINKMAP)) {
                    throw new OCommandExecutionException("field " + entry.getKey() + " is not defined as a map");
                }
                fieldValue = new HashMap();
                record.field(entry.getKey(), fieldValue);
            }
            if (!(fieldValue instanceof Map)) continue;
            map = (Map)fieldValue;
            OPair<String, Object> pair = entry.getValue();
            if (pair.getValue() instanceof OSQLFilterItem) {
                pair.setValue(((OSQLFilterItem)pair.getValue()).getValue(record, null));
            } else if (pair.getValue() instanceof OSQLFunctionRuntime) {
                v = ((OSQLFunctionRuntime)pair.getValue()).execute(record, this);
            }
            map.put(pair.getKey(), pair.getValue());
            recordUpdated = true;
        }
        for (OPair oPair : this.removeEntries) {
            v = oPair.getValue();
            if (v == EMPTY_VALUE) {
                record.removeField((String)oPair.getKey());
                recordUpdated = true;
                continue;
            }
            fieldValue = record.field((String)oPair.getKey());
            if (fieldValue instanceof Collection) {
                coll = (Collection)fieldValue;
                if (!coll.remove(v)) continue;
                recordUpdated = true;
                continue;
            }
            if (!(fieldValue instanceof Map) || (map = (Map)fieldValue).remove(v) == null) continue;
            recordUpdated = true;
        }
        if (recordUpdated) {
            record.setDirty();
            record.save();
            ++this.recordCount;
        }
        return true;
    }

    private void parseAddFields() {
        while (!(this.parserIsEnded() || this.addEntries.size() != 0 && this.parserGetLastSeparator() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword("=");
            String fieldValue = this.parserRequiredWord(false, "Value expected", " =><,\r\n");
            this.addEntries.add(new OPair<String, Object>(fieldName, this.getFieldValueCountingParameters(fieldValue)));
        }
        if (this.addEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to add <field> = <value> are missed. Example: name = 'Bill', salary = 300.2.");
        }
    }

    private void parsePutFields() {
        while (!(this.parserIsEnded() || this.setEntries.size() != 0 && this.parserGetLastSeparator() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword("=");
            String fieldKey = this.parserRequiredWord(false, "Key expected");
            String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected", " =><,\r\n"));
            this.putEntries.put(fieldName, new OPair<String, Object>((String)this.getFieldValueCountingParameters(fieldKey), this.getFieldValueCountingParameters(fieldValue)));
        }
        if (this.putEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to put <field> = <key>, <value> are missed. Example: name = 'Bill', 30");
        }
    }

    private void parseRemoveFields() {
        while (!(this.parserIsEnded() || this.removeEntries.size() != 0 && this.parserGetLastSeparator() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            Object value;
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            boolean equals = this.parserOptionalKeyword("=");
            if (equals) {
                String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected"));
                value = this.getFieldValueCountingParameters(fieldValue);
            } else {
                value = EMPTY_VALUE;
            }
            this.removeEntries.add(new OPair<String, Object>(fieldName, value));
        }
        if (this.removeEntries.size() == 0) {
            this.throwSyntaxErrorException("Field(s) to remove are missed. Example: name, salary");
        }
    }

    private void parseIncrementFields() {
        while (!(this.parserIsEnded() || this.incrementEntries.size() != 0 && this.parserGetLastSeparator() != ',' || this.parserGetLastWord().equals("WHERE"))) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword("=");
            String fieldValue = this.getBlock(this.parserRequiredWord(false, "Value expected"));
            this.incrementEntries.put(fieldName, (Number)this.getFieldValueCountingParameters(fieldValue));
        }
        if (this.incrementEntries.size() == 0) {
            this.throwSyntaxErrorException("Entries to increment <field> = <value> are missed. Example: salary = -100");
        }
    }

    @Override
    public String getSyntax() {
        return "UPDATE <class>|cluster:<cluster>> [SET|ADD|PUT|REMOVE|INCREMENT] [[,] <field-name> = <field-value>]* [WHERE <conditions>]";
    }

    protected String getBlock(String fieldValue) {
        if (fieldValue.startsWith("{") || fieldValue.startsWith("[") || fieldValue.startsWith("[")) {
            this.parserSkipWhiteSpaces();
            StringBuilder buffer = new StringBuilder();
            this.parserSetCurrentPosition(OStringSerializerHelper.parse(this.text, buffer, this.parserGetCurrentPosition(), -1, OStringSerializerHelper.DEFAULT_FIELD_SEPARATOR, true, OStringSerializerHelper.DEFAULT_IGNORE_CHARS));
            fieldValue = buffer.toString();
        }
        return fieldValue;
    }
}

