/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLTruncateClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_TRUNCATE = "TRUNCATE";
    public static final String KEYWORD_CLASS = "CLASS";
    private OClass schemaClass;

    public OCommandExecutorSQLTruncateClass parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLTruncateClass.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLTruncateClass.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_TRUNCATE)) {
            throw new OCommandSQLParsingException("Keyword TRUNCATE not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLTruncateClass.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLTruncateClass.nextWord(this.text, this.text, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Expected class name. Use " + this.getSyntax(), this.text, oldPos);
        }
        String className = word.toString();
        this.schemaClass = database.getMetadata().getSchema().getClass(className);
        if (this.schemaClass == null) {
            throw new OCommandSQLParsingException("Class '" + className + "' not found", this.text, oldPos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.schemaClass == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        long recs = this.schemaClass.count();
        try {
            this.schemaClass.truncate();
        }
        catch (IOException e) {
            throw new OCommandExecutionException("Error on executing command", e);
        }
        return recs;
    }

    @Override
    public String getSyntax() {
        return "TRUNCATE CLASS <class-name>";
    }
}

