/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OCommandExecutorSQLSetAware
extends OCommandExecutorSQLAbstract {
    protected static final String KEYWORD_SET = "SET";
    protected int parameterCounter = 0;

    protected void parseSetFields(Map<String, Object> fields) {
        while (!(this.parserIsEnded() || fields.size() != 0 && this.parserGetLastSeparator() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserRequiredKeyword("=");
            String fieldValue = this.parserRequiredWord(false, "Value expected", " =><,\r\n");
            if (fieldValue.startsWith("{") || fieldValue.startsWith("[") || fieldValue.startsWith("[")) {
                StringBuilder buffer = new StringBuilder();
                this.parserSetCurrentPosition(OStringSerializerHelper.parse(this.text, buffer, this.parserGetPreviousPosition(), -1, OStringSerializerHelper.DEFAULT_FIELD_SEPARATOR, true, OStringSerializerHelper.DEFAULT_IGNORE_CHARS));
                fieldValue = buffer.toString();
                this.parserSetLastSeparator(' ');
            }
            fields.put(fieldName, this.getFieldValueCountingParameters(fieldValue));
        }
        if (fields.size() == 0) {
            this.throwParsingException("Entries to set <field> = <value> are missed. Example: name = 'Bill', salary = 300.2");
        }
    }

    protected Object getFieldValueCountingParameters(String fieldValue) {
        if (fieldValue.trim().equals("?")) {
            ++this.parameterCounter;
        }
        return OSQLHelper.parseValue(this, fieldValue, this.context);
    }
}

