/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OIndexProxy;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLSelect
extends OCommandExecutorSQLResultsetAbstract {
    private static final String KEYWORD_AS = " AS ";
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_ASC = "ASC";
    public static final String KEYWORD_DESC = "DESC";
    public static final String KEYWORD_ORDER = "ORDER";
    public static final String KEYWORD_BY = "BY";
    public static final String KEYWORD_ORDER_BY = "ORDER BY";
    private Map<String, Object> projections = null;
    private List<OPair<String, String>> orderedFields;
    private Object flattenTarget;
    private boolean anyFunctionAggregates = false;
    private int fetchLimit = -1;
    private OIdentifiable lastRecord;
    private Iterator<OIdentifiable> subIterator;

    @Override
    public OCommandExecutorSQLSelect parse(OCommandRequest iRequest) {
        super.parse(iRequest);
        int pos = this.parseProjections();
        if (pos == -1) {
            return this;
        }
        int endPosition = this.text.length();
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        this.compiledFilter = OSQLEngine.getInstance().parseFromWhereCondition(this.text.substring(pos, endPosition), this.context);
        this.optimize();
        this.parserSetCurrentPosition(this.compiledFilter.parserIsEnded() ? endPosition : this.compiledFilter.parserGetCurrentPosition() + pos);
        if (!this.parserIsEnded()) {
            this.parserSkipWhiteSpaces();
            while (!this.parserIsEnded()) {
                this.parserNextWord(true);
                if (this.parserIsEnded()) continue;
                String w = this.parserGetLastWord();
                if (w.equals(KEYWORD_ORDER)) {
                    this.parseOrderBy(w);
                    continue;
                }
                if (w.equals("LIMIT")) {
                    this.parseLimit(w);
                    continue;
                }
                if (w.equals("SKIP")) {
                    this.parseSkip(w);
                    continue;
                }
                throw new OCommandSQLParsingException("Invalid keyword '" + w + "'");
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.lastRecord == null) {
            this.lastRecord = this.next();
        }
        return this.lastRecord != null;
    }

    @Override
    public OIdentifiable next() {
        if (this.lastRecord != null) {
            OIdentifiable result = this.lastRecord;
            this.lastRecord = null;
            return result;
        }
        if (this.subIterator == null) {
            if (this.target == null) {
                this.executeSearch(null);
                this.applyFlatten();
                this.applyProjections();
                this.subIterator = new ArrayList<OIdentifiable>(this.getResult()).iterator();
                this.lastRecord = null;
                this.tempResult = null;
            } else {
                this.subIterator = this.target.iterator();
            }
        }
        if (this.lastRecord == null && this.subIterator != null) {
            while (this.subIterator.hasNext()) {
                this.lastRecord = this.subIterator.next();
                if (this.lastRecord == null) continue;
                return this.lastRecord;
            }
        }
        return this.lastRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (!this.optimizeExecution()) {
            this.fetchLimit = this.getQueryFetchLimit();
            this.executeSearch(iArgs);
            this.applyFlatten();
            this.applyProjections();
            this.applyOrderBy();
            this.applyLimitAndSkip();
        }
        return this.handleResult();
    }

    protected void executeSearch(Map<Object, Object> iArgs) {
        OIdentifiable id;
        this.assignTarget(iArgs);
        if (this.target == null) {
            return;
        }
        Iterator i$ = this.target.iterator();
        while (i$.hasNext() && this.executeSearchRecord(id = (OIdentifiable)i$.next())) {
        }
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (!super.assignTarget(iArgs)) {
            if (this.compiledFilter.getTargetIndex() != null) {
                this.searchInIndex();
            } else {
                throw new OQueryParsingException("No source found in query: specify class, cluster(s), index or single record(s). Use " + this.getSyntax());
            }
        }
        return true;
    }

    protected boolean executeSearchRecord(OIdentifiable id) {
        ORecordInternal record = (ORecordInternal)id.getRecord();
        if (record == null || record.getRecordType() != 100) {
            return true;
        }
        return !this.filter(record) || this.handleResult(record);
    }

    @Override
    protected boolean handleResult(OIdentifiable iRecord) {
        this.lastRecord = null;
        if (this.orderedFields == null && this.skip > 0) {
            --this.skip;
            return true;
        }
        this.lastRecord = iRecord instanceof ORecord ? ((ORecord)iRecord).copy() : iRecord.getIdentity().copy();
        this.lastRecord = this.applyProjections(this.lastRecord);
        ++this.resultCount;
        this.addResult(this.lastRecord);
        return this.orderedFields != null || this.fetchLimit <= -1 || this.resultCount < this.fetchLimit;
    }

    protected void addResult(OIdentifiable iRecord) {
        if (iRecord != null) {
            if (this.anyFunctionAggregates || this.orderedFields != null || this.flattenTarget != null) {
                if (this.tempResult == null) {
                    this.tempResult = new ArrayList();
                }
                this.tempResult.add(iRecord);
            } else if (this.subIterator == null && this.request.getResultListener() != null) {
                this.request.getResultListener().result(iRecord);
            }
        }
    }

    private int getQueryFetchLimit() {
        if (this.orderedFields != null) {
            return -1;
        }
        int sqlLimit = this.limit > -1 ? this.limit : -1;
        int requestLimit = this.request.getLimit() > -1 ? this.request.getLimit() : -1;
        if (sqlLimit == -1) {
            return requestLimit;
        }
        if (requestLimit == -1) {
            return sqlLimit;
        }
        return Math.min(sqlLimit, requestLimit);
    }

    public Map<String, Object> getProjections() {
        return this.projections;
    }

    public List<OPair<String, String>> getOrderedFields() {
        return this.orderedFields;
    }

    protected void parseOrderBy(String w) {
        this.parserRequiredKeyword(KEYWORD_BY);
        String fieldOrdering = null;
        this.orderedFields = new ArrayList<OPair<String, String>>();
        while (!(this.parserIsEnded() || this.orderedFields.size() != 0 && this.parserGetLastSeparator() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            this.parserOptionalWord(true);
            String word = this.parserGetLastWord();
            if (word.length() == 0) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals("LIMIT")) {
                fieldOrdering = KEYWORD_ASC;
                this.parserGoBack();
            } else if (word.equals(KEYWORD_ASC)) {
                fieldOrdering = KEYWORD_ASC;
            } else if (word.equals(KEYWORD_DESC)) {
                fieldOrdering = KEYWORD_DESC;
            } else {
                this.throwParsingException("Ordering mode '" + word + "' not supported. Valid is 'ASC', 'DESC' or nothing ('ASC' by default)");
            }
            this.orderedFields.add(new OPair<String, String>(fieldName, fieldOrdering));
        }
        if (this.orderedFields.size() == 0) {
            this.throwParsingException("Order by field set was missed. Example: ORDER BY name ASC, salary DESC");
        }
    }

    @Override
    protected void searchInClasses() {
        OClass cls = this.compiledFilter.getTargetClasses().keySet().iterator().next();
        if (this.searchForIndexes(cls)) {
            OProfiler.getInstance().updateCounter("Query.indexUsage", 1L);
        } else {
            super.searchInClasses();
        }
    }

    private boolean searchForIndexes(OClass iSchemaClass) {
        ODatabaseRecord database = OCommandExecutorSQLSelect.getDatabase();
        database.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iSchemaClass.getName().toLowerCase());
        ArrayList<OIndexSearchResult> indexSearchResults = new ArrayList<OIndexSearchResult>();
        OCommandExecutorSQLSelect.analyzeQueryBranch(iSchemaClass, this.compiledFilter.getRootCondition(), indexSearchResults);
        Collections.sort(indexSearchResults, new Comparator<OIndexSearchResult>(){

            @Override
            public int compare(OIndexSearchResult searchResultOne, OIndexSearchResult searchResultTwo) {
                return searchResultTwo.getFieldCount() - searchResultOne.getFieldCount();
            }
        });
        for (OIndexSearchResult searchResult : indexSearchResults) {
            List<OIndex<?>> involvedIndexes = OCommandExecutorSQLSelect.getInvolvedIndexes(iSchemaClass, searchResult);
            Collections.sort(involvedIndexes, IndexComparator.INSTANCE);
            for (OIndex<?> index : involvedIndexes) {
                Object result;
                Object v;
                String relatedIndexField;
                String lastFiled;
                OIndexDefinition indexDefinition = index.getDefinition();
                OQueryOperator operator = searchResult.lastOperator;
                if (!OIndexSearchResult.isIndexEqualityOperator(operator) && !(lastFiled = searchResult.lastField.getItemName(searchResult.lastField.getItemCount() - 1)).equals(relatedIndexField = indexDefinition.getFields().get(searchResult.fieldValuePairs.size()))) continue;
                int searchResultFieldsCount = searchResult.fields().size();
                ArrayList<Object> keyParams = new ArrayList<Object>(searchResultFieldsCount);
                for (String fieldName : indexDefinition.getFields().subList(0, searchResultFieldsCount)) {
                    Object fieldValue = searchResult.fieldValuePairs.get(fieldName);
                    if (fieldValue != null) {
                        keyParams.add(fieldValue);
                        continue;
                    }
                    keyParams.add(searchResult.lastValue);
                }
                OQueryOperator.INDEX_OPERATION_TYPE opType = null;
                if (this.projections != null && this.projections.size() == 1 && (v = this.projections.values().iterator().next()) instanceof OSQLFunctionRuntime && ((OSQLFunctionRuntime)v).getFunction() instanceof OSQLFunctionCount) {
                    opType = OQueryOperator.INDEX_OPERATION_TYPE.COUNT;
                }
                if (opType == null) {
                    opType = OQueryOperator.INDEX_OPERATION_TYPE.GET;
                }
                if ((result = operator.executeIndexQuery(index, opType, keyParams, this.fetchLimit)) == null) continue;
                if (opType == OQueryOperator.INDEX_OPERATION_TYPE.COUNT) {
                    String projName = this.projections.keySet().iterator().next();
                    this.projections.clear();
                    this.anyFunctionAggregates = false;
                    this.addResult(new ODocument().field(projName, result));
                } else {
                    this.fillSearchIndexResultSet(result);
                }
                return true;
            }
        }
        return false;
    }

    private static List<OIndex<?>> getInvolvedIndexes(OClass iSchemaClass, OIndexSearchResult searchResultFields) {
        Set<OIndex<?>> involvedIndexes = iSchemaClass.getInvolvedIndexes(searchResultFields.fields());
        ArrayList result = new ArrayList(involvedIndexes.size());
        for (OIndex<?> involvedIndex : involvedIndexes) {
            if (searchResultFields.lastField.isLong()) {
                result.addAll(OIndexProxy.createdProxy(involvedIndex, searchResultFields.lastField, OCommandExecutorSQLSelect.getDatabase()));
                continue;
            }
            result.add(involvedIndex);
        }
        return result;
    }

    private static OIndexSearchResult analyzeQueryBranch(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults) {
        if (iCondition == null) {
            return null;
        }
        OQueryOperator operator = iCondition.getOperator();
        while (operator == null) {
            if (iCondition.getRight() == null && iCondition.getLeft() instanceof OSQLFilterCondition) {
                iCondition = (OSQLFilterCondition)iCondition.getLeft();
                operator = iCondition.getOperator();
                continue;
            }
            return null;
        }
        OIndexReuseType indexReuseType = operator.getIndexReuseType(iCondition.getLeft(), iCondition.getRight());
        if (indexReuseType.equals((Object)OIndexReuseType.INDEX_INTERSECTION)) {
            OIndexSearchResult leftResult = OCommandExecutorSQLSelect.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getLeft(), iIndexSearchResults);
            OIndexSearchResult rightResult = OCommandExecutorSQLSelect.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getRight(), iIndexSearchResults);
            if (leftResult != null && rightResult != null && leftResult.canBeMerged(rightResult)) {
                OIndexSearchResult mergeResult = leftResult.merge(rightResult);
                if (iSchemaClass.areIndexed(mergeResult.fields())) {
                    iIndexSearchResults.add(mergeResult);
                }
                return leftResult.merge(rightResult);
            }
            return null;
        }
        if (indexReuseType.equals((Object)OIndexReuseType.INDEX_METHOD)) {
            OIndexSearchResult result = OCommandExecutorSQLSelect.createIndexedProperty(iCondition, iCondition.getLeft());
            if (result == null) {
                result = OCommandExecutorSQLSelect.createIndexedProperty(iCondition, iCondition.getRight());
            }
            if (result == null) {
                return null;
            }
            if (OCommandExecutorSQLSelect.checkIndexExistence(iSchemaClass, result)) {
                iIndexSearchResults.add(result);
            }
            return result;
        }
        return null;
    }

    private static OIndexSearchResult createIndexedProperty(OSQLFilterCondition iCondition, Object iItem) {
        Object origValue;
        if (iItem == null || !(iItem instanceof OSQLFilterItemField)) {
            return null;
        }
        if (iCondition.getLeft() instanceof OSQLFilterItemField && iCondition.getRight() instanceof OSQLFilterItemField) {
            return null;
        }
        OSQLFilterItemField item = (OSQLFilterItemField)iItem;
        if (item.hasChainOperators() && !item.isFieldChain()) {
            return null;
        }
        Object object = origValue = iCondition.getLeft() == iItem ? iCondition.getRight() : iCondition.getLeft();
        if (iCondition.getOperator() instanceof OQueryOperatorBetween || iCondition.getOperator() instanceof OQueryOperatorIn) {
            return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), origValue);
        }
        Object value = OSQLHelper.getValue(origValue);
        if (value == null) {
            return null;
        }
        return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), value);
    }

    private void fillSearchIndexResultSet(Object indexResult) {
        if (indexResult != null) {
            if (indexResult instanceof Collection) {
                Collection indexResultSet = (Collection)indexResult;
                for (OIdentifiable identifiable : indexResultSet) {
                    boolean continueResultParsing;
                    Object record = identifiable.getRecord();
                    if (record == null) {
                        throw new OException("Error during loading record with id : " + identifiable.getIdentity());
                    }
                    if (!this.filter((ORecordInternal)record) || (continueResultParsing = this.handleResult((OIdentifiable)record))) continue;
                    break;
                }
            } else {
                Object record = ((OIdentifiable)indexResult).getRecord();
                if (this.filter((ORecordInternal)record)) {
                    this.handleResult((OIdentifiable)record);
                }
            }
        }
    }

    protected int parseProjections() {
        String projectionString;
        if (!this.parserOptionalKeyword(KEYWORD_SELECT)) {
            return -1;
        }
        int fromPosition = this.textUpperCase.indexOf(" FROM ", this.parserGetCurrentPosition());
        if (fromPosition == -1) {
            this.throwParsingException("Missed FROM");
        }
        if ((projectionString = this.text.substring(this.parserGetCurrentPosition(), fromPosition).trim()).length() > 0 && !projectionString.equals("*")) {
            this.projections = new LinkedHashMap<String, Object>();
            List<String> items = OStringSerializerHelper.smartSplit(projectionString, ',', new char[0]);
            for (String projection : items) {
                projection = projection.trim();
                if (this.projections == null) {
                    throw new OCommandSQLParsingException("Projection not allowed with FLATTEN() operator");
                }
                String fieldName = null;
                int endPos = projection.toUpperCase(Locale.ENGLISH).indexOf(KEYWORD_AS);
                if (endPos > -1) {
                    fieldName = projection.substring(endPos + KEYWORD_AS.length()).trim();
                    projection = projection.substring(0, endPos).trim();
                    if (this.projections.containsKey(fieldName)) {
                        throw new OCommandSQLParsingException("Field '" + fieldName + "' is duplicated in current SELECT, choose a different name");
                    }
                } else {
                    int beginPos = projection.charAt(0) == '@' ? 1 : 0;
                    endPos = this.extractProjectionNameSubstringEndPosition(projection);
                    fieldName = endPos > -1 ? projection.substring(beginPos, endPos) : projection.substring(beginPos);
                    fieldName = OStringSerializerHelper.getStringContent(fieldName);
                    int fieldIndex = 2;
                    while (this.projections.containsKey(fieldName)) {
                        fieldName = fieldName + fieldIndex;
                        ++fieldIndex;
                    }
                }
                if (projection.toUpperCase(Locale.ENGLISH).startsWith("FLATTEN(")) {
                    List<String> pars = OStringSerializerHelper.getParameters(projection);
                    if (pars.size() != 1) {
                        throw new OCommandSQLParsingException("FLATTEN operator expects the field name as parameter. Example FLATTEN( out )");
                    }
                    this.flattenTarget = OSQLHelper.parseValue(this, pars.get(0).trim(), this.context);
                    this.projections = null;
                    if (this.anyFunctionAggregates || !(this.flattenTarget instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)this.flattenTarget).aggregateResults()) continue;
                    this.anyFunctionAggregates = true;
                    continue;
                }
                Object projectionValue = OSQLHelper.parseValue(this, projection, this.context);
                this.projections.put(fieldName, projectionValue);
                if (this.anyFunctionAggregates || !(projectionValue instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)projectionValue).aggregateResults()) continue;
                this.anyFunctionAggregates = true;
            }
        }
        this.parserSetCurrentPosition(fromPosition + "FROM".length() + 1);
        return this.parserGetCurrentPosition();
    }

    protected int extractProjectionNameSubstringEndPosition(String projection) {
        int endPos;
        int pos1 = projection.indexOf(46);
        int pos2 = projection.indexOf(40);
        int pos3 = projection.indexOf(91);
        if (pos1 > -1 && pos2 == -1 && pos3 == -1) {
            endPos = pos1;
        } else if (pos2 > -1 && pos1 == -1 && pos3 == -1) {
            endPos = pos2;
        } else if (pos3 > -1 && pos1 == -1 && pos2 == -1) {
            endPos = pos3;
        } else if (pos1 > -1 && pos2 > -1 && pos3 == -1) {
            endPos = Math.min(pos1, pos2);
        } else if (pos2 > -1 && pos3 > -1 && pos1 == -1) {
            endPos = Math.min(pos2, pos3);
        } else if (pos1 > -1 && pos3 > -1 && pos2 == -1) {
            endPos = Math.min(pos1, pos3);
        } else if (pos1 > -1 && pos2 > -1 && pos3 > -1) {
            endPos = Math.min(pos1, pos2);
            endPos = Math.min(endPos, pos3);
        } else {
            endPos = -1;
        }
        return endPos;
    }

    private void applyOrderBy() {
        if (this.orderedFields == null) {
            return;
        }
        ODocumentHelper.sort(this.getResult(), this.orderedFields);
        this.orderedFields.clear();
    }

    private void applyFlatten() {
        if (this.flattenTarget == null) {
            return;
        }
        ArrayList<Object> finalResult = new ArrayList<Object>();
        if (this.tempResult != null) {
            for (OIdentifiable id : this.tempResult) {
                Object fieldValue = this.flattenTarget instanceof OSQLFilterItem ? ((OSQLFilterItem)this.flattenTarget).getValue((OIdentifiable)id.getRecord(), this.context) : (this.flattenTarget instanceof OSQLFunctionRuntime ? ((OSQLFunctionRuntime)this.flattenTarget).getResult() : this.flattenTarget.toString());
                if (fieldValue == null) continue;
                if (fieldValue instanceof Collection) {
                    for (Object o : (Collection)fieldValue) {
                        if (o instanceof OIdentifiable) {
                            finalResult.add(((OIdentifiable)o).getRecord());
                            continue;
                        }
                        if (!(o instanceof List)) continue;
                        List list = (List)o;
                        for (int i = 0; i < list.size(); ++i) {
                            finalResult.add(((OIdentifiable)list.get(i)).getRecord());
                        }
                    }
                    continue;
                }
                finalResult.add((OIdentifiable)fieldValue);
            }
        }
        this.tempResult = finalResult;
    }

    private OIdentifiable applyProjections(OIdentifiable iRecord) {
        if (this.projections != null) {
            ODocument doc = (ODocument)iRecord.getRecord();
            ODocument result = new ODocument().setOrdered(true);
            ((ORecordId)result.getIdentity()).clusterId = -2;
            ((ORecordId)result.getIdentity()).clusterPosition = this.resultCount;
            boolean canExcludeResult = false;
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                Object value;
                if (projection.getValue().equals("*")) {
                    doc.copy(result);
                    value = null;
                } else if (projection.getValue().toString().startsWith("$")) {
                    value = this.context != null ? this.context.getVariable(projection.getValue().toString().substring(1)) : null;
                } else if (projection.getValue() instanceof OSQLFilterItemField) {
                    value = ((OSQLFilterItemField)projection.getValue()).getValue(doc, null);
                } else if (projection.getValue() instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                    canExcludeResult = f.filterResult();
                    value = f.execute(doc, this);
                } else {
                    value = projection.getValue();
                }
                if (value == null) continue;
                result.field(projection.getKey(), value);
            }
            if (canExcludeResult && result.isEmpty()) {
                return null;
            }
            if (this.anyFunctionAggregates) {
                return null;
            }
            return result;
        }
        return iRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void searchInIndex() {
        OIndex index = OCommandExecutorSQLSelect.getDatabase().getMetadata().getIndexManager().getIndex(this.compiledFilter.getTargetIndex());
        if (index == null) {
            throw new OCommandExecutionException("Target index '" + this.compiledFilter.getTargetIndex() + "' not found");
        }
        if (index.getDefinition() == null) {
            return;
        }
        if (this.compiledFilter.getRootCondition() != null) {
            if (!"KEY".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
                throw new OCommandExecutionException("'Key' field is required for queries against indexes");
            }
            OQueryOperator indexOperator = this.compiledFilter.getRootCondition().getOperator();
            if (indexOperator instanceof OQueryOperatorBetween) {
                OIdentifiable r;
                boolean continueResultParsing;
                Object[] values = (Object[])this.compiledFilter.getRootCondition().getRight();
                Collection<ODocument> entries = index.getEntriesBetween(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[0]), OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), values[2]));
                Iterator<ODocument> i$ = entries.iterator();
                while (i$.hasNext() && (continueResultParsing = this.handleResult(r = (OIdentifiable)i$.next()))) {
                }
                return;
            } else if (indexOperator instanceof OQueryOperatorMajor) {
                Object value = this.compiledFilter.getRootCondition().getRight();
                Collection<ODocument> entries = index.getEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), false);
                this.parseIndexSearchResult(entries);
                return;
            } else if (indexOperator instanceof OQueryOperatorMajorEquals) {
                Object value = this.compiledFilter.getRootCondition().getRight();
                Collection<ODocument> entries = index.getEntriesMajor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), true);
                this.parseIndexSearchResult(entries);
                return;
            } else if (indexOperator instanceof OQueryOperatorMinor) {
                Object value = this.compiledFilter.getRootCondition().getRight();
                Collection<ODocument> entries = index.getEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), false);
                this.parseIndexSearchResult(entries);
                return;
            } else if (indexOperator instanceof OQueryOperatorMinorEquals) {
                Object value = this.compiledFilter.getRootCondition().getRight();
                Collection<ODocument> entries = index.getEntriesMinor(OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), value), true);
                this.parseIndexSearchResult(entries);
                return;
            } else if (indexOperator instanceof OQueryOperatorIn) {
                List origValues = (List)this.compiledFilter.getRootCondition().getRight();
                ArrayList values = new ArrayList(origValues.size());
                for (Object val : origValues) {
                    if (index.getDefinition() instanceof OCompositeIndexDefinition) {
                        throw new OCommandExecutionException("Operator IN not supported yet.");
                    }
                    val = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), val);
                    values.add(val);
                }
                Collection<ODocument> entries = index.getEntries(values);
                this.parseIndexSearchResult(entries);
                return;
            } else {
                Object res;
                Object right = this.compiledFilter.getRootCondition().getRight();
                Object keyValue = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right);
                if (index.getDefinition().getParamCount() == 1) {
                    res = index.get(keyValue);
                } else {
                    Object secondKey = OCommandExecutorSQLSelect.getIndexKey(index.getDefinition(), right);
                    res = index.getValuesBetween(keyValue, secondKey);
                }
                if (res == null) return;
                if (res instanceof Collection) {
                    for (OIdentifiable r : (Collection)res) {
                        this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(keyValue, r.getIdentity()));
                    }
                    return;
                } else {
                    this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(keyValue, ((OIdentifiable)res).getIdentity()));
                }
            }
            return;
        }
        if (this.isIndexSizeQuery()) {
            Object projection = this.projections.values().iterator().next();
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
            f.setResult(index.getSize());
            return;
        }
        if (this.isIndexKeySizeQuery()) {
            Object projection = this.projections.values().iterator().next();
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
            f.setResult(index.getKeySize());
            return;
        }
        OIndexInternal<?> indexInternal = index.getInternal();
        if (indexInternal instanceof OSharedResource) {
            ((OSharedResource)((Object)indexInternal)).acquireExclusiveLock();
        }
        try {
            Iterator<Map.Entry<Object, ?>> it = index.iterator();
            while (it.hasNext()) {
                Map.Entry<Object, ?> current = it.next();
                if (current.getValue() instanceof Collection) {
                    for (OIdentifiable identifiable : (OMVRBTreeRIDSet)current.getValue()) {
                        this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(current.getKey(), identifiable.getIdentity()));
                    }
                    continue;
                }
                this.handleResult(OCommandExecutorSQLSelect.createIndexEntryAsDocument(current.getKey(), (OIdentifiable)current.getValue()));
            }
            Object var9_34 = null;
        }
        catch (Throwable throwable) {
            Object var9_35 = null;
            if (!(indexInternal instanceof OSharedResource)) throw throwable;
            ((OSharedResource)((Object)indexInternal)).releaseExclusiveLock();
            throw throwable;
        }
        if (!(indexInternal instanceof OSharedResource)) return;
        ((OSharedResource)((Object)indexInternal)).releaseExclusiveLock();
    }

    private boolean isIndexSizeQuery() {
        if (!this.anyFunctionAggregates || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        if (!f.getRoot().equals("count")) {
            return false;
        }
        return f.configuredParameters == null || f.configuredParameters.length == 0 || f.configuredParameters != null && f.configuredParameters.length == 1 && f.configuredParameters[0].equals("*");
    }

    private boolean isIndexKeySizeQuery() {
        if (!this.anyFunctionAggregates || this.projections.entrySet().size() != 1) {
            return false;
        }
        Object projection = this.projections.values().iterator().next();
        if (!(projection instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection;
        if (!f.getRoot().equals("count")) {
            return false;
        }
        if (f.configuredParameters == null || f.configuredParameters.length != 1 || !(f.configuredParameters[0] instanceof OSQLFunctionRuntime)) {
            return false;
        }
        OSQLFunctionRuntime fConfigured = (OSQLFunctionRuntime)f.configuredParameters[0];
        if (!fConfigured.getRoot().equals("distinct")) {
            return false;
        }
        if (fConfigured.configuredParameters == null || fConfigured.configuredParameters.length != 1 || !(fConfigured.configuredParameters[0] instanceof OSQLFilterItemField)) {
            return false;
        }
        OSQLFilterItemField field = (OSQLFilterItemField)fConfigured.configuredParameters[0];
        return field.getRoot().equals("key");
    }

    private static Object getIndexKey(OIndexDefinition indexDefinition, Object value) {
        if (indexDefinition instanceof OCompositeIndexDefinition) {
            if (value instanceof List) {
                List values = (List)value;
                ArrayList<Object> keyParams = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    keyParams.add(OSQLHelper.getValue(o));
                }
                return indexDefinition.createValue(keyParams);
            }
            if ((value = OSQLHelper.getValue(value)) instanceof OCompositeKey) {
                return value;
            }
            return indexDefinition.createValue(value);
        }
        return OSQLHelper.getValue(value);
    }

    protected void parseIndexSearchResult(Collection<ODocument> entries) {
        ODocument document;
        boolean continueResultParsing;
        Iterator<ODocument> i$ = entries.iterator();
        while (i$.hasNext() && (continueResultParsing = this.handleResult(document = i$.next()))) {
        }
    }

    private static ODocument createIndexEntryAsDocument(Object iKey, OIdentifiable iValue) {
        ODocument doc = new ODocument().setOrdered(true);
        doc.field("key", iKey);
        doc.field("rid", iValue);
        doc.unsetDirty();
        return doc;
    }

    private void applyProjections() {
        if (this.anyFunctionAggregates) {
            ODocument result = new ODocument().setOrdered(true);
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                Object value;
                if (projection.getValue() instanceof OSQLFilterItemField) {
                    value = ((OSQLFilterItemField)projection.getValue()).getValue(result, null);
                } else if (projection.getValue() instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                    value = f.getResult();
                } else {
                    value = projection.getValue();
                }
                result.field(projection.getKey(), value);
            }
            this.request.getResultListener().result(result);
        }
    }

    private static boolean checkIndexExistence(OClass iSchemaClass, OIndexSearchResult result) {
        if (!iSchemaClass.areIndexed(result.fields())) {
            return false;
        }
        if (result.lastField.isLong()) {
            int fieldCount = result.lastField.getItemCount();
            OClass oClass = iSchemaClass.getProperty(result.lastField.getItemName(0)).getLinkedClass();
            for (int i = 1; i < fieldCount; ++i) {
                if (!oClass.areIndexed(result.lastField.getItemName(i))) {
                    return false;
                }
                oClass = oClass.getProperty(result.lastField.getItemName(i)).getLinkedClass();
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "SELECT [<Projections>] FROM <Target> [WHERE <Condition>*] [ORDER BY <Fields>* [ASC|DESC]*] [LIMIT <MaxRecords>]";
    }

    protected boolean optimizeExecution() {
        Map.Entry<String, Object> entry;
        if (this.compiledFilter != null & this.compiledFilter.getRootCondition() == null && this.projections != null && this.projections.size() == 1 && (entry = this.projections.entrySet().iterator().next()).getValue() instanceof OSQLFunctionRuntime) {
            OSQLFunctionRuntime rf = (OSQLFunctionRuntime)entry.getValue();
            if (rf.function instanceof OSQLFunctionCount && rf.configuredParameters.length == 1 && "*".equals(rf.configuredParameters[0])) {
                long count = 0L;
                if (this.compiledFilter.getTargetClasses() != null) {
                    OClass cls = this.compiledFilter.getTargetClasses().keySet().iterator().next();
                    count = cls.count();
                } else if (this.compiledFilter.getTargetClusters() != null) {
                    for (String cluster : this.compiledFilter.getTargetClusters().keySet()) {
                        count += OCommandExecutorSQLSelect.getDatabase().countClusterElements(cluster);
                    }
                } else if (this.compiledFilter.getTargetIndex() != null) {
                    count += OCommandExecutorSQLSelect.getDatabase().getMetadata().getIndexManager().getIndex(this.compiledFilter.getTargetIndex()).getSize();
                }
                if (this.tempResult == null) {
                    this.tempResult = new ArrayList();
                }
                this.tempResult.add(new ODocument().field(entry.getKey(), count));
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IndexComparator
    implements Comparator<OIndex<?>> {
        private static final IndexComparator INSTANCE = new IndexComparator();

        private IndexComparator() {
        }

        @Override
        public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
            return indexOne.getDefinition().getParamCount() - indexTwo.getDefinition().getParamCount();
        }
    }
}

