/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedConditionalReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLInsert
extends OCommandExecutorSQLSetAware
implements OCommandDistributedConditionalReplicateRequest {
    public static final String KEYWORD_INSERT = "INSERT";
    private static final String KEYWORD_VALUES = "VALUES";
    private String className = null;
    private String clusterName = null;
    private String indexName = null;
    private List<Map<String, Object>> newRecords;

    public OCommandExecutorSQLInsert parse(OCommandRequest iRequest) {
        String temp;
        ODatabaseRecord database = OCommandExecutorSQLInsert.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        this.className = null;
        this.newRecords = null;
        this.parserRequiredKeyword(KEYWORD_INSERT);
        this.parserRequiredKeyword("INTO");
        String subjectName = this.parserRequiredWord(true, "Invalid subject name. Expected cluster, class or index");
        if (subjectName.startsWith("CLUSTER:")) {
            this.clusterName = subjectName.substring("CLUSTER:".length());
        } else if (subjectName.startsWith("INDEX:")) {
            this.indexName = subjectName.substring("INDEX:".length());
        } else {
            OClass cls;
            if (subjectName.startsWith("CLASS:")) {
                subjectName = subjectName.substring("CLASS:".length());
            }
            if ((cls = database.getMetadata().getSchema().getClass(subjectName)) == null) {
                this.throwParsingException("Class " + subjectName + " not found in database");
            }
            this.className = cls.getName();
        }
        this.parserSkipWhiteSpaces();
        if (this.parserIsEnded()) {
            this.throwSyntaxErrorException("Set of fields is missed. Example: (name, surname) or SET name = 'Bill'");
        }
        if ((temp = this.parseOptionalWord(true, new String[0])).equals("CLUSTER")) {
            this.clusterName = this.parseRequiredWord(false);
            this.parserSkipWhiteSpaces();
            if (this.parserIsEnded()) {
                this.throwSyntaxErrorException("Set of fields is missed. Example: (name, surname) or SET name = 'Bill'");
            }
        } else {
            this.parserGoBack();
        }
        this.newRecords = new ArrayList<Map<String, Object>>();
        if (this.parserGetCurrentChar() == '(') {
            this.parseBracesFields();
        } else {
            LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
            this.newRecords.add(fields);
            this.parseRequiredWord(false);
            this.parseSetFields(fields);
        }
        return this;
    }

    protected void parseBracesFields() {
        int beginFields = this.parserGetCurrentPosition();
        int endFields = this.text.indexOf(41, beginFields + 1);
        if (endFields == -1) {
            this.throwSyntaxErrorException("Missed closed brace");
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        this.parserSetCurrentPosition(OStringSerializerHelper.getParameters(this.text, beginFields, endFields, fieldNames));
        if (fieldNames.size() == 0) {
            this.throwSyntaxErrorException("Set of fields is empty. Example: (name, surname)");
        }
        for (int i = 0; i < fieldNames.size(); ++i) {
            fieldNames.set(i, OStringSerializerHelper.removeQuotationMarks(fieldNames.get(i)));
        }
        this.parserRequiredKeyword(KEYWORD_VALUES);
        this.parserSkipWhiteSpaces();
        if (this.parserIsEnded() || this.text.charAt(this.parserGetCurrentPosition()) != '(') {
            this.throwParsingException("Set of values is missed. Example: ('Bill', 'Stuart', 300)");
        }
        int textEnd = this.text.lastIndexOf(41);
        int blockStart = this.parserGetCurrentPosition();
        int blockEnd = this.parserGetCurrentPosition();
        while (blockStart != textEnd) {
            blockEnd = OStringSerializerHelper.findEndBlock(this.text, '(', ')', blockStart = this.text.indexOf(40, blockStart - 1));
            if (blockEnd == -1) {
                throw new OCommandSQLParsingException("Missed closed brace. Use " + this.getSyntax(), this.text, blockStart);
            }
            List<String> values = OStringSerializerHelper.smartSplit(this.text, new char[]{','}, blockStart + 1, blockEnd - 1, true, new char[0]);
            if (values.isEmpty()) {
                throw new OCommandSQLParsingException("Set of values is empty. Example: ('Bill', 'Stuart', 300). Use " + this.getSyntax(), this.text, blockStart);
            }
            if (values.size() != fieldNames.size()) {
                throw new OCommandSQLParsingException("Fields not match with values", this.text, blockStart);
            }
            LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
            for (int i = 0; i < values.size(); ++i) {
                fields.put(fieldNames.get(i), OSQLHelper.parseValue(this, OStringSerializerHelper.decode(values.get(i).trim()), this.context));
            }
            this.newRecords.add(fields);
            blockStart = blockEnd;
        }
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.newRecords == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OCommandParameters commandParameters = new OCommandParameters(iArgs);
        if (this.indexName != null) {
            OIndex<?> index = OCommandExecutorSQLInsert.getDatabase().getMetadata().getIndexManager().getIndex(this.indexName);
            if (index == null) {
                throw new OCommandExecutionException("Target index '" + this.indexName + "' not found");
            }
            Map<String, Object> result = null;
            for (Map<String, Object> candidate : this.newRecords) {
                index.put(this.getIndexKeyValue(commandParameters, candidate), this.getIndexValue(commandParameters, candidate));
                result = candidate;
            }
            return new ODocument(result);
        }
        ArrayList<ODocument> docs = new ArrayList<ODocument>();
        for (Map<String, Object> candidate : this.newRecords) {
            ODocument doc = this.className != null ? new ODocument(this.className) : new ODocument();
            OSQLHelper.bindParameters(doc, candidate, commandParameters);
            if (this.clusterName != null) {
                doc.save(this.clusterName);
            } else {
                doc.save();
            }
            docs.add(doc);
        }
        if (docs.size() == 1) {
            return docs.get(0);
        }
        return docs;
    }

    private Object getIndexKeyValue(OCommandParameters commandParameters, Map<String, Object> candidate) {
        Object parsedKey = candidate.get("key");
        if (parsedKey instanceof OSQLFilterItemField) {
            OSQLFilterItemField f = (OSQLFilterItemField)parsedKey;
            if (f.getRoot().equals("?")) {
                return commandParameters.getNext();
            }
            if (f.getRoot().startsWith(":")) {
                return commandParameters.getByName(f.getRoot().substring(1));
            }
        }
        return parsedKey;
    }

    private OIdentifiable getIndexValue(OCommandParameters commandParameters, Map<String, Object> candidate) {
        Object parsedRid = candidate.get("rid");
        if (parsedRid instanceof OSQLFilterItemField) {
            OSQLFilterItemField f = (OSQLFilterItemField)parsedRid;
            if (f.getRoot().equals("?")) {
                return (OIdentifiable)commandParameters.getNext();
            }
            if (f.getRoot().startsWith(":")) {
                return (OIdentifiable)commandParameters.getByName(f.getRoot().substring(1));
            }
        }
        return (OIdentifiable)parsedRid;
    }

    @Override
    public boolean isReplicated() {
        return this.indexName != null;
    }

    @Override
    public String getSyntax() {
        return "INSERT INTO [class:]<class>|cluster:<cluster>|index:<index> [(<field>[,]*) VALUES (<expression>[,]*)[,]*]|[SET <field> = <expression>[,]*]";
    }
}

