/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropIndex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_INDEX = "INDEX";
    private String name;

    public OCommandExecutorSQLDropIndex parse(OCommandRequest iRequest) {
        OCommandExecutorSQLDropIndex.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLDropIndex.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLDropIndex.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
            throw new OCommandSQLParsingException("Keyword INDEX not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLDropIndex.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected index name. Use " + this.getSyntax(), this.text, oldPos);
        }
        this.name = word.toString();
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.name == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        OCommandExecutorSQLDropIndex.getDatabase().getMetadata().getIndexManager().dropIndex(this.name);
        return null;
    }

    @Override
    public String getSyntax() {
        return "DROP INDEX <index-name>|<class>.<property>";
    }
}

