/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    private String clusterName;

    public OCommandExecutorSQLDropCluster parse(OCommandRequest iRequest) {
        OCommandExecutorSQLDropCluster.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLDropCluster.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropCluster.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLUSTER)) {
            throw new OCommandSQLParsingException("Keyword CLUSTER not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropCluster.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <cluster>. Use " + this.getSyntax(), this.text, pos);
        }
        this.clusterName = word.toString();
        if (this.clusterName == null) {
            throw new OCommandSQLParsingException("Cluster is null. Use " + this.getSyntax(), this.text, pos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clusterName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLDropCluster.getDatabase();
        int clusterId = database.getStorage().getClusterIdByName(this.clusterName);
        for (OClass iClass : database.getMetadata().getSchema().getClasses()) {
            for (int i : iClass.getClusterIds()) {
                if (i != clusterId) continue;
                return false;
            }
        }
        database.dropCluster(clusterId);
        return true;
    }

    protected boolean isClusterDeletable(int clusterId) {
        ODatabaseRecord database = OCommandExecutorSQLDropCluster.getDatabase();
        for (OClass iClass : database.getMetadata().getSchema().getClasses()) {
            for (int i : iClass.getClusterIds()) {
                if (i != clusterId) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "DROP CLUSTER <cluster>";
    }
}

