/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLCreateProperty
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;
    private OType type;
    private String linked;

    public OCommandExecutorSQLCreateProperty parse(OCommandRequest iRequest) {
        OCommandExecutorSQLCreateProperty.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLCreateProperty.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
            throw new OCommandSQLParsingException("Keyword PROPERTY not found", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, oldPos);
        }
        String[] parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.text, oldPos);
        }
        this.className = parts[0];
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class not found", this.text, oldPos);
        }
        this.fieldName = parts[1];
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missed property type", this.text, oldPos);
        }
        this.type = OType.valueOf(word.toString());
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            return this;
        }
        this.linked = word.toString();
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.type == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLCreateProperty.getDatabase();
        OClassImpl sourceClass = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        OPropertyImpl prop = (OPropertyImpl)sourceClass.getProperty(this.fieldName);
        if (prop != null) {
            throw new OCommandExecutionException("Property '" + this.className + "." + this.fieldName + "' already exists. Remove it before to retry.");
        }
        OClass linkedClass = null;
        OType linkedType = null;
        if (this.linked != null && (linkedClass = database.getMetadata().getSchema().getClass(this.linked)) == null) {
            linkedType = OType.valueOf(this.linked.toUpperCase(Locale.ENGLISH));
        }
        prop = sourceClass.addPropertyInternal(this.fieldName, this.type, linkedType, linkedClass);
        sourceClass.saveInternal();
        return sourceClass.properties().size();
    }

    @Override
    public String getSyntax() {
        return "CREATE PROPERTY <class>.<property> <type> [<linked-type>|<linked-class>]";
    }
}

