/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSetAware;
import com.orientechnologies.orient.core.sql.OCommandParameters;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLCreateEdge
extends OCommandExecutorSQLSetAware {
    public static final String NAME = "CREATE EDGE";
    private String from;
    private String to;
    private OClass clazz;
    private String clusterName;
    private LinkedHashMap<String, Object> fields;

    public OCommandExecutorSQLCreateEdge parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLCreateEdge.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        String className = null;
        this.parserRequiredKeyword("CREATE");
        this.parserRequiredKeyword("EDGE");
        String temp = this.parseOptionalWord(true, new String[0]);
        while (temp != null) {
            if (temp.equals("CLUSTER")) {
                this.clusterName = this.parseRequiredWord(false);
            } else if (temp.equals("FROM")) {
                this.from = this.parseRequiredWord(false);
            } else if (temp.equals("TO")) {
                this.to = this.parseRequiredWord(false);
            } else if (temp.equals("SET")) {
                this.fields = new LinkedHashMap();
                this.parseSetFields(this.fields);
            } else if (className == null && temp.length() > 0) {
                className = temp;
            }
            temp = this.parseOptionalWord(true, new String[0]);
            if (!this.parserIsEnded()) continue;
        }
        if (className == null) {
            className = "E";
        }
        this.clazz = database.getMetadata().getSchema().getClass(className);
        if (this.clazz == null) {
            throw new OCommandSQLParsingException("Class " + className + " was not found");
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.clazz == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLCreateEdge.getDatabase();
        if (!(database instanceof OGraphDatabase)) {
            database = new OGraphDatabase((ODatabaseRecordTx)database);
        }
        ORecordId fromId = new ORecordId(this.from);
        ORecordId toId = new ORecordId(this.to);
        ODocument edge = ((OGraphDatabase)database).createEdge(fromId, toId, this.clazz.getName());
        OSQLHelper.bindParameters(edge, this.fields, new OCommandParameters(iArgs));
        edge.save(this.clusterName);
        return edge;
    }

    @Override
    public String getSyntax() {
        return "CREATE EDGE [<class>] [CLUSTER <cluster>] FROM <rid>|(<query>) TO <rid>|(<query>) [SET <field> = <expression>[,]*]";
    }
}

