/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLAlterProperty
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;
    private OProperty.ATTRIBUTES attribute;
    private String value;

    public OCommandExecutorSQLAlterProperty parse(OCommandRequest iRequest) {
        OCommandExecutorSQLAlterProperty.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLAlterProperty.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
            throw new OCommandSQLParsingException("Keyword ALTER not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterProperty.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
            throw new OCommandSQLParsingException("Keyword PROPERTY not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterProperty.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.text, oldPos);
        }
        String[] parts = word.toString().split("\\.");
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.text, oldPos);
        }
        this.className = parts[0];
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class not found", this.text, oldPos);
        }
        this.fieldName = parts[1];
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterProperty.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missing property attribute to change. Use " + this.getSyntax(), this.text, oldPos);
        }
        String attributeAsString = word.toString();
        try {
            this.attribute = OProperty.ATTRIBUTES.valueOf(attributeAsString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new OCommandSQLParsingException("Unknown property attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OProperty.ATTRIBUTES.values()), this.text, oldPos);
        }
        this.value = this.text.substring(pos + 1).trim();
        if (this.value.length() == 0) {
            throw new OCommandSQLParsingException("Missing property value to change for attribute '" + (Object)((Object)this.attribute) + "'. Use " + this.getSyntax(), this.text, oldPos);
        }
        if (this.value.equalsIgnoreCase("null")) {
            this.value = null;
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not yet been parsed");
        }
        OClassImpl sourceClass = (OClassImpl)OCommandExecutorSQLAlterProperty.getDatabase().getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        OPropertyImpl prop = (OPropertyImpl)sourceClass.getProperty(this.fieldName);
        if (prop == null) {
            throw new OCommandExecutionException("Property '" + this.className + "." + this.fieldName + "' not exists");
        }
        prop.setInternalAndSave(this.attribute, this.value);
        return null;
    }

    @Override
    public String getSyntax() {
        return "ALTER PROPERTY <class>.<property> <attribute-name> <attribute-value>";
    }
}

