/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLAlterDatabase
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_ALTER = "ALTER";
    public static final String KEYWORD_DATABASE = "DATABASE";
    private ODatabase.ATTRIBUTES attribute;
    private String value;

    public OCommandExecutorSQLAlterDatabase parse(OCommandRequest iRequest) {
        ODatabaseRecord database = OCommandExecutorSQLAlterDatabase.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLAlterDatabase.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_ALTER)) {
            throw new OCommandSQLParsingException("Keyword ALTER not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterDatabase.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_DATABASE)) {
            throw new OCommandSQLParsingException("Keyword DATABASE not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLAlterDatabase.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missed the database's attribute to change. Use " + this.getSyntax(), this.text, oldPos);
        }
        String attributeAsString = word.toString();
        try {
            this.attribute = ODatabase.ATTRIBUTES.valueOf(attributeAsString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new OCommandSQLParsingException("Unknown database's attribute '" + attributeAsString + "'. Supported attributes are: " + Arrays.toString((Object[])OClass.ATTRIBUTES.values()), this.text, oldPos);
        }
        this.value = this.text.substring(pos + 1).trim();
        if (this.value.length() == 0) {
            throw new OCommandSQLParsingException("Missed the database's value to change for attribute '" + (Object)((Object)this.attribute) + "'. Use " + this.getSyntax(), this.text, oldPos);
        }
        if (this.value.equalsIgnoreCase("null")) {
            this.value = null;
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.attribute == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLAlterDatabase.getDatabase();
        database.checkSecurity("database", ORole.PERMISSION_UPDATE);
        database.setInternal(this.attribute, this.value);
        return null;
    }

    @Override
    public String getSyntax() {
        return "ALTER DATABASE <attribute-name> <attribute-value>";
    }
}

