/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.string;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializer;

public class OStringSerializerEmbedded
implements OStringSerializer {
    public static final OStringSerializerEmbedded INSTANCE = new OStringSerializerEmbedded();
    public static final String NAME = "em";

    public Object fromStream(String iStream) {
        if (iStream == null || iStream.length() == 0) {
            return null;
        }
        ODocument instance = new ODocument();
        instance.fromStream(OBinaryProtocol.string2bytes(iStream));
        return instance;
    }

    public StringBuilder toStream(StringBuilder iOutput, Object iValue) {
        if (iValue != null) {
            if (!(iValue instanceof OSerializableStream)) {
                throw new OSerializationException("Cannot serialize the object since it's not implements the OSerializableStream interface");
            }
            OSerializableStream stream = (OSerializableStream)iValue;
            iOutput.append(iValue.getClass().getName());
            iOutput.append("|");
            iOutput.append(OBinaryProtocol.bytes2string(stream.toStream()));
        }
        return iOutput;
    }

    public String getName() {
        return NAME;
    }
}

