/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.annotation.OAfterSerialization;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OLazyObjectMapInterface;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.entity.OEntityManagerInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelperManager;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerEmbedded;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordSerializerCSVAbstract
extends ORecordSerializerStringAbstract {
    public static final char FIELD_VALUE_SEPARATOR = ':';

    protected abstract ORecordSchemaAware<?> newObject(String var1);

    public Object fieldFromStream(ORecordInternal<?> iSourceRecord, OType iType, OClass iLinkedClass, OType iLinkedType, String iName, String iValue) {
        if (iValue == null) {
            return null;
        }
        switch (iType) {
            case EMBEDDEDLIST: 
            case EMBEDDEDSET: {
                return this.embeddedCollectionFromStream((ODocument)iSourceRecord, iType, iLinkedClass, iLinkedType, iValue);
            }
            case LINKLIST: 
            case LINKSET: {
                if (iValue.length() == 0) {
                    return null;
                }
                String value = iValue.startsWith("[") ? iValue.substring(1, iValue.length() - 1) : iValue;
                return iType == OType.LINKLIST ? new ORecordLazyList((ODocument)iSourceRecord).setStreamedContent(new StringBuilder(value)) : new OMVRBTreeRIDSet(iSourceRecord).fromStream(new StringBuilder(iValue));
            }
            case LINKMAP: {
                if (iValue.length() == 0) {
                    return null;
                }
                String value = iValue.substring(1, iValue.length() - 1);
                ORecordLazyMap map = new ORecordLazyMap((ODocument)iSourceRecord, 100);
                if (value.length() == 0) {
                    return map;
                }
                List<String> items = OStringSerializerHelper.smartSplit(value, ',', new char[0]);
                for (String item : items) {
                    List<String> entry;
                    if (item == null || item.isEmpty() || (entry = OStringSerializerHelper.smartSplit(item, ':', new char[0])).isEmpty()) continue;
                    String mapValue = entry.get(1);
                    if (mapValue != null && !mapValue.isEmpty()) {
                        mapValue = mapValue.substring(1);
                    }
                    map.put(ORecordSerializerCSVAbstract.fieldTypeFromStream((ODocument)iSourceRecord, OType.STRING, entry.get(0)), new ORecordId(mapValue));
                }
                return map;
            }
            case EMBEDDEDMAP: {
                return this.embeddedMapFromStream((ODocument)iSourceRecord, iLinkedType, iValue);
            }
            case LINK: {
                if (iValue.length() > 1) {
                    int pos = iValue.indexOf("@");
                    if (pos > -1) {
                        ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(iValue.substring(1, pos));
                    } else {
                        pos = 0;
                    }
                    return new ORecordId(iValue.substring(pos + 1));
                }
                return null;
            }
            case EMBEDDED: {
                if (iValue.length() > 2) {
                    String value = iValue.substring(1, iValue.length() - 1);
                    return ((ODocument)OStringSerializerEmbedded.INSTANCE.fromStream(value)).addOwner(iSourceRecord);
                }
                return null;
            }
        }
        return ORecordSerializerCSVAbstract.fieldTypeFromStream((ODocument)iSourceRecord, iType, iValue);
    }

    public Map<String, Object> embeddedMapFromStream(ODocument iSourceDocument, OType iLinkedType, String iValue) {
        if (iValue.length() == 0) {
            return null;
        }
        String value = iValue.substring(1, iValue.length() - 1);
        OTrackedMap map = iLinkedType == OType.LINK || iLinkedType == OType.EMBEDDED ? new ORecordLazyMap(iSourceDocument, 100) : new OTrackedMap(iSourceDocument);
        if (value.length() == 0) {
            return map;
        }
        List<String> items = OStringSerializerHelper.smartSplit(value, ',', new char[0]);
        if (map instanceof ORecordElement) {
            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        }
        for (String item : items) {
            Object mapValueObject;
            List<String> entries;
            if (item == null || item.isEmpty() || (entries = OStringSerializerHelper.smartSplit(item, ':', new char[0])).isEmpty()) continue;
            if (entries.size() > 1) {
                OType linkedType;
                String mapValue = entries.get(1);
                if (iLinkedType == null) {
                    if (!mapValue.isEmpty()) {
                        linkedType = ORecordSerializerCSVAbstract.getType(mapValue);
                        if (this.isConvertToLinkedMap(map, linkedType)) {
                            map = new ORecordLazyMap(iSourceDocument, 100);
                            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
                        }
                    } else {
                        linkedType = OType.EMBEDDED;
                    }
                } else {
                    linkedType = iLinkedType;
                }
                if (linkedType == OType.EMBEDDED) {
                    mapValue = mapValue.substring(1, mapValue.length() - 1);
                }
                if ((mapValueObject = ORecordSerializerCSVAbstract.fieldTypeFromStream(iSourceDocument, linkedType, mapValue)) != null && mapValueObject instanceof ODocument) {
                    ((ODocument)mapValueObject).addOwner(iSourceDocument);
                }
            } else {
                mapValueObject = null;
            }
            map.put(ORecordSerializerCSVAbstract.fieldTypeFromStream(iSourceDocument, OType.STRING, entries.get(0)), mapValueObject);
        }
        if (map instanceof ORecordElement) {
            ((ORecordElement)map).setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return map;
    }

    protected boolean isConvertToLinkedMap(Map<?, ?> map, OType linkedType) {
        boolean convert;
        boolean bl = convert = linkedType == OType.LINK && !(map instanceof ORecordLazyMap);
        if (convert) {
            for (Object value : map.values()) {
                if (value instanceof OIdentifiable) continue;
                return false;
            }
        }
        return convert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fieldToStream(ODocument iRecord, StringBuilder iOutput, OUserObject2RecordHandler iObjHandler, OType iType, OClass iLinkedClass, OType iLinkedType, String iName, Object iValue, Set<Integer> iMarshalledRecords, boolean iSaveOnlyDirty) {
        if (iValue == null) {
            return;
        }
        long timer = OProfiler.getInstance().startChrono();
        switch (iType) {
            case LINK: {
                if (!iRecord.getIdentity().isValid() && iRecord instanceof ODocument && iRecord.isEmbedded()) {
                    this.fieldToStream(iRecord, iOutput, iObjHandler, OType.EMBEDDED, iLinkedClass, iLinkedType, iName, iValue, iMarshalledRecords, iSaveOnlyDirty);
                    break;
                }
                OIdentifiable link = ORecordSerializerCSVAbstract.linkToStream(iOutput, iRecord, iValue);
                if (link != null) {
                    iRecord.field(iName, link);
                }
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.link2string", timer);
                break;
            }
            case LINKLIST: {
                iOutput.append('[');
                if (iValue instanceof ORecordLazyList && ((ORecordLazyList)iValue).getStreamedContent() != null) {
                    iOutput.append((CharSequence)((ORecordLazyList)iValue).getStreamedContent());
                    OProfiler.getInstance().updateCounter("system.serializer.rec.str.linkList2string.cached", 1L);
                } else {
                    Iterator<OIdentifiable> it;
                    ORecordLazyList coll;
                    if (!(iValue instanceof ORecordLazyList)) {
                        coll = new ORecordLazyList(iRecord);
                        coll.addAll((Collection)iValue);
                        ((Collection)iValue).clear();
                        iRecord.field(iName, coll);
                        it = coll.rawIterator();
                    } else {
                        coll = (ORecordLazyList)iValue;
                        if (coll.getStreamedContent() != null) {
                            iOutput.append((CharSequence)coll.getStreamedContent());
                            OProfiler.getInstance().updateCounter("system.serializer.rec.str.linkList2string.cached", 1L);
                            it = coll.newItemsIterator();
                        } else {
                            it = coll.rawIterator();
                        }
                    }
                    if (it != null && it.hasNext()) {
                        StringBuilder buffer = new StringBuilder();
                        int items = 0;
                        while (it.hasNext()) {
                            OIdentifiable item;
                            OIdentifiable newRid;
                            if (items > 0) {
                                buffer.append(',');
                            }
                            if ((newRid = ORecordSerializerCSVAbstract.linkToStream(buffer, iRecord, item = it.next())) != null) {
                                ((OLazyIterator)it).update(newRid);
                            }
                            ++items;
                        }
                        coll.convertRecords2Links();
                        iOutput.append((CharSequence)buffer);
                        coll.setStreamedContent(buffer);
                    }
                }
                iOutput.append(']');
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.linkList2string", timer);
                break;
            }
            case LINKSET: {
                OMVRBTreeRIDSet coll;
                if (!(iValue instanceof OMVRBTreeRIDSet)) {
                    coll = new OMVRBTreeRIDSet(iRecord, (Collection)iValue);
                    ((Collection)iValue).clear();
                    iRecord.field(iName, coll);
                } else {
                    coll = (OMVRBTreeRIDSet)iValue;
                }
                ORecordSerializerCSVAbstract.linkSetToStream(iOutput, iRecord, coll);
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.linkSet2string", timer);
                break;
            }
            case LINKMAP: {
                iOutput.append('{');
                Map map = (Map)iValue;
                if (map instanceof OLazyObjectMapInterface) {
                    ((OLazyObjectMapInterface)map).setConvertToRecord(false);
                }
                boolean invalidMap = false;
                try {
                    int items = 0;
                    for (Map.Entry entry : map.entrySet()) {
                        if (items++ > 0) {
                            iOutput.append(',');
                        }
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.STRING, entry.getKey());
                        iOutput.append(':');
                        OIdentifiable link = ORecordSerializerCSVAbstract.linkToStream(iOutput, iRecord, entry.getValue());
                        if (link == null || invalidMap) continue;
                        invalidMap = true;
                    }
                    Object var20_27 = null;
                }
                catch (Throwable throwable) {
                    Object var20_28 = null;
                    if (map instanceof OLazyObjectMapInterface) {
                        ((OLazyObjectMapInterface)map).setConvertToRecord(true);
                    }
                    throw throwable;
                }
                if (map instanceof OLazyObjectMapInterface) {
                    ((OLazyObjectMapInterface)map).setConvertToRecord(true);
                }
                if (invalidMap) {
                    ORecordLazyMap newMap = new ORecordLazyMap(iRecord, 100);
                    for (Map.Entry entry : map.entrySet()) {
                        newMap.put(entry.getKey(), (OIdentifiable)entry.getValue());
                    }
                    map.clear();
                    iRecord.field(iName, newMap);
                }
                iOutput.append('}');
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.linkMap2string", timer);
                break;
            }
            case EMBEDDED: {
                if (iValue instanceof ODocument) {
                    iOutput.append('(');
                    this.toString((ODocument)iValue, iOutput, null, iObjHandler, iMarshalledRecords, false, true);
                    iOutput.append(')');
                } else if (iValue != null) {
                    iOutput.append(iValue.toString());
                }
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.embed2string", timer);
                break;
            }
            case EMBEDDEDLIST: {
                this.embeddedCollectionToStream(null, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iMarshalledRecords, iSaveOnlyDirty);
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.embedList2string", timer);
                break;
            }
            case EMBEDDEDSET: {
                this.embeddedCollectionToStream(null, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iMarshalledRecords, iSaveOnlyDirty);
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.embedSet2string", timer);
                break;
            }
            case EMBEDDEDMAP: {
                this.embeddedMapToStream(null, iObjHandler, iOutput, iLinkedClass, iLinkedType, iValue, iMarshalledRecords, iSaveOnlyDirty);
                OProfiler.getInstance().stopChrono("system.serializer.rec.str.embedMap2string", timer);
                break;
            }
            default: {
                ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iType, iValue);
            }
        }
    }

    public static StringBuilder linkSetToStream(StringBuilder iOutput, ODocument iRecord, OMVRBTreeRIDSet iSet) {
        iSet.toStream(iOutput);
        return iOutput;
    }

    public void embeddedMapToStream(ODatabaseComplex<?> iDatabase, OUserObject2RecordHandler iObjHandler, StringBuilder iOutput, final OClass iLinkedClass, OType iLinkedType, Object iValue, Set<Integer> iMarshalledRecords, boolean iSaveOnlyDirty) {
        iOutput.append('{');
        if (iValue != null) {
            int items = 0;
            for (Map.Entry o : ((Map)iValue).entrySet()) {
                if (items > 0) {
                    iOutput.append(',');
                }
                if (o != null) {
                    ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.STRING, o.getKey());
                    iOutput.append(':');
                    if (o.getValue() instanceof ORecord) {
                        ODocument record;
                        if (o.getValue() instanceof ODocument) {
                            record = (ODocument)o.getValue();
                        } else {
                            if (iDatabase == null && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
                                iDatabase = ODatabaseRecordThreadLocal.INSTANCE.get();
                            }
                            record = OObjectSerializerHelperManager.getInstance().toStream(o.getValue(), new ODocument(o.getValue().getClass().getSimpleName()), iDatabase instanceof ODatabaseObject ? ((ODatabaseObject)((Object)iDatabase)).getEntityManager() : OEntityManagerInternal.INSTANCE, iLinkedClass, iObjHandler != null ? iObjHandler : new OUserObject2RecordHandler(){

                                @Override
                                public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
                                    return iRecord;
                                }

                                @Override
                                public ORecordInternal<?> getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
                                    return new ODocument(iLinkedClass);
                                }

                                @Override
                                public boolean existsUserObjectByRID(ORID iRID) {
                                    return false;
                                }

                                @Override
                                public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
                                }

                                @Override
                                public void registerUserObjectAfterLinkSave(ORecordInternal<?> iRecord) {
                                }
                            }, null, iSaveOnlyDirty);
                        }
                        iOutput.append('(');
                        this.toString(record, iOutput, null, iObjHandler, iMarshalledRecords, false, true);
                        iOutput.append(')');
                    } else if (o.getValue() instanceof Set) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.EMBEDDEDSET, o.getValue());
                    } else if (o.getValue() instanceof Collection) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.EMBEDDEDLIST, o.getValue());
                    } else if (o.getValue() instanceof Map) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.EMBEDDEDMAP, o.getValue());
                    } else if (iLinkedType == null && o.getValue() != null) {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, OType.getTypeByClass(o.getValue().getClass()), o.getValue());
                    } else {
                        ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, iLinkedType, o.getValue());
                    }
                }
                ++items;
            }
        }
        iOutput.append('}');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object embeddedCollectionFromStream(ODocument iDocument, OType iType, OClass iLinkedClass, OType iLinkedType, String iValue) {
        Collection<OIdentifiable> coll;
        String value;
        if (iValue.length() == 0) {
            return null;
        }
        String string = value = iValue.charAt(0) == '[' ? iValue.substring(1, iValue.length() - 1) : iValue;
        if (iLinkedType == OType.LINK) {
            if (iDocument != null) {
                coll = (Collection)(iType == OType.EMBEDDEDLIST ? new ORecordLazyList(iDocument).setStreamedContent(new StringBuilder(value)) : new OMVRBTreeRIDSet(iDocument).fromStream(new StringBuilder(value)));
            } else {
                if (iType != OType.EMBEDDEDLIST) return new OMVRBTreeRIDSet().fromStream(new StringBuilder(value));
                coll = new ORecordLazyList().setStreamedContent(new StringBuilder(value));
            }
        } else {
            Collection collection = coll = iType == OType.EMBEDDEDLIST ? new OTrackedList(iDocument) : new OTrackedSet(iDocument);
        }
        if (value.length() == 0) {
            return coll;
        }
        if (coll instanceof ORecordElement) {
            ((ORecordElement)((Object)coll)).setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        }
        List<String> items = OStringSerializerHelper.smartSplit(value, ',', new char[0]);
        for (String item : items) {
            Object objectToAdd = null;
            OType linkedType = null;
            if (item.length() > 2 && item.charAt(0) == '(') {
                if (!(item = item.substring(1, item.length() - 1)).isEmpty()) {
                    objectToAdd = (iLinkedClass = OStringSerializerHelper.getRecordClassName(item, iLinkedClass)) != null ? this.fromString(item, new ODocument(iLinkedClass.getName())) : ORecordSerializerCSVAbstract.fieldTypeFromStream(iDocument, OType.EMBEDDED, item);
                }
            } else {
                char begin;
                if (linkedType == null && (linkedType = (begin = item.charAt(0)) == '#' ? OType.LINK : ORecordSerializerCSVAbstract.getType(item)) == null) {
                    throw new IllegalArgumentException("Linked type cannot be null. Probably the serialized type has not stored the type along with data");
                }
                if (iLinkedType == OType.CUSTOM) {
                    item = item.substring(1, item.length() - 1);
                }
                objectToAdd = ORecordSerializerCSVAbstract.fieldTypeFromStream(iDocument, linkedType, item);
            }
            if (objectToAdd == null) continue;
            if (objectToAdd instanceof ODocument && coll instanceof ORecordElement) {
                ((ODocument)objectToAdd).addOwner((ORecordElement)((Object)coll));
            }
            coll.add((OIdentifiable)objectToAdd);
        }
        if (!(coll instanceof ORecordElement)) return coll;
        ((ORecordElement)((Object)coll)).setInternalStatus(ORecordElement.STATUS.LOADED);
        return coll;
    }

    public StringBuilder embeddedCollectionToStream(ODatabaseComplex<?> iDatabase, OUserObject2RecordHandler iObjHandler, StringBuilder iOutput, OClass iLinkedClass, OType iLinkedType, Object iValue, Set<Integer> iMarshalledRecords, boolean iSaveOnlyDirty) {
        iOutput.append('[');
        Iterator iterator = iValue instanceof Collection ? ((Collection)iValue).iterator() : null;
        int size = iValue instanceof Collection ? ((Collection)iValue).size() : Array.getLength(iValue);
        OType linkedType = iLinkedType;
        for (int i = 0; i < size; ++i) {
            OClass linkedClass;
            Object o = iValue instanceof Collection ? iterator.next() : Array.get(iValue, i);
            if (i > 0) {
                iOutput.append(',');
            }
            if (o == null) continue;
            OIdentifiable id = null;
            ODocument doc = null;
            if (!(o instanceof OIdentifiable)) {
                String fieldBound = OObjectSerializerHelperManager.getInstance().getDocumentBoundField(o.getClass());
                if (fieldBound != null) {
                    OObjectSerializerHelperManager.getInstance().invokeCallback(o, null, OBeforeSerialization.class);
                    doc = (ODocument)OObjectSerializerHelperManager.getInstance().getFieldValue(o, fieldBound);
                    OObjectSerializerHelperManager.getInstance().invokeCallback(o, doc, OAfterSerialization.class);
                    id = doc;
                } else if (iLinkedType == null) {
                    linkedType = OType.getTypeByClass(o.getClass());
                }
                linkedClass = iLinkedClass;
            } else {
                id = (OIdentifiable)o;
                if (iLinkedType == null) {
                    linkedType = id.getIdentity().isValid() ? OType.LINK : OType.EMBEDDED;
                }
                if (id instanceof ODocument) {
                    doc = (ODocument)id;
                    if (id.getIdentity().isTemporary()) {
                        doc.save();
                    }
                    linkedClass = doc.getSchemaClass();
                } else {
                    linkedClass = null;
                }
            }
            if (id != null && linkedType != OType.LINK) {
                iOutput.append('(');
            }
            if (linkedType != OType.LINK && (linkedClass != null || doc != null)) {
                if (id == null) {
                    if (iDatabase == null && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
                        iDatabase = ODatabaseRecordThreadLocal.INSTANCE.get();
                    }
                    id = OObjectSerializerHelperManager.getInstance().toStream(o, new ODocument(o.getClass().getSimpleName()), iDatabase instanceof ODatabaseObject ? ((ODatabaseObject)((Object)iDatabase)).getEntityManager() : OEntityManagerInternal.INSTANCE, iLinkedClass, iObjHandler != null ? iObjHandler : new OUserObject2RecordHandler(){

                        @Override
                        public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
                            return iRecord;
                        }

                        @Override
                        public ORecordInternal<?> getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
                            return new ODocument(linkedClass);
                        }

                        @Override
                        public boolean existsUserObjectByRID(ORID iRID) {
                            return false;
                        }

                        @Override
                        public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
                        }

                        @Override
                        public void registerUserObjectAfterLinkSave(ORecordInternal<?> iRecord) {
                        }
                    }, null, iSaveOnlyDirty);
                }
                this.toString(doc, iOutput, null, iObjHandler, iMarshalledRecords, false, true);
            } else {
                if (iLinkedType == null) {
                    if (o != null) {
                        linkedType = OType.getTypeByClass(o.getClass());
                    }
                } else if (iLinkedType == OType.CUSTOM) {
                    iOutput.append('^');
                }
                ORecordSerializerCSVAbstract.fieldTypeToString(iOutput, linkedType, o);
            }
            if (id == null || linkedType == OType.LINK) continue;
            iOutput.append(')');
        }
        iOutput.append(']');
        return iOutput;
    }

    private static OIdentifiable linkToStream(StringBuilder buffer, ORecordSchemaAware<?> iParentRecord, Object iLinked) {
        ORID rid;
        if (iLinked == null) {
            return null;
        }
        OIdentifiable resultRid = null;
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (iLinked instanceof ORID) {
            rid = (ORID)iLinked;
            if (rid.isValid() && rid.isNew()) {
                Object record = rid.getRecord();
                if (database.getTransaction().isActive()) {
                    database.save((ORecordInternal)record);
                } else {
                    database.save((ORecordInternal)record);
                }
                if (record != null) {
                    rid = record.getIdentity();
                }
                resultRid = rid;
            }
        } else {
            ODatabaseRecord db;
            String boundDocumentField;
            if (iLinked instanceof String) {
                iLinked = new ORecordId((String)iLinked);
            } else if (!(iLinked instanceof ORecordInternal) && (boundDocumentField = OObjectSerializerHelperManager.getInstance().getDocumentBoundField(iLinked.getClass())) != null) {
                iLinked = OObjectSerializerHelperManager.getInstance().getFieldValue(iLinked, boundDocumentField);
            }
            if (!(iLinked instanceof OIdentifiable)) {
                throw new IllegalArgumentException("Invalid object received. Expected a OIdentifiable but received type=" + iLinked.getClass().getName() + " and value=" + iLinked);
            }
            ORecordInternal iLinkedRecord = (ORecordInternal)((OIdentifiable)iLinked).getRecord();
            rid = iLinkedRecord.getIdentity();
            if (rid.isNew() || iLinkedRecord.isDirty()) {
                if (iLinkedRecord instanceof ODocument) {
                    OClass schemaClass = ((ODocument)iLinkedRecord).getSchemaClass();
                    database.save(iLinkedRecord, schemaClass != null ? database.getClusterNameById(schemaClass.getDefaultClusterId()) : null);
                } else {
                    database.save(iLinkedRecord);
                }
                ODatabaseComplex<?> dbOwner = database.getDatabaseOwner();
                dbOwner.registerUserObjectAfterLinkSave(iLinkedRecord);
                resultRid = iLinkedRecord;
            }
            if (iParentRecord != null && database instanceof ODatabaseRecord && !(db = database).isRetainRecords()) {
                resultRid = iLinkedRecord.getIdentity();
            }
        }
        if (rid.isValid()) {
            rid.toString(buffer);
        }
        return resultRid;
    }
}

