/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OIntegerSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCompositeKeySerializer
implements OBinarySerializer<OCompositeKey>,
OStreamSerializer {
    public static final String NAME = "cks";
    public static final OCompositeKeySerializer INSTANCE = new OCompositeKeySerializer();
    public static final byte ID = 14;

    @Override
    public int getObjectSize(OCompositeKey compositeKey) {
        List<Object> keys = compositeKey.getKeys();
        int size = 8;
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (Object key : keys) {
            OType type = OType.getTypeByClass(key.getClass());
            size += 1 + factory.getObjectSerializer(type).getObjectSize(key);
        }
        return size;
    }

    @Override
    public void serialize(OCompositeKey compositeKey, byte[] stream, int startPosition) {
        List<Object> keys = compositeKey.getKeys();
        int keysSize = keys.size();
        int oldStartPosition = startPosition;
        OIntegerSerializer.INSTANCE.serialize(keysSize, stream, startPosition += 4);
        startPosition += 4;
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (Object key : keys) {
            OType type = OType.getTypeByClass(key.getClass());
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(type);
            stream[startPosition] = binarySerializer.getId();
            binarySerializer.serialize(key, stream, ++startPosition);
            startPosition += binarySerializer.getObjectSize(key);
        }
        OIntegerSerializer.INSTANCE.serialize(startPosition - oldStartPosition, stream, oldStartPosition);
    }

    @Override
    public OCompositeKey deserialize(byte[] stream, int startPosition) {
        OCompositeKey compositeKey = new OCompositeKey();
        int keysSize = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition += 4);
        startPosition += OIntegerSerializer.INSTANCE.getObjectSize(keysSize);
        OBinarySerializerFactory factory = OBinarySerializerFactory.INSTANCE;
        for (int i = 0; i < keysSize; ++i) {
            byte serializerId = stream[startPosition];
            OBinarySerializer<?> binarySerializer = factory.getObjectSerializer(serializerId);
            Object key = binarySerializer.deserialize(stream, ++startPosition);
            compositeKey.addKey(key);
            startPosition += binarySerializer.getObjectSize(key);
        }
        return compositeKey;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
    }

    @Override
    public byte getId() {
        return 14;
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        throw new UnsupportedOperationException("CSV storage format is out of dated and is not supported.");
    }

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        OCompositeKey compositeKey = new OCompositeKey();
        OMemoryInputStream inputStream = new OMemoryInputStream(iStream);
        int keysSize = inputStream.getAsInteger();
        for (int i = 0; i < keysSize; ++i) {
            byte[] keyBytes = inputStream.getAsByteArray();
            String keyString = OBinaryProtocol.bytes2string(keyBytes);
            int typeSeparatorPos = keyString.indexOf(44);
            OType type = OType.valueOf(keyString.substring(0, typeSeparatorPos));
            compositeKey.addKey(ORecordSerializerStringAbstract.simpleValueFromStream(keyString.substring(typeSeparatorPos + 1), type));
        }
        return compositeKey;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

