/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFloatSerializer
implements OBinarySerializer<Float> {
    public static OFloatSerializer INSTANCE = new OFloatSerializer();
    public static final byte ID = 7;
    public static final int FLOAT_SIZE = 4;

    @Override
    public int getObjectSize(Float object) {
        return 4;
    }

    @Override
    public void serialize(Float object, byte[] stream, int startPosition) {
        OBinaryProtocol.int2bytes(Float.floatToIntBits(object.floatValue()), stream, startPosition);
    }

    @Override
    public Float deserialize(byte[] stream, int startPosition) {
        return Float.valueOf(Float.intBitsToFloat(OBinaryProtocol.bytes2int(stream, startPosition)));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public byte getId() {
        return 7;
    }
}

