/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBinaryTypeSerializer
implements OBinarySerializer<byte[]> {
    public static final OBinaryTypeSerializer INSTANCE = new OBinaryTypeSerializer();
    public static final byte ID = 17;

    @Override
    public int getObjectSize(int length) {
        return length + 4;
    }

    @Override
    public int getObjectSize(byte[] object) {
        return object.length + 4;
    }

    @Override
    public void serialize(byte[] object, byte[] stream, int startPosition) {
        int len = object.length;
        OBinaryProtocol.int2bytes(len, stream, startPosition);
        System.arraycopy(object, 0, stream, startPosition + 4, len);
    }

    @Override
    public byte[] deserialize(byte[] stream, int startPosition) {
        int len = OBinaryProtocol.bytes2int(stream, startPosition);
        return Arrays.copyOfRange(stream, startPosition + 4, startPosition + 4 + len);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OBinaryProtocol.bytes2int(stream, startPosition) + 4;
    }

    @Override
    public byte getId() {
        return 17;
    }
}

