/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordTrackedList;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentComparator;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODocumentHelper {
    public static final String ATTRIBUTE_THIS = "@this";
    public static final String ATTRIBUTE_RID = "@rid";
    public static final String ATTRIBUTE_VERSION = "@version";
    public static final String ATTRIBUTE_CLASS = "@class";
    public static final String ATTRIBUTE_TYPE = "@type";
    public static final String ATTRIBUTE_SIZE = "@size";
    public static final String ATTRIBUTE_FIELDS = "@fields";
    public static final String ATTRIBUTE_RAW = "@raw";

    public static void sort(List<OIdentifiable> ioResultSet, List<OPair<String, String>> iOrderCriteria) {
        if (ioResultSet != null) {
            Collections.sort(ioResultSet, new ODocumentComparator(iOrderCriteria));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <RET> RET convertField(ODocument iDocument, String iFieldName, Class<?> iFieldType, Object iValue) {
        if (iFieldType == null) {
            return (RET)iValue;
        }
        if (ORID.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
            if (iValue instanceof ORecord) {
                return (RET)((ORecord)iValue).getIdentity();
            }
        } else if (ORecord.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID || iValue instanceof ORecord) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
        } else if (Set.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof Set) return (RET)iValue;
            Set<OIdentifiable> newValue = iValue instanceof ORecordLazyList || iValue instanceof ORecordLazyMap ? new OMVRBTreeRIDSet(iDocument) : new OTrackedSet(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.isEmpty()) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add((OIdentifiable)((Object)s));
                }
                return (RET)newValue;
            }
        } else if (List.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof List) return (RET)iValue;
            OTrackedList newValue = iValue instanceof OMVRBTreeRIDSet || iValue instanceof ORecordLazyMap ? new ORecordLazyList(iDocument) : new OTrackedList(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.isEmpty()) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
        } else if (iValue instanceof Enum) {
            iValue = Number.class.isAssignableFrom(iFieldType) ? Integer.valueOf(((Enum)iValue).ordinal()) : iValue.toString();
            if (!(iValue instanceof String) && !iFieldType.isAssignableFrom(iValue.getClass())) {
                throw new IllegalArgumentException("Property '" + iFieldName + "' of type '" + iFieldType + "' cannot accept value of type: " + iValue.getClass());
            }
        } else if (Date.class.isAssignableFrom(iFieldType) && iValue instanceof String && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            OStorageConfiguration config = iDocument.getDatabase().getStorage().getConfiguration();
            SimpleDateFormat formatter = config.getDateFormatInstance();
            if (((String)iValue).length() > config.dateFormat.length()) {
                formatter = config.getDateTimeFormatInstance();
            }
            try {
                Date newValue = formatter.parse((String)iValue);
                return (RET)newValue;
            }
            catch (ParseException pe) {
                String dateFormat = ((String)iValue).length() > config.dateFormat.length() ? config.dateTimeFormat : config.dateFormat;
                throw new OQueryParsingException("Error on conversion of date '" + iValue + "' using the format: " + dateFormat);
            }
        }
        iValue = OType.convert(iValue, iFieldType);
        return (RET)iValue;
    }

    public static <RET> RET getFieldValue(Object value, String iFieldName) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection || value.getClass().isArray()) {
            ArrayList<RET> tempResult = new ArrayList<RET>();
            for (Object o : OMultiValue.getMultiValueIterable(value)) {
                RET result = ODocumentHelper.getFieldValue(o, iFieldName);
                if (result == null) continue;
                tempResult.add(result);
            }
            return (RET)tempResult;
        }
        return ODocumentHelper.getSingleFieldValue(value, iFieldName);
    }

    protected static <RET> RET getSingleFieldValue(Object value, String iFieldName) {
        if (value == null) {
            return null;
        }
        int fieldNameLength = iFieldName.length();
        if (fieldNameLength == 0) {
            return (RET)value;
        }
        OIdentifiable currentRecord = value instanceof OIdentifiable ? (OIdentifiable)value : null;
        int beginPos = iFieldName.charAt(0) == '.' ? 1 : 0;
        int nextSeparatorPos = iFieldName.charAt(0) == '.' ? 1 : 0;
        do {
            String fieldName;
            int nextSeparator = 32;
            while (nextSeparatorPos < fieldNameLength && (nextSeparator = (int)iFieldName.charAt(nextSeparatorPos)) != 46 && nextSeparator != 91) {
                ++nextSeparatorPos;
            }
            if (nextSeparatorPos < fieldNameLength) {
                fieldName = iFieldName.substring(beginPos, nextSeparatorPos);
            } else {
                nextSeparator = 32;
                fieldName = beginPos > 0 ? iFieldName.substring(beginPos) : iFieldName;
            }
            if (nextSeparator == 91) {
                List<String> indexParts;
                int end;
                if (fieldName != null && fieldName.length() > 0) {
                    if (currentRecord != null) {
                        value = ODocumentHelper.getIdentifiableValue(currentRecord, fieldName);
                    } else if (value instanceof Map) {
                        value = ODocumentHelper.getMapEntry((Map)value, fieldName);
                    }
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof OIdentifiable) {
                    currentRecord = (OIdentifiable)value;
                }
                if ((end = iFieldName.indexOf(93, nextSeparatorPos)) == -1) {
                    throw new IllegalArgumentException("Missed closed ']'");
                }
                String index = OStringSerializerHelper.getStringContent(iFieldName.substring(nextSeparatorPos + 1, end));
                nextSeparatorPos = end;
                if (value instanceof OIdentifiable) {
                    Object record = currentRecord != null && currentRecord instanceof OIdentifiable ? currentRecord.getRecord() : null;
                    List<String> indexParts2 = OStringSerializerHelper.smartSplit(index, ',', new char[0]);
                    if (indexParts2.size() == 1) {
                        value = ((ODocument)record).field(index);
                    } else {
                        Object[] values = new Object[indexParts2.size()];
                        for (int i = 0; i < indexParts2.size(); ++i) {
                            values[i] = ((ODocument)record).field(indexParts2.get(i));
                        }
                        value = values;
                    }
                } else if (value instanceof Map) {
                    indexParts = OStringSerializerHelper.smartSplit(index, ',', new char[0]);
                    if (indexParts.size() == 1) {
                        value = ((Map)value).get(index);
                    } else {
                        Object[] values = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            values[i] = ((Map)value).get(indexParts.get(i));
                        }
                        value = values;
                    }
                } else if (value instanceof Collection || value.getClass().isArray()) {
                    Object[] values;
                    indexParts = OStringSerializerHelper.smartSplit(index, ',', new char[0]);
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(index, '-', new char[0]);
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(index, '=', ' ');
                    if (indexParts.size() == 1 && indexRanges.size() == 1 && indexCondition.size() == 1) {
                        value = value instanceof Map ? ODocumentHelper.getMapEntry((Map)value, index) : OMultiValue.getValue(value, Integer.parseInt(index));
                    } else if (indexParts.size() > 1) {
                        Object[] values2 = new Object[indexParts.size()];
                        for (int i = 0; i < indexParts.size(); ++i) {
                            values2[i] = OMultiValue.getValue(value, Integer.parseInt(indexParts.get(i)));
                        }
                        value = values2;
                    } else if (indexRanges.size() > 1) {
                        int rangeFrom = Integer.parseInt(indexRanges.get(0));
                        int rangeTo = Math.min(Integer.parseInt(indexRanges.get(1)), OMultiValue.getSize(value) - 1);
                        values = new Object[rangeTo - rangeFrom + 1];
                        for (int i = rangeFrom; i <= rangeTo; ++i) {
                            values[i - rangeFrom] = OMultiValue.getValue(value, i);
                        }
                        value = values;
                    } else if (!indexCondition.isEmpty()) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OStringSerializerHelper.getStringContent(conditionFieldValue);
                        }
                        values = new ArrayList();
                        for (Object v : OMultiValue.getMultiValueIterable(value)) {
                            Object fieldValue;
                            if (v instanceof ODocument) {
                                ODocument doc = (ODocument)v;
                                fieldValue = doc.field(conditionFieldName);
                                if ((fieldValue = OType.convert(fieldValue, conditionFieldValue.getClass())) == null || !fieldValue.equals(conditionFieldValue)) continue;
                                values.add(doc);
                                continue;
                            }
                            if (!(v instanceof Map)) continue;
                            Map map = (Map)v;
                            fieldValue = ODocumentHelper.getMapEntry(map, conditionFieldName);
                            if ((fieldValue = OType.convert(fieldValue, conditionFieldValue.getClass())) == null || !fieldValue.equals(conditionFieldValue)) continue;
                            values.add(map);
                        }
                        value = values.isEmpty() ? null : (values.size() == 1 ? values.get(0) : values);
                    }
                }
            } else if (fieldName.contains("(")) {
                value = ODocumentHelper.evaluateFunction(value, fieldName);
            } else if (currentRecord != null) {
                value = ODocumentHelper.getIdentifiableValue(currentRecord, fieldName);
                if (value != null && value instanceof ORecord && ((ORecord)value).getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    ((ORecord)value).reload();
                }
            } else if (value instanceof Map) {
                value = ODocumentHelper.getMapEntry((Map)value, fieldName);
            }
            if (value instanceof OIdentifiable) {
                currentRecord = (OIdentifiable)value;
            }
            beginPos = ++nextSeparatorPos;
        } while (nextSeparatorPos < fieldNameLength && value != null);
        return (RET)value;
    }

    public static Object getMapEntry(Map<String, ?> iMap, String iName) {
        if (iMap == null || iName == null) {
            return null;
        }
        int pos = iName.indexOf(46);
        String fieldName = pos > -1 ? iName.substring(0, pos) : iName;
        Object value = iMap.get(fieldName);
        if (value == null) {
            return null;
        }
        if (pos > -1) {
            String restFieldName = iName.substring(pos + 1);
            if (value instanceof ODocument) {
                return ODocumentHelper.getFieldValue(value, restFieldName);
            }
            if (value instanceof Map) {
                return ODocumentHelper.getMapEntry((Map)value, restFieldName);
            }
        }
        return value;
    }

    public static Object getIdentifiableValue(OIdentifiable iCurrent, String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        char begin = iFieldName.charAt(0);
        if (begin == '@') {
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_THIS)) {
                return iCurrent;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID)) {
                return iCurrent.getIdentity();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_VERSION)) {
                return ((ODocument)iCurrent.getRecord()).getVersion();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_CLASS)) {
                return ((ODocument)iCurrent.getRecord()).getClassName();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
                return Orient.instance().getRecordFactoryManager().getRecordTypeName(((ORecordInternal)iCurrent.getRecord()).getRecordType());
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_SIZE)) {
                byte[] stream = ((ORecordInternal)iCurrent.getRecord()).toStream();
                return stream != null ? stream.length : 0;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_FIELDS)) {
                return ((ODocument)iCurrent.getRecord()).fieldNames();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RAW)) {
                return new String(((ORecordInternal)iCurrent.getRecord()).toStream());
            }
            throw new IllegalArgumentException("Document attribute '" + iFieldName + "' not supported");
        }
        ODocument doc = (ODocument)iCurrent.getRecord();
        doc.checkForFields();
        return doc._fieldValues.get(iFieldName);
    }

    public static Object evaluateFunction(Object currentValue, String iFunction) {
        if (currentValue == null) {
            return null;
        }
        Object result = null;
        if ((iFunction = iFunction.toUpperCase()).startsWith("SIZE(")) {
            result = currentValue instanceof ORecord ? 1 : OMultiValue.getSize(currentValue);
        } else if (iFunction.startsWith("LENGTH(")) {
            result = currentValue.toString().length();
        } else if (iFunction.startsWith("TOUPPERCASE(")) {
            result = currentValue.toString().toUpperCase();
        } else if (iFunction.startsWith("TOLOWERCASE(")) {
            result = currentValue.toString().toLowerCase();
        } else if (iFunction.startsWith("TRIM(")) {
            result = currentValue.toString().trim();
        } else if (iFunction.startsWith("TOJSON(")) {
            result = currentValue instanceof ODocument ? ((ODocument)currentValue).toJSON() : null;
        } else if (iFunction.startsWith("KEYS(")) {
            result = currentValue instanceof Map ? ((Map)currentValue).keySet() : null;
        } else if (iFunction.startsWith("VALUES(")) {
            result = currentValue instanceof Map ? ((Map)currentValue).values() : null;
        } else if (iFunction.startsWith("ASSTRING(")) {
            result = currentValue.toString();
        } else if (iFunction.startsWith("ASINTEGER(")) {
            result = new Integer(currentValue.toString());
        } else if (iFunction.startsWith("ASFLOAT(")) {
            result = new Float(currentValue.toString());
        } else if (iFunction.startsWith("ASBOOLEAN(")) {
            if (currentValue instanceof String) {
                result = new Boolean((String)currentValue);
            } else if (currentValue instanceof Number) {
                int bValue = ((Number)currentValue).intValue();
                if (bValue == 0) {
                    result = Boolean.FALSE;
                } else if (bValue == 1) {
                    result = Boolean.TRUE;
                }
            }
        } else if (iFunction.startsWith("ASDATE(")) {
            if (currentValue instanceof Long) {
                result = new Date((Long)currentValue);
            } else {
                try {
                    result = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateFormatInstance().parse(currentValue.toString());
                }
                catch (ParseException e) {}
            }
        } else if (iFunction.startsWith("ASDATETIME(")) {
            if (currentValue instanceof Long) {
                result = new Date((Long)currentValue);
            } else {
                try {
                    result = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateTimeFormatInstance().parse(currentValue.toString());
                }
                catch (ParseException e) {}
            }
        } else {
            List<String> args = OStringSerializerHelper.getParameters(iFunction.substring(iFunction.indexOf(40)));
            if (iFunction.startsWith("CHARAT(")) {
                result = Character.valueOf(currentValue.toString().charAt(Integer.parseInt(args.get(0))));
            } else if (iFunction.startsWith("INDEXOF(")) {
                result = args.size() == 1 ? Integer.valueOf(currentValue.toString().indexOf(OStringSerializerHelper.getStringContent(args.get(0)))) : Integer.valueOf(currentValue.toString().indexOf(OStringSerializerHelper.getStringContent(args.get(0)), Integer.parseInt(args.get(1))));
            } else if (iFunction.startsWith("SUBSTRING(")) {
                result = args.size() == 1 ? currentValue.toString().substring(Integer.parseInt(args.get(0))) : currentValue.toString().substring(Integer.parseInt(args.get(0)), Integer.parseInt(args.get(1)));
            } else if (iFunction.startsWith("APPEND(")) {
                result = currentValue.toString() + OStringSerializerHelper.getStringContent(args.get(0));
            } else if (iFunction.startsWith("PREFIX(")) {
                result = OStringSerializerHelper.getStringContent(args.get(0)) + currentValue.toString();
            } else if (iFunction.startsWith("FORMAT(")) {
                result = String.format(OStringSerializerHelper.getStringContent(args.get(0)), currentValue.toString());
            } else if (iFunction.startsWith("LEFT(")) {
                String stringValue;
                int len = Integer.parseInt(args.get(0));
                result = stringValue.substring(0, len <= (stringValue = currentValue.toString()).length() ? len : stringValue.length());
            } else if (iFunction.startsWith("RIGHT(")) {
                String stringValue;
                int offset = Integer.parseInt(args.get(0));
                result = stringValue.substring(offset < (stringValue = currentValue.toString()).length() ? stringValue.length() - offset : 0);
            }
        }
        return result;
    }

    public static void copyFieldValue(ODocument iCloned, Map.Entry<String, Object> iEntry) {
        OProperty prop;
        Object fieldValue = iEntry.getValue();
        if (fieldValue != null) {
            if (fieldValue instanceof ORecordLazyList) {
                iCloned._fieldValues.put(iEntry.getKey(), ((ORecordLazyList)fieldValue).copy(iCloned));
            } else if (fieldValue instanceof ORecordTrackedList) {
                ORecordTrackedList newList = new ORecordTrackedList(iCloned);
                newList.addAll((ORecordTrackedList)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof OTrackedList) {
                OTrackedList newList = new OTrackedList(iCloned);
                newList.addAll((OTrackedList)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof List) {
                iCloned._fieldValues.put(iEntry.getKey(), new ArrayList((List)fieldValue));
            } else if (fieldValue instanceof OMVRBTreeRIDSet) {
                iCloned._fieldValues.put(iEntry.getKey(), ((OMVRBTreeRIDSet)fieldValue).copy(iCloned));
            } else if (fieldValue instanceof ORecordTrackedSet) {
                ORecordTrackedSet newList = new ORecordTrackedSet(iCloned);
                newList.addAll((ORecordTrackedSet)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof OTrackedSet) {
                OTrackedSet newList = new OTrackedSet(iCloned);
                newList.addAll((OTrackedSet)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newList);
            } else if (fieldValue instanceof Set) {
                iCloned._fieldValues.put(iEntry.getKey(), new HashSet((Set)fieldValue));
            } else if (fieldValue instanceof ORecordLazyMap) {
                ORecordLazyMap newMap = new ORecordLazyMap(iCloned, ((ORecordLazyMap)fieldValue).getRecordType());
                newMap.putAll((ORecordLazyMap)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newMap);
            } else if (fieldValue instanceof OTrackedMap) {
                OTrackedMap newMap = new OTrackedMap(iCloned);
                newMap.putAll((OTrackedMap)fieldValue);
                iCloned._fieldValues.put(iEntry.getKey(), newMap);
            } else if (fieldValue instanceof Map) {
                iCloned._fieldValues.put(iEntry.getKey(), new LinkedHashMap((Map)fieldValue));
            } else {
                iCloned._fieldValues.put(iEntry.getKey(), fieldValue);
            }
        } else if (iCloned.getSchemaClass() != null && (prop = iCloned.getSchemaClass().getProperty(iEntry.getKey())) != null && prop.isMandatory()) {
            iCloned._fieldValues.put(iEntry.getKey(), fieldValue);
        }
    }

    public static boolean hasSameContentItem(Object iCurrent, ODatabaseRecord iMyDb, Object iOther, ODatabaseRecord iOtherDb) {
        if (iCurrent instanceof ODocument) {
            ODocument otherDoc;
            ODocument current = (ODocument)iCurrent;
            if (iOther instanceof ORID ? (!current.isDirty() ? !current.getIdentity().equals(iOther) : !ODocumentHelper.hasSameContentOf(current, iMyDb, otherDoc = (ODocument)iOtherDb.load((ORID)iOther), iOtherDb)) : !ODocumentHelper.hasSameContentOf(current, iMyDb, (ODocument)iOther, iOtherDb)) {
                return false;
            }
        } else if (!ODocumentHelper.compareScalarValues(iCurrent, iOther)) {
            return false;
        }
        return true;
    }

    public static boolean hasSameContentOf(final ODocument iCurrent, ODatabaseRecord iMyDb, final ODocument iOther, ODatabaseRecord iOtherDb) {
        if (iOther == null) {
            return false;
        }
        if (!iCurrent.equals(iOther) && iCurrent.getIdentity().isValid()) {
            return false;
        }
        ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

            @Override
            public Object call() {
                if (iCurrent.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    iCurrent.reload();
                }
                return null;
            }
        });
        ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

            @Override
            public Object call() {
                if (iOther.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    iOther.reload();
                }
                return null;
            }
        });
        ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

            @Override
            public Object call() {
                iCurrent.checkForFields();
                return null;
            }
        });
        ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

            @Override
            public Object call() {
                iOther.checkForFields();
                return null;
            }
        });
        if (iCurrent._fieldValues.size() != iOther._fieldValues.size()) {
            return false;
        }
        for (Map.Entry<String, Object> f : iCurrent._fieldValues.entrySet()) {
            Object myFieldValue = f.getValue();
            Object otherFieldValue = iOther._fieldValues.get(f.getKey());
            if (myFieldValue == null ? otherFieldValue != null : otherFieldValue == null) {
                return false;
            }
            if (myFieldValue == null) continue;
            if (myFieldValue instanceof Set && otherFieldValue instanceof Set) {
                if (ODocumentHelper.compareSets(iMyDb, (Set)myFieldValue, iOtherDb, (Set)otherFieldValue)) continue;
                return false;
            }
            if (myFieldValue instanceof Collection && otherFieldValue instanceof Collection) {
                if (ODocumentHelper.compareCollections(iMyDb, (Collection)myFieldValue, iOtherDb, (Collection)otherFieldValue)) continue;
                return false;
            }
            if (myFieldValue instanceof Map && otherFieldValue instanceof Map) {
                if (ODocumentHelper.compareMaps(iMyDb, (Map)myFieldValue, iOtherDb, (Map)otherFieldValue)) continue;
                return false;
            }
            if (myFieldValue instanceof ODocument && otherFieldValue instanceof ODocument) {
                return ODocumentHelper.hasSameContentOf((ODocument)myFieldValue, iMyDb, (ODocument)otherFieldValue, iOtherDb);
            }
            if (ODocumentHelper.compareScalarValues(myFieldValue, otherFieldValue)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareMaps(ODatabaseRecord iMyDb, Map<Object, Object> myFieldValue, ODatabaseRecord iOtherDb, Map<Object, Object> otherFieldValue) {
        boolean bl;
        boolean oldOtherAutoConvert;
        boolean oldMyAutoConvert;
        Map<Object, Object> otherMap;
        Map<Object, Object> myMap;
        block16: {
            boolean bl2;
            block15: {
                boolean bl3;
                block14: {
                    boolean bl4;
                    block13: {
                        myMap = myFieldValue;
                        otherMap = otherFieldValue;
                        if (myMap.size() != otherMap.size()) {
                            return false;
                        }
                        oldMyAutoConvert = false;
                        oldOtherAutoConvert = false;
                        if (myMap instanceof ORecordLazyMultiValue) {
                            oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)myMap)).isAutoConvertToRecord();
                            ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(false);
                        }
                        if (otherMap instanceof ORecordLazyMultiValue) {
                            oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherMap)).isAutoConvertToRecord();
                            ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(false);
                        }
                        try {
                            final Iterator<Map.Entry<Object, Object>> myEntryIterator = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<Map.Entry<Object, Object>>>(){

                                @Override
                                public Iterator<Map.Entry<Object, Object>> call() {
                                    return myMap.entrySet().iterator();
                                }
                            });
                            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                                @Override
                                public Boolean call() {
                                    return myEntryIterator.hasNext();
                                }
                            }).booleanValue()) {
                                Object otherValue;
                                final Map.Entry<Object, Object> myEntry = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Map.Entry<Object, Object>>(){

                                    @Override
                                    public Map.Entry<Object, Object> call() {
                                        return (Map.Entry)myEntryIterator.next();
                                    }
                                });
                                final Object myKey = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                                    @Override
                                    public Object call() {
                                        return myEntry.getKey();
                                    }
                                });
                                if (ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                                    @Override
                                    public Boolean call() {
                                        return !otherMap.containsKey(myKey);
                                    }
                                }).booleanValue()) {
                                    bl4 = false;
                                    Object var15_16 = null;
                                    break block13;
                                }
                                if (myEntry.getValue() instanceof ODocument) {
                                    if (ODocumentHelper.hasSameContentOf(ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<ODocument>(){

                                        @Override
                                        public ODocument call() {
                                            return (ODocument)myEntry.getValue();
                                        }
                                    }), iMyDb, ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<ODocument>(){

                                        @Override
                                        public ODocument call() {
                                            return (ODocument)otherMap.get(myEntry.getKey());
                                        }
                                    }), iOtherDb)) continue;
                                    bl3 = false;
                                    break block14;
                                }
                                Object myValue = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                                    @Override
                                    public Object call() {
                                        return myEntry.getValue();
                                    }
                                });
                                if (ODocumentHelper.compareScalarValues(myValue, otherValue = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                                    @Override
                                    public Object call() {
                                        return otherMap.get(myEntry.getKey());
                                    }
                                }))) continue;
                                bl2 = false;
                                break block15;
                            }
                            bl = true;
                            break block16;
                        }
                        catch (Throwable throwable) {
                            Object var15_20 = null;
                            if (myMap instanceof ORecordLazyMultiValue) {
                                ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(oldMyAutoConvert);
                            }
                            if (!(otherMap instanceof ORecordLazyMultiValue)) throw throwable;
                            ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(oldOtherAutoConvert);
                            throw throwable;
                        }
                    }
                    if (myMap instanceof ORecordLazyMultiValue) {
                        ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(oldMyAutoConvert);
                    }
                    if (!(otherMap instanceof ORecordLazyMultiValue)) return bl4;
                    ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(oldOtherAutoConvert);
                    return bl4;
                }
                Object var15_17 = null;
                if (myMap instanceof ORecordLazyMultiValue) {
                    ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(oldMyAutoConvert);
                }
                if (!(otherMap instanceof ORecordLazyMultiValue)) return bl3;
                ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(oldOtherAutoConvert);
                return bl3;
            }
            Object var15_18 = null;
            if (myMap instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (!(otherMap instanceof ORecordLazyMultiValue)) return bl2;
            ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(oldOtherAutoConvert);
            return bl2;
        }
        Object var15_19 = null;
        if (myMap instanceof ORecordLazyMultiValue) {
            ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(oldMyAutoConvert);
        }
        if (!(otherMap instanceof ORecordLazyMultiValue)) return bl;
        ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(oldOtherAutoConvert);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareCollections(ODatabaseRecord iMyDb, Collection<?> myFieldValue, ODatabaseRecord iOtherDb, Collection<?> otherFieldValue) {
        boolean bl;
        boolean oldOtherAutoConvert;
        boolean oldMyAutoConvert;
        Collection<?> otherCollection;
        Collection<?> myCollection;
        block10: {
            boolean bl2;
            block9: {
                myCollection = myFieldValue;
                otherCollection = otherFieldValue;
                if (myCollection.size() != otherCollection.size()) {
                    return false;
                }
                oldMyAutoConvert = false;
                oldOtherAutoConvert = false;
                if (myCollection instanceof ORecordLazyMultiValue) {
                    oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)myCollection)).isAutoConvertToRecord();
                    ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(false);
                }
                if (otherCollection instanceof ORecordLazyMultiValue) {
                    oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherCollection)).isAutoConvertToRecord();
                    ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(false);
                }
                try {
                    final Iterator myIterator = (Iterator)ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<?>>(){

                        @Override
                        public Iterator<?> call() {
                            return myCollection.iterator();
                        }
                    });
                    final Iterator otherIterator = (Iterator)ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Iterator<?>>(){

                        @Override
                        public Iterator<?> call() {
                            return otherCollection.iterator();
                        }
                    });
                    while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                        @Override
                        public Boolean call() {
                            return myIterator.hasNext();
                        }
                    }).booleanValue()) {
                        Object otherNextVal;
                        Object myNextVal = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                            @Override
                            public Object call() {
                                return myIterator.next();
                            }
                        });
                        if (ODocumentHelper.hasSameContentItem(myNextVal, iMyDb, otherNextVal = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                            @Override
                            public Object call() {
                                return otherIterator.next();
                            }
                        }), iOtherDb)) continue;
                        bl2 = false;
                        Object var14_14 = null;
                        break block9;
                    }
                    bl = true;
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    if (myCollection instanceof ORecordLazyMultiValue) {
                        ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(oldMyAutoConvert);
                    }
                    if (!(otherCollection instanceof ORecordLazyMultiValue)) throw throwable;
                    ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(oldOtherAutoConvert);
                    throw throwable;
                }
            }
            if (myCollection instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (!(otherCollection instanceof ORecordLazyMultiValue)) return bl2;
            ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(oldOtherAutoConvert);
            return bl2;
        }
        Object var14_15 = null;
        if (myCollection instanceof ORecordLazyMultiValue) {
            ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(oldMyAutoConvert);
        }
        if (!(otherCollection instanceof ORecordLazyMultiValue)) return bl;
        ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(oldOtherAutoConvert);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareSets(ODatabaseRecord iMyDb, Set<?> myFieldValue, ODatabaseRecord iOtherDb, Set<?> otherFieldValue) {
        boolean bl;
        boolean oldOtherAutoConvert;
        boolean oldMyAutoConvert;
        Set<?> otherSet;
        Set<?> mySet;
        block11: {
            boolean bl2;
            block10: {
                int otherSize;
                mySet = myFieldValue;
                otherSet = otherFieldValue;
                int mySize = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Integer>(){

                    @Override
                    public Integer call() {
                        return mySet.size();
                    }
                });
                if (mySize != (otherSize = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Integer>(){

                    @Override
                    public Integer call() {
                        return otherSet.size();
                    }
                }).intValue())) {
                    return false;
                }
                oldMyAutoConvert = false;
                oldOtherAutoConvert = false;
                if (mySet instanceof ORecordLazyMultiValue) {
                    oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)mySet)).isAutoConvertToRecord();
                    ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(false);
                }
                if (otherSet instanceof ORecordLazyMultiValue) {
                    oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherSet)).isAutoConvertToRecord();
                    ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(false);
                }
                try {
                    final Iterator myIterator = (Iterator)ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<?>>(){

                        @Override
                        public Iterator<?> call() {
                            return mySet.iterator();
                        }
                    });
                    while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                        @Override
                        public Boolean call() {
                            return myIterator.hasNext();
                        }
                    }).booleanValue()) {
                        final Iterator otherIterator = (Iterator)ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Iterator<?>>(){

                            @Override
                            public Iterator<?> call() {
                                return otherSet.iterator();
                            }
                        });
                        Object myNextVal = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                            @Override
                            public Object call() {
                                return myIterator.next();
                            }
                        });
                        boolean found = false;
                        while (!found && ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                            @Override
                            public Boolean call() {
                                return otherIterator.hasNext();
                            }
                        }).booleanValue()) {
                            Object otherNextVal = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                                @Override
                                public Object call() {
                                    return otherIterator.next();
                                }
                            });
                            found = ODocumentHelper.hasSameContentItem(myNextVal, iMyDb, otherNextVal, iOtherDb);
                        }
                        if (found) continue;
                        bl2 = false;
                        Object var16_17 = null;
                        break block10;
                    }
                    bl = true;
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    if (mySet instanceof ORecordLazyMultiValue) {
                        ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(oldMyAutoConvert);
                    }
                    if (!(otherSet instanceof ORecordLazyMultiValue)) throw throwable;
                    ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(oldOtherAutoConvert);
                    throw throwable;
                }
            }
            if (mySet instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (!(otherSet instanceof ORecordLazyMultiValue)) return bl2;
            ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(oldOtherAutoConvert);
            return bl2;
        }
        Object var16_18 = null;
        if (mySet instanceof ORecordLazyMultiValue) {
            ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(oldMyAutoConvert);
        }
        if (!(otherSet instanceof ORecordLazyMultiValue)) return bl;
        ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(oldOtherAutoConvert);
        return bl;
    }

    private static boolean compareScalarValues(Object myValue, Object otherValue) {
        if (myValue == null && otherValue != null || myValue != null && otherValue == null) {
            return false;
        }
        if (myValue == null) {
            return true;
        }
        if (myValue.getClass().isArray() && !otherValue.getClass().isArray() || !myValue.getClass().isArray() && otherValue.getClass().isArray()) {
            return false;
        }
        if (myValue.getClass().isArray() && otherValue.getClass().isArray()) {
            int otherArraySize;
            int myArraySize = Array.getLength(myValue);
            if (myArraySize != (otherArraySize = Array.getLength(otherValue))) {
                return false;
            }
            for (int i = 0; i < myArraySize; ++i) {
                if (Array.get(myValue, i).equals(Array.get(otherValue, i))) continue;
                return false;
            }
            return true;
        }
        if (myValue instanceof Number && otherValue instanceof Number) {
            Number myNumberValue = (Number)myValue;
            Number otherNumberValue = (Number)otherValue;
            if (ODocumentHelper.isInteger(myNumberValue) && ODocumentHelper.isInteger(otherNumberValue)) {
                return myNumberValue.longValue() == otherNumberValue.longValue();
            }
            if (ODocumentHelper.isFloat(myNumberValue) && ODocumentHelper.isFloat(otherNumberValue)) {
                return myNumberValue.doubleValue() == otherNumberValue.doubleValue();
            }
        }
        return myValue.equals(otherValue);
    }

    private static boolean isInteger(Number value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    private static boolean isFloat(Number value) {
        return value instanceof Float || value instanceof Double;
    }

    public static void deleteCrossRefs(ORID iRid, ODocument iContent) {
        for (String fieldName : iContent.fieldNames()) {
            Object fieldValue = iContent.field(fieldName);
            if (fieldValue == null) continue;
            if (fieldValue.equals(iRid)) {
                iContent.field(fieldName, (Object)null);
                iContent.save();
                continue;
            }
            if (fieldValue instanceof ODocument && ((ODocument)fieldValue).isEmbedded()) {
                ODocumentHelper.deleteCrossRefs(iRid, (ODocument)fieldValue);
                continue;
            }
            if (!OMultiValue.isMultiValue(fieldValue)) continue;
            Iterator<Object> it = OMultiValue.getMultiValueIterator(fieldValue);
            while (it.hasNext()) {
                Object item = it.next();
                if (fieldValue.equals(iRid)) {
                    it.remove();
                    continue;
                }
                if (!(item instanceof ODocument) || !((ODocument)item).isEmbedded()) continue;
                ODocumentHelper.deleteCrossRefs(iRid, (ODocument)item);
            }
        }
    }

    public static <T> T makeDbCall(ODatabaseRecord databaseRecord, ODbRelatedCall<T> function) {
        ODatabaseRecordThreadLocal.INSTANCE.set(databaseRecord);
        return function.call();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ODbRelatedCall<T> {
        public T call();
    }
}

