/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.annotation.OBeforeDeserialization;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORole
extends ODocumentWrapper {
    public static final String ADMIN = "admin";
    private static Map<Integer, String> PERMISSION_BIT_NAMES;
    public static final int PERMISSION_NONE = 0;
    public static final int PERMISSION_CREATE;
    public static final int PERMISSION_READ;
    public static final int PERMISSION_UPDATE;
    public static final int PERMISSION_DELETE;
    public static final int PERMISSION_ALL;
    protected static final byte STREAM_DENY = 0;
    protected static final byte STREAM_ALLOW = 1;
    protected ALLOW_MODES mode = ALLOW_MODES.DENY_ALL_BUT;
    protected ORole parentRole;
    protected Map<String, Byte> rules = new LinkedHashMap<String, Byte>();

    public ORole() {
    }

    public ORole(String iName, ORole iParent, ALLOW_MODES iAllowMode) {
        super("ORole");
        this.document.field("name", iName);
        this.parentRole = iParent;
        this.document.field("inheritedRole", this.parentRole != null ? this.parentRole.getName() : null);
        this.setMode(iAllowMode);
        this.document.field("rules", new HashMap());
    }

    public ORole(ODocument iSource) {
        this.fromStream(iSource);
    }

    @Override
    @OBeforeDeserialization
    public void fromStream(ODocument iSource) {
        if (this.document != null) {
            return;
        }
        this.document = iSource;
        this.mode = ((Number)this.document.field("mode")).byteValue() == 1 ? ALLOW_MODES.ALLOW_ALL_BUT : ALLOW_MODES.DENY_ALL_BUT;
        String roleName = (String)this.document.field("inheritedRole");
        this.parentRole = roleName != null ? this.document.getDatabase().getMetadata().getSecurity().getRole(roleName) : null;
        Map storedRules = (Map)this.document.field("rules");
        if (storedRules != null) {
            for (Map.Entry a : storedRules.entrySet()) {
                this.rules.put((String)a.getKey(), ((Number)a.getValue()).byteValue());
            }
        }
    }

    public boolean allow(String iResource, int iCRUDOperation) {
        Byte access = this.rules.get(iResource);
        if (access != null) {
            byte mask = (byte)iCRUDOperation;
            return (access & mask) == mask;
        }
        return this.mode == ALLOW_MODES.ALLOW_ALL_BUT;
    }

    public boolean hasRule(String iResource) {
        return this.rules.containsKey(iResource);
    }

    public void addRule(String iResource, int iOperation) {
        this.rules.put(iResource, (byte)iOperation);
        this.document.field("rules", this.rules);
    }

    public void grant(String iResource, int iOperation) {
        Byte current = this.rules.get(iResource);
        byte currentValue = current == null ? (byte)0 : current;
        currentValue = (byte)(currentValue | (byte)iOperation);
        this.rules.put(iResource, currentValue);
        this.document.field("rules", this.rules);
    }

    public void revoke(String iResource, int iOperation) {
        byte currentValue;
        if (iOperation == 0) {
            return;
        }
        Byte current = this.rules.get(iResource);
        if (current == null) {
            currentValue = 0;
        } else {
            currentValue = current;
            currentValue = (byte)(currentValue & ~((byte)iOperation));
        }
        this.rules.put(iResource, currentValue);
        this.document.field("rules", this.rules);
    }

    public String getName() {
        return (String)this.document.field("name");
    }

    public ALLOW_MODES getMode() {
        return this.mode;
    }

    public ORole setMode(ALLOW_MODES iMode) {
        this.mode = iMode;
        this.document.field("mode", this.mode == ALLOW_MODES.ALLOW_ALL_BUT ? (byte)1 : 0);
        return this;
    }

    public ORole getParentRole() {
        return this.parentRole;
    }

    public ORole setParentRole(ORole iParent) {
        this.parentRole = iParent;
        this.document.field("inheritedRole", this.parentRole != null ? this.parentRole.getName() : null);
        return this;
    }

    public ORole save() {
        this.document.save(ORole.class.getSimpleName());
        return this;
    }

    public Map<String, Byte> getRules() {
        return Collections.unmodifiableMap(this.rules);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public static String permissionToString(int iPermission) {
        int permission = iPermission;
        StringBuilder returnValue = new StringBuilder();
        for (Map.Entry<Integer, String> p : PERMISSION_BIT_NAMES.entrySet()) {
            if ((permission & p.getKey()) != p.getKey()) continue;
            if (returnValue.length() > 0) {
                returnValue.append(", ");
            }
            returnValue.append(p.getValue());
            permission &= ~p.getKey().intValue();
        }
        if (permission != 0) {
            if (returnValue.length() > 0) {
                returnValue.append(", ");
            }
            returnValue.append("Unknown 0x");
            returnValue.append(Integer.toHexString(permission));
        }
        return returnValue.toString();
    }

    public static int registerPermissionBit(int iBitNo, String iName) {
        if (iBitNo < 0 || iBitNo > 31) {
            throw new IndexOutOfBoundsException("Permission bit number must be positive and less than 32");
        }
        int value = 1 << iBitNo;
        if (PERMISSION_BIT_NAMES == null) {
            PERMISSION_BIT_NAMES = new HashMap<Integer, String>();
        }
        if (PERMISSION_BIT_NAMES.containsKey(value)) {
            throw new IndexOutOfBoundsException("Permission bit number " + String.valueOf(iBitNo) + " already in use");
        }
        PERMISSION_BIT_NAMES.put(value, iName);
        return value;
    }

    static {
        PERMISSION_CREATE = ORole.registerPermissionBit(0, "Create");
        PERMISSION_READ = ORole.registerPermissionBit(1, "Read");
        PERMISSION_UPDATE = ORole.registerPermissionBit(2, "Update");
        PERMISSION_DELETE = ORole.registerPermissionBit(3, "Delete");
        PERMISSION_ALL = PERMISSION_CREATE + PERMISSION_READ + PERMISSION_UPDATE + PERMISSION_DELETE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ALLOW_MODES {
        DENY_ALL_BUT,
        ALLOW_ALL_BUT;

    }
}

