/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OBinary;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OType {
    BOOLEAN("Boolean", 0, new Class[]{Boolean.class, Boolean.TYPE}, new Class[]{Boolean.class, Number.class}){}
    ,
    INTEGER("Integer", 1, new Class[]{Integer.class, Integer.TYPE}, new Class[]{Integer.class, Number.class}){}
    ,
    SHORT("Short", 2, new Class[]{Short.class, Short.TYPE}, new Class[]{Short.class, Number.class}){}
    ,
    LONG("Long", 3, new Class[]{Long.class, Long.TYPE}, new Class[]{Long.class, Number.class}){}
    ,
    FLOAT("Float", 4, new Class[]{Float.class, Float.TYPE}, new Class[]{Float.class, Number.class}){}
    ,
    DOUBLE("Double", 5, new Class[]{Double.class, Double.TYPE}, new Class[]{Double.class, Number.class}){}
    ,
    DATETIME("Datetime", 6, new Class[]{Date.class}, new Class[]{Date.class, Number.class}){}
    ,
    STRING("String", 7, new Class[]{String.class}, new Class[]{String.class}){}
    ,
    BINARY("Binary", 8, new Class[]{byte[].class}, new Class[]{byte[].class}){}
    ,
    EMBEDDED("Embedded", 9, new Class[]{Object.class}, new Class[]{OSerializableStream.class}){}
    ,
    EMBEDDEDLIST("EmbeddedList", 10, new Class[]{List.class}, new Class[]{List.class}){}
    ,
    EMBEDDEDSET("EmbeddedSet", 11, new Class[]{Set.class}, new Class[]{Set.class}){}
    ,
    EMBEDDEDMAP("EmbeddedMap", 12, new Class[]{Map.class}, new Class[]{Map.class}){}
    ,
    LINK("Link", 13, new Class[]{Object.class, ORecordId.class}, new Class[]{ORecord.class, ORID.class}){}
    ,
    LINKLIST("LinkList", 14, new Class[]{List.class}, new Class[]{List.class}){}
    ,
    LINKSET("LinkSet", 15, new Class[]{Set.class}, new Class[]{Set.class}){}
    ,
    LINKMAP("LinkMap", 16, new Class[]{Map.class}, new Class[]{Map.class}){}
    ,
    BYTE("Byte", 17, new Class[]{Byte.class, Byte.TYPE}, new Class[]{Byte.class, Number.class}){}
    ,
    TRANSIENT("Transient", 18, new Class[0], new Class[0]){}
    ,
    DATE("Date", 19, new Class[]{Date.class}, new Class[]{Date.class, Number.class}){}
    ,
    CUSTOM("Custom", 20, new Class[]{OSerializableStream.class}, new Class[]{OSerializableStream.class}){}
    ,
    DECIMAL("Decimal", 21, new Class[]{BigDecimal.class}, new Class[]{BigDecimal.class, Number.class}){};

    protected static final OType[] TYPES;
    protected String name;
    protected int id;
    protected Class<?>[] javaTypes;
    protected Class<?>[] allowAssignmentFrom;

    private OType(String iName, int iId, Class<?>[] iJavaTypes, Class<?>[] iAllowAssignmentBy) {
        this.name = iName;
        this.id = iId;
        this.javaTypes = iJavaTypes;
        this.allowAssignmentFrom = iAllowAssignmentBy;
    }

    public static OType getById(byte iId) {
        for (OType t : TYPES) {
            if (iId != t.id) continue;
            return t;
        }
        return null;
    }

    public static OType getTypeByClass(Class<?> iClass) {
        boolean comparedAtLeastOnce;
        if (iClass == null) {
            return null;
        }
        for (OType type : TYPES) {
            for (int i = 0; i < type.javaTypes.length; ++i) {
                if (type.javaTypes[i] == iClass) {
                    return type;
                }
                if (type.javaTypes[i] != Array.class || !iClass.isArray()) continue;
                return type;
            }
        }
        int priority = 0;
        do {
            comparedAtLeastOnce = false;
            for (OType type : TYPES) {
                if (type.allowAssignmentFrom.length <= priority) continue;
                if (type.allowAssignmentFrom[priority].isAssignableFrom(iClass)) {
                    return type;
                }
                if (type.allowAssignmentFrom[priority].isArray() && iClass.isArray()) {
                    return type;
                }
                comparedAtLeastOnce = true;
            }
            ++priority;
        } while (comparedAtLeastOnce);
        return null;
    }

    public int asInt(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).intValue();
        }
        if (iValue instanceof String) {
            return Integer.valueOf((String)iValue);
        }
        if (iValue instanceof Boolean) {
            return (Boolean)iValue != false ? 1 : 0;
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to int for type: " + this.name);
    }

    public long asLong(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).longValue();
        }
        if (iValue instanceof String) {
            return Long.valueOf((String)iValue);
        }
        if (iValue instanceof Boolean) {
            return (Boolean)iValue != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to long for type: " + this.name);
    }

    public float asFloat(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).floatValue();
        }
        if (iValue instanceof String) {
            return Float.valueOf((String)iValue).floatValue();
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to float for type: " + this.name);
    }

    public double asDouble(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).doubleValue();
        }
        if (iValue instanceof String) {
            return Double.valueOf((String)iValue);
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to double for type: " + this.name);
    }

    public String asString(Object iValue) {
        return iValue.toString();
    }

    public static boolean isSimpleType(Object iObject) {
        if (iObject == null) {
            return false;
        }
        Class<?> iType = iObject.getClass();
        return iType.isPrimitive() || Number.class.isAssignableFrom(iType) || String.class.isAssignableFrom(iType) || Boolean.class.isAssignableFrom(iType) || Date.class.isAssignableFrom(iType) || iType.isArray() && (iType.equals(byte[].class) || iType.equals(char[].class) || iType.equals(int[].class) || iType.equals(long[].class) || iType.equals(double[].class) || iType.equals(float[].class) || iType.equals(short[].class) || iType.equals(Integer[].class) || iType.equals(String[].class) || iType.equals(Long[].class) || iType.equals(Short[].class) || iType.equals(Double[].class));
    }

    public static Object convert(Object iValue, Class<?> iTargetClass) {
        if (iValue == null) {
            return null;
        }
        if (iValue.getClass().equals(iTargetClass)) {
            return iValue;
        }
        if (iTargetClass.isAssignableFrom(iValue.getClass())) {
            return iValue;
        }
        try {
            if (iValue instanceof OBinary && iTargetClass.isAssignableFrom(byte[].class)) {
                return ((OBinary)iValue).toByteArray();
            }
            if (byte[].class.isAssignableFrom(iTargetClass)) {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
            if (byte[].class.isAssignableFrom(iValue.getClass())) {
                return iValue;
            }
            if (iTargetClass.isEnum()) {
                if (iValue instanceof Number) {
                    return ((Enum[])iTargetClass.getEnumConstants())[((Number)iValue).intValue()];
                }
                return Enum.valueOf(iTargetClass, iValue.toString());
            }
            if (iTargetClass.equals(Byte.TYPE) || iTargetClass.equals(Byte.class)) {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Byte.parseByte((String)iValue);
                }
                return ((Number)iValue).byteValue();
            }
            if (iTargetClass.equals(Short.TYPE) || iTargetClass.equals(Short.class)) {
                if (iValue instanceof Short) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Short.parseShort((String)iValue);
                }
                return ((Number)iValue).shortValue();
            }
            if (iTargetClass.equals(Integer.TYPE) || iTargetClass.equals(Integer.class)) {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Integer.parseInt((String)iValue);
                }
                return ((Number)iValue).intValue();
            }
            if (iTargetClass.equals(Long.TYPE) || iTargetClass.equals(Long.class)) {
                if (iValue instanceof Long) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Long.parseLong((String)iValue);
                }
                return ((Number)iValue).longValue();
            }
            if (iTargetClass.equals(Float.TYPE) || iTargetClass.equals(Float.class)) {
                if (iValue instanceof Float) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)iValue));
                }
                return Float.valueOf(((Number)iValue).floatValue());
            }
            if (iTargetClass.equals(BigDecimal.class)) {
                if (iValue instanceof BigDecimal) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return new BigDecimal((String)iValue);
                }
                if (iValue instanceof Number) {
                    return new BigDecimal(iValue.toString());
                }
            } else {
                if (iTargetClass.equals(Double.TYPE) || iTargetClass.equals(Double.class)) {
                    if (iValue instanceof Double) {
                        return iValue;
                    }
                    if (iValue instanceof String) {
                        return Double.parseDouble((String)iValue);
                    }
                    return ((Number)iValue).doubleValue();
                }
                if (iTargetClass.equals(Boolean.TYPE) || iTargetClass.equals(Boolean.class)) {
                    if (iValue instanceof Boolean) {
                        return (boolean)((Boolean)iValue);
                    }
                    if (iValue instanceof String) {
                        return ((String)iValue).equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                    }
                    if (iValue instanceof Number) {
                        return ((Number)iValue).intValue() != 0;
                    }
                } else {
                    if (iValue instanceof Collection && Set.class.isAssignableFrom(iTargetClass)) {
                        HashSet set = new HashSet();
                        set.addAll((Collection)iValue);
                        return set;
                    }
                    if (iTargetClass.equals(Date.class)) {
                        if (iValue instanceof Number) {
                            return new Date(((Number)iValue).longValue());
                        }
                        if (iValue instanceof String) {
                            try {
                                return ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateTimeFormatInstance().parse((String)iValue);
                            }
                            catch (ParseException e) {
                                return ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateFormatInstance().parse((String)iValue);
                            }
                        }
                    } else if (iTargetClass.equals(String.class)) {
                        return iValue.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            OLogManager.instance().debug(OType.class, "Error in conversion of value '%s' to type '%s'", iValue, iTargetClass);
            return null;
        }
        return iValue;
    }

    public Class<?> getDefaultJavaType() {
        return this.javaTypes.length > 0 ? this.javaTypes[0] : null;
    }

    public Class<?>[] getJavaTypes() {
        return this.javaTypes;
    }

    public static Number increment(Number a, Number b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Cannot increment a null value");
        }
        if (a instanceof Integer) {
            if (b instanceof Integer) {
                return new Integer(a.intValue() + b.intValue());
            }
            if (b instanceof Long) {
                return new Long((long)a.intValue() + b.longValue());
            }
            if (b instanceof Short) {
                return new Integer(a.intValue() + b.shortValue());
            }
            if (b instanceof Float) {
                return new Float((float)a.intValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.intValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.intValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Long) {
            if (b instanceof Integer) {
                return new Long(a.longValue() + (long)b.intValue());
            }
            if (b instanceof Long) {
                return new Long(a.longValue() + b.longValue());
            }
            if (b instanceof Short) {
                return new Long(a.longValue() + (long)b.shortValue());
            }
            if (b instanceof Float) {
                return new Float((float)a.longValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.longValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.longValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Short) {
            if (b instanceof Integer) {
                return new Integer(a.shortValue() + b.intValue());
            }
            if (b instanceof Long) {
                return new Long((long)a.shortValue() + b.longValue());
            }
            if (b instanceof Short) {
                return new Short((short)(a.shortValue() + b.shortValue()));
            }
            if (b instanceof Float) {
                return new Float((float)a.shortValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.shortValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.shortValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Float) {
            if (b instanceof Integer) {
                return new Float(a.floatValue() + (float)b.intValue());
            }
            if (b instanceof Long) {
                return new Float(a.floatValue() + (float)b.longValue());
            }
            if (b instanceof Short) {
                return new Float(a.floatValue() + (float)b.shortValue());
            }
            if (b instanceof Float) {
                return new Float(a.floatValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.floatValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.floatValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Double) {
            if (b instanceof Integer) {
                return new Double(a.doubleValue() + (double)b.intValue());
            }
            if (b instanceof Long) {
                return new Double(a.doubleValue() + (double)b.longValue());
            }
            if (b instanceof Short) {
                return new Double(a.doubleValue() + (double)b.shortValue());
            }
            if (b instanceof Float) {
                return new Double(a.doubleValue() + (double)b.floatValue());
            }
            if (b instanceof Double) {
                return new Double(a.doubleValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.doubleValue()).add((BigDecimal)b);
            }
        } else if (a instanceof BigDecimal) {
            if (b instanceof Integer) {
                return ((BigDecimal)a).add(new BigDecimal(b.intValue()));
            }
            if (b instanceof Long) {
                return ((BigDecimal)a).add(new BigDecimal(b.longValue()));
            }
            if (b instanceof Short) {
                return ((BigDecimal)a).add(new BigDecimal(b.shortValue()));
            }
            if (b instanceof Float) {
                return ((BigDecimal)a).add(new BigDecimal(b.floatValue()));
            }
            if (b instanceof Double) {
                return ((BigDecimal)a).add(new BigDecimal(b.doubleValue()));
            }
            if (b instanceof BigDecimal) {
                return ((BigDecimal)a).add((BigDecimal)b);
            }
        }
        throw new IllegalArgumentException("Cannot increment value '" + a + "' (" + a.getClass() + ") with '" + b + "' (" + b.getClass() + ")");
    }

    static {
        TYPES = new OType[]{STRING, BOOLEAN, BYTE, INTEGER, SHORT, LONG, FLOAT, DOUBLE, DATE, DATETIME, BINARY, EMBEDDEDLIST, EMBEDDEDSET, EMBEDDEDMAP, LINK, LINKLIST, LINKSET, LINKMAP, EMBEDDED, CUSTOM, TRANSIENT, DECIMAL};
    }
}

