/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OClassImpl
extends ODocumentWrapperNoClass
implements OClass {
    protected OSchemaShared owner;
    protected String name;
    protected Class<?> javaClass;
    protected final Map<String, OProperty> properties = new HashMap<String, OProperty>();
    protected int[] clusterIds;
    protected int defaultClusterId;
    protected OClassImpl superClass;
    protected int[] polymorphicClusterIds;
    protected List<OClass> baseClasses;
    protected float overSize = 0.0f;
    protected String shortName;
    protected boolean strictMode = false;

    public OClassImpl() {
    }

    protected OClassImpl(OSchemaShared iOwner) {
        this.document = new ODocument();
        this.owner = iOwner;
    }

    protected OClassImpl(OSchemaShared iOwner, ODocument iDocument) {
        this.document = iDocument;
        this.owner = iOwner;
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, String iJavaClassName, int[] iClusterIds) throws ClassNotFoundException {
        this(iOwner, iName, iClusterIds);
        this.javaClass = Class.forName(iJavaClassName);
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        this(iOwner);
        this.name = iName;
        this.setClusterIds(iClusterIds);
        this.setPolymorphicClusterIds(iClusterIds);
        this.defaultClusterId = iClusterIds[0];
    }

    @Override
    public <T> T newInstance() throws InstantiationException, IllegalAccessException {
        if (this.javaClass == null) {
            throw new IllegalArgumentException("Cannot create an instance of class '" + this.name + "' since no Java class was specified");
        }
        return (T)this.javaClass.newInstance();
    }

    public void validateInstances() {
        ODatabaseComplex current;
        for (current = this.getDatabase().getDatabaseOwner(); current != null && current.getUnderlying() instanceof ODatabaseComplex && !(current instanceof ODatabaseDocumentTx); current = (ODatabaseComplex)current.getUnderlying()) {
        }
        if (current != null) {
            for (ODocument d : ((ODatabaseDocumentTx)current).browseClass(this.name, true)) {
                d.validate();
            }
        }
    }

    @Override
    public OClass getSuperClass() {
        return this.superClass;
    }

    @Override
    public OClass setSuperClass(OClass iSuperClass) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s superclass %s", this.name, iSuperClass.getName());
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setSuperClassInternal(iSuperClass);
        return this;
    }

    public void setSuperClassInternal(OClass iSuperClass) {
        this.superClass = (OClassImpl)iSuperClass;
        this.superClass.addBaseClasses(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OClass setName(String iName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s name %s", this.name, iName);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.name = iName;
        return this;
    }

    public void setNameInternal(String iName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.owner.changeClassName(this.name, iName);
        this.name = iName;
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (int clusterId : this.clusterIds) {
            size += this.getDatabase().getClusterRecordSizeById(clusterId);
        }
        return size;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public OClass setShortName(String iShortName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s shortname %s", this.name, iShortName);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setShortNameInternal(iShortName);
        return this;
    }

    public void setShortNameInternal(String iShortName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        if (this.shortName != null) {
            this.owner.classes.remove(this.shortName);
        }
        this.shortName = iShortName;
        this.owner.classes.put(iShortName.toLowerCase(), this);
    }

    @Override
    public String getStreamableName() {
        return this.shortName != null ? this.shortName : this.name;
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public Collection<OProperty> properties() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        ArrayList<OProperty> props = null;
        OClassImpl currentClass = this;
        do {
            if (currentClass.properties == null) continue;
            if (props == null) {
                props = new ArrayList<OProperty>();
            }
            props.addAll(currentClass.properties.values());
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return props != null ? props : Collections.emptyList();
    }

    @Override
    public Collection<OProperty> getIndexedProperties() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        List<OProperty> indexedProps = null;
        OClassImpl currentClass = this;
        do {
            if (currentClass.properties == null) continue;
            for (OProperty p : currentClass.properties.values()) {
                if (!this.areIndexed(p.getName())) continue;
                if (indexedProps == null) {
                    indexedProps = new ArrayList<OProperty>();
                }
                indexedProps.add(p);
            }
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return indexedProps != null ? indexedProps : Collections.emptyList();
    }

    @Override
    public OProperty getProperty(String iPropertyName) {
        OClassImpl currentClass = this;
        OProperty p = null;
        do {
            if (currentClass.properties != null) {
                p = currentClass.properties.get(iPropertyName.toLowerCase());
            }
            if (p == null) continue;
            return p;
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return p;
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        return this.addProperty(iPropertyName, iType, null, null);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        if (iLinkedClass == null) {
            throw new OSchemaException("Missing linked class");
        }
        return this.addProperty(iPropertyName, iType, null, iLinkedClass);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null);
    }

    @Override
    public boolean existsProperty(String iPropertyName) {
        return this.properties.containsKey(iPropertyName.toLowerCase());
    }

    @Override
    public void dropProperty(String iPropertyName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        String lowerName = iPropertyName.toLowerCase();
        if (!this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
        }
        StringBuilder cmd = new StringBuilder("drop property ");
        cmd.append(this.name);
        cmd.append('.');
        cmd.append(iPropertyName);
        this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
        if (this.existsProperty(iPropertyName)) {
            this.properties.remove(lowerName);
        }
    }

    public void dropPropertyInternal(String iPropertyName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        OProperty prop = this.properties.remove(iPropertyName.toLowerCase());
        if (prop == null) {
            throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
        }
    }

    protected OProperty addProperty(String iPropertyName, OType iType, OType iLinkedType, OClass iLinkedClass) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot create a new property inside a transaction");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String lowerName = iPropertyName.toLowerCase();
        if (this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Class " + this.name + " already has property '" + iPropertyName + "'");
        }
        if (iType == null) {
            throw new OSchemaException("Property type not defined.");
        }
        StringBuilder cmd = new StringBuilder("create property ");
        cmd.append(this.name);
        cmd.append('.');
        cmd.append(iPropertyName);
        cmd.append(' ');
        cmd.append(iType.name);
        if (iLinkedType != null) {
            cmd.append(' ');
            cmd.append(iLinkedType.name);
        } else if (iLinkedClass != null) {
            cmd.append(' ');
            cmd.append(iLinkedClass.getName());
        }
        this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
        if (this.existsProperty(iPropertyName)) {
            return this.properties.get(lowerName);
        }
        return this.addPropertyInternal(iPropertyName, iType, iLinkedType, iLinkedClass);
    }

    @Override
    public void fromStream() {
        Object cc;
        this.name = (String)this.document.field("name");
        this.shortName = (String)this.document.field("shortName");
        this.defaultClusterId = (Integer)this.document.field("defaultClusterId");
        if (this.document.containsField("strictMode")) {
            this.strictMode = (Boolean)this.document.field("strictMode");
        }
        if (this.document.field("overSize") != null) {
            this.overSize = ((Float)this.document.field("overSize")).floatValue();
        }
        if ((cc = this.document.field("clusterIds")) instanceof Collection) {
            Collection coll = (Collection)this.document.field("clusterIds");
            this.clusterIds = new int[coll.size()];
            int i = 0;
            for (Integer item : coll) {
                this.clusterIds[i++] = item;
            }
        } else {
            this.clusterIds = (int[])cc;
        }
        Arrays.sort(this.clusterIds);
        this.setPolymorphicClusterIds(this.clusterIds);
        Collection storedProperties = (Collection)this.document.field("properties");
        if (storedProperties != null) {
            for (ODocument p : storedProperties) {
                OPropertyImpl prop = new OPropertyImpl(this, p);
                prop.fromStream();
                this.properties.put(prop.getName().toLowerCase(), prop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.name);
            if (this.shortName != null) {
                this.document.field("shortName", this.shortName);
            }
            this.document.field("defaultClusterId", this.defaultClusterId);
            this.document.field("clusterIds", this.clusterIds);
            this.document.field("overSize", Float.valueOf(this.overSize));
            this.document.field("strictMode", this.strictMode);
            if (this.properties != null) {
                HashSet<ODocument> props = new HashSet<ODocument>();
                for (OProperty p : this.properties.values()) {
                    props.add(((OPropertyImpl)p).toStream());
                }
                this.document.field("properties", props, OType.EMBEDDEDSET);
            }
            if (this.superClass != null) {
                this.document.field("superClass", this.superClass.getName());
            }
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int iDefaultClusterId) {
        this.defaultClusterId = iDefaultClusterId;
        this.setDirty();
    }

    @Override
    public int[] getClusterIds() {
        return this.clusterIds;
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        return this.polymorphicClusterIds;
    }

    @Override
    public OClass addClusterId(int iId) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s addcluster %d", this.name, iId);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.addClusterIdInternal(iId);
        return this;
    }

    public OClass addClusterIdInternal(int iId) {
        for (int currId : this.clusterIds) {
            if (currId != iId) continue;
            return this;
        }
        this.clusterIds = OArrays.copyOf(this.clusterIds, this.clusterIds.length + 1);
        this.clusterIds[this.clusterIds.length - 1] = iId;
        Arrays.sort(this.clusterIds);
        this.polymorphicClusterIds = OArrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length + 1);
        this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = iId;
        Arrays.sort(this.polymorphicClusterIds);
        this.setDirty();
        return this;
    }

    @Override
    public OClass removeClusterId(int iId) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s removecluster %d", this.name, iId);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.removeClusterIdInternal(iId);
        return this;
    }

    public OClass removeClusterIdInternal(int iId) {
        boolean found = false;
        for (int clusterId : this.clusterIds) {
            if (clusterId != iId) continue;
            found = true;
            break;
        }
        if (found) {
            int[] newClusterIds = new int[this.clusterIds.length - 1];
            int k = 0;
            for (int i = 0; i < this.clusterIds.length; ++i) {
                if (this.clusterIds[i] == iId) continue;
                newClusterIds[k] = this.clusterIds[i];
                ++k;
            }
            this.clusterIds = newClusterIds;
        }
        return this;
    }

    public OClass setDirty() {
        this.document.setDirty();
        if (this.owner != null) {
            this.owner.setDirty();
        }
        return this;
    }

    @Override
    public Iterator<OClass> getBaseClasses() {
        if (this.baseClasses == null || this.baseClasses.size() == 0) {
            return null;
        }
        return this.baseClasses.iterator();
    }

    private OClass addBaseClasses(OClass iBaseClass) {
        if (this.baseClasses == null) {
            this.baseClasses = new ArrayList<OClass>();
        }
        if (this.baseClasses.contains(iBaseClass)) {
            return this;
        }
        this.baseClasses.add(iBaseClass);
        for (OClassImpl currentClass = this; currentClass != null; currentClass = (OClassImpl)currentClass.getSuperClass()) {
            currentClass.addPolymorphicClusterIds((OClassImpl)iBaseClass);
        }
        return this;
    }

    public OClass removeBaseClassInternal(OClass baseClass) {
        if (this.baseClasses == null) {
            return this;
        }
        if (this.baseClasses.remove(baseClass)) {
            for (OClassImpl currentClass = this; currentClass != null; currentClass = (OClassImpl)currentClass.getSuperClass()) {
                currentClass.removePolymorphicClusterIds((OClassImpl)baseClass);
            }
        }
        return this;
    }

    private void removePolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int clusterId : iBaseClass.polymorphicClusterIds) {
            int index = Arrays.binarySearch(this.polymorphicClusterIds, clusterId);
            if (index == -1) continue;
            if (index < this.polymorphicClusterIds.length - 1) {
                System.arraycopy(this.polymorphicClusterIds, index + 1, this.polymorphicClusterIds, index, this.polymorphicClusterIds.length - (index + 1));
            }
            this.polymorphicClusterIds = Arrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length - 1);
        }
    }

    @Override
    public float getOverSize() {
        if (this.overSize > 0.0f) {
            return this.overSize;
        }
        if (this.superClass != null) {
            return this.superClass.getOverSize();
        }
        return 0.0f;
    }

    @Override
    public OClass setOverSize(float overSize) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s oversize %f", this.name, Float.valueOf(overSize));
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setOverSizeInternal(overSize);
        return this;
    }

    public void setOverSizeInternal(float overSize) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.overSize = overSize;
    }

    public float getOverSizeInternal() {
        return this.overSize;
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public OClass setStrictMode(boolean iStrict) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s strictmode %s", this.name, iStrict);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setStrictModeInternal(iStrict);
        return this;
    }

    public void setStrictModeInternal(boolean iStrict) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.strictMode = iStrict;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OClassImpl other = (OClassImpl)obj;
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    @Override
    public int compareTo(OClass o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public long count() {
        return this.count(true);
    }

    @Override
    public long count(boolean iPolymorphic) {
        if (iPolymorphic) {
            return this.getDatabase().countClusterElements(this.polymorphicClusterIds);
        }
        return this.getDatabase().countClusterElements(this.clusterIds);
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public void truncate() throws IOException {
        this.getDatabase().checkSecurity("database.class", ORole.PERMISSION_UPDATE);
        this.getDatabase().getStorage().callInLock(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (int id : OClassImpl.this.clusterIds) {
                    OClassImpl.this.getDatabase().getStorage().getClusterById(id).truncate();
                }
                for (OIndex<?> index : OClassImpl.this.getClassIndexes()) {
                    index.clear();
                }
                return null;
            }
        }, true);
    }

    @Override
    public boolean isSubClassOf(String iClassName) {
        return this.isSubClassOf(this.owner.getClass(iClassName));
    }

    @Override
    public boolean isSubClassOf(OClass iClass) {
        if (iClass == null) {
            return false;
        }
        for (OClass cls = this; cls != null; cls = cls.getSuperClass()) {
            if (!cls.getName().equals(iClass.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuperClassOf(OClass iClass) {
        for (OClass cls = iClass; cls != null; cls = cls.getSuperClass()) {
            if (!cls.getName().equals(this.name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
            case STRICTMODE: {
                return this.isStrictMode();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    public void setInternalAndSave(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        boolean isNull = stringValue != null && stringValue.equalsIgnoreCase("NULL");
        switch (attribute) {
            case NAME: {
                this.setNameInternal(stringValue);
                break;
            }
            case SHORTNAME: {
                this.setShortNameInternal(isNull ? null : stringValue);
                break;
            }
            case SUPERCLASS: {
                this.setSuperClassInternal(isNull ? null : this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case OVERSIZE: {
                this.setOverSizeInternal(Float.parseFloat(stringValue.replace(',', '.')));
                break;
            }
            case STRICTMODE: {
                this.setStrictModeInternal(Boolean.parseBoolean(stringValue));
                break;
            }
            case ADDCLUSTER: {
                int clId = this.getClusterId(stringValue);
                if (clId == -1) {
                    throw new IllegalArgumentException("Cluster id '" + stringValue + "' cannot be added");
                }
                this.addClusterIdInternal(clId);
                break;
            }
            case REMOVECLUSTER: {
                int clId = this.getClusterId(stringValue);
                if (clId == -1) {
                    throw new IllegalArgumentException("Cluster id '" + stringValue + "' cannot be removed");
                }
                this.removeClusterIdInternal(clId);
                break;
            }
        }
        this.saveInternal();
    }

    protected int getClusterId(String stringValue) {
        int clId;
        try {
            clId = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            clId = this.getDatabase().getClusterIdByName(stringValue);
        }
        return clId;
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case NAME: {
                this.setName(stringValue);
                break;
            }
            case SHORTNAME: {
                this.setShortName(stringValue);
                break;
            }
            case SUPERCLASS: {
                this.setSuperClass(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case OVERSIZE: {
                this.setOverSize(Float.parseFloat(stringValue));
                break;
            }
            case STRICTMODE: {
                this.setStrictMode(Boolean.parseBoolean(stringValue));
                break;
            }
            case ADDCLUSTER: {
                int clId = this.getClusterId(stringValue);
                if (clId == -1) {
                    throw new IllegalArgumentException("Cluster id '" + stringValue + "' cannot be added");
                }
                this.addClusterId(clId);
                break;
            }
            case REMOVECLUSTER: {
                int clId = this.getClusterId(stringValue);
                if (clId == -1) {
                    throw new IllegalArgumentException("Cluster id '" + stringValue + "' cannot be added");
                }
                this.removeClusterId(clId);
            }
        }
        return this;
    }

    private void addPolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int i : iBaseClass.polymorphicClusterIds) {
            boolean found = false;
            for (int k : this.polymorphicClusterIds) {
                if (i != k) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.polymorphicClusterIds = OArrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length + 1);
            this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = i;
            Arrays.sort(this.polymorphicClusterIds);
        }
    }

    public OPropertyImpl addPropertyInternal(String iName, OType iType, OType iLinkedType, OClass iLinkedClass) {
        if (iName == null || iName.length() == 0) {
            throw new OSchemaException("Found property name null");
        }
        Character wrongCharacter = OSchemaShared.checkNameIfValid(iName);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid property name found. Character '" + wrongCharacter + "' cannot be used in property name.");
        }
        String lowerName = iName.toLowerCase();
        if (this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Class " + this.name + " already has property '" + iName + "'");
        }
        OPropertyImpl prop = new OPropertyImpl(this, iName, iType);
        this.properties.put(lowerName, prop);
        if (iLinkedType != null) {
            prop.setLinkedTypeInternal(iLinkedType);
        } else if (iLinkedClass != null) {
            prop.setLinkedClassInternal(iLinkedClass);
        }
        return prop;
    }

    public void saveInternal() {
        this.owner.saveInternal();
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, String ... fields) {
        return this.createIndex(iName, iType.name(), fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, String ... fields) {
        return this.createIndex(iName, iType, (OProgressListener)null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, OProgressListener iProgressListener, String ... fields) {
        return this.createIndex(iName, iType.name(), iProgressListener, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, String ... fields) {
        try {
            OClass.INDEX_TYPE recognizedIdxType = OClass.INDEX_TYPE.valueOf(iType);
            if (!recognizedIdxType.isAutomaticIndexable()) {
                throw new IllegalArgumentException("Index type '" + iType + "' cannot be used as automatic index against properties");
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (fields.length == 0) {
            throw new OIndexException("List of fields to index cannot be empty.");
        }
        Set<String> existingFieldNames = this.properties.keySet();
        for (String fieldToIndex : fields) {
            String fieldName = OIndexDefinitionFactory.extractFieldName(fieldToIndex);
            if (existingFieldNames.contains(fieldName.toLowerCase())) continue;
            throw new OIndexException("Index with name : '" + iName + "' cannot be created on class : '" + this.name + "' because field: '" + fieldName + "' is absent in class definition.");
        }
        OIndexDefinition indexDefinition = OIndexDefinitionFactory.createIndexDefinition(this, Arrays.asList(fields), this.extractFieldTypes(fields));
        return this.getDatabase().getMetadata().getIndexManager().createIndex(iName, iType, indexDefinition, this.polymorphicClusterIds, iProgressListener);
    }

    private List<OType> extractFieldTypes(String[] fieldNames) {
        ArrayList<OType> types = new ArrayList<OType>(fieldNames.length);
        for (String fieldName : fieldNames) {
            types.add(this.properties.get(OIndexDefinitionFactory.extractFieldName(fieldName).toLowerCase()).getType());
        }
        return types;
    }

    @Override
    public boolean areIndexed(String ... fields) {
        return this.areIndexed(Arrays.asList(fields));
    }

    @Override
    public boolean areIndexed(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        boolean currentClassResult = indexManager.areIndexed(this.name, fields);
        if (this.superClass != null) {
            return currentClassResult || this.superClass.areIndexed(fields);
        }
        return currentClassResult;
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(String ... fields) {
        return this.getInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(Collection<String> fields) {
        HashSet result = new HashSet(this.getClassInvolvedIndexes(fields));
        if (this.superClass != null) {
            result.addAll(this.superClass.getInvolvedIndexes(fields));
        }
        return result;
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassInvolvedIndexes(this.name, fields);
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String ... fields) {
        return this.getClassInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public OIndex<?> getClassIndex(String iName) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassIndex(this.name, iName);
    }

    @Override
    public Set<OIndex<?>> getClassIndexes() {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassIndexes(this.name);
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        Set<OIndex<?>> indexes = this.getClassIndexes();
        if (this.superClass == null) {
            return indexes;
        }
        HashSet result = new HashSet(indexes);
        result.addAll(this.superClass.getIndexes());
        return result;
    }

    private void setPolymorphicClusterIds(int[] iClusterIds) {
        this.polymorphicClusterIds = iClusterIds;
        Arrays.sort(this.polymorphicClusterIds);
    }

    private OClass setClusterIds(int[] iClusterIds) {
        this.clusterIds = iClusterIds;
        Arrays.sort(this.clusterIds);
        return this;
    }
}

