/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityNull;
import com.orientechnologies.orient.core.metadata.security.OSecurityProxy;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import java.io.IOException;
import java.util.concurrent.Callable;

public class OMetadata {
    protected int schemaClusterId;
    protected OSchemaProxy schema;
    protected OSecurity security;
    protected OIndexManagerProxy indexManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        long timer = OProfiler.getInstance().startChrono();
        try {
            this.init(true);
            if (this.schemaClusterId == -1 || this.getDatabase().countClusterElements("internal") == 0L) {
                return;
            }
        }
        finally {
            OProfiler.getInstance().stopChrono("OMetadata.load", timer);
        }
    }

    public void create() throws IOException {
        this.init(false);
        this.security.create();
        this.schema.create();
        this.indexManager.create();
    }

    public OSchema getSchema() {
        return this.schema;
    }

    public OSecurity getSecurity() {
        return this.security;
    }

    public OIndexManagerProxy getIndexManager() {
        return this.indexManager;
    }

    public int getSchemaClusterId() {
        return this.schemaClusterId;
    }

    private void init(final boolean iLoad) {
        final ODatabaseRecord database = this.getDatabase();
        this.schemaClusterId = database.getClusterIdByName("internal");
        this.schema = new OSchemaProxy(database.getStorage().getResource(OSchema.class.getSimpleName(), new Callable<OSchemaShared>(){

            @Override
            public OSchemaShared call() {
                OSchemaShared instance = new OSchemaShared(OMetadata.this.schemaClusterId);
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), database);
        this.indexManager = new OIndexManagerProxy(database.getStorage().getResource(OIndexManager.class.getSimpleName(), new Callable<OIndexManager>(){

            @Override
            public OIndexManager call() {
                OIndexManagerAbstract instance = database.getStorage() instanceof OStorageProxy ? new OIndexManagerRemote(database) : new OIndexManagerShared(database);
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), database);
        Boolean enableSecurity = (Boolean)database.getProperty(ODatabase.OPTIONS.SECURITY.toString());
        this.security = enableSecurity != null && enableSecurity == false ? new OSecurityNull() : new OSecurityProxy(database.getStorage().getResource(OSecurity.class.getSimpleName(), new Callable<OSecurityShared>(){

            @Override
            public OSecurityShared call() {
                OSecurityShared instance = new OSecurityShared();
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), database);
    }

    public void reload() {
        this.schema.reload();
        this.indexManager.load();
        this.security.load();
    }

    public void close() {
        if (this.indexManager != null) {
            this.indexManager.flush();
        }
        if (this.schema != null) {
            this.schema.close();
        }
        if (this.security != null) {
            this.security.close();
        }
    }

    protected ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

