/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.memory;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMemoryWatchDog
extends Thread {
    private final Set<Listener> listeners = new HashSet<Listener>(128);
    private int alertTimes = 0;
    protected ReferenceQueue<Object> monitorQueue = new ReferenceQueue();
    protected SoftReference<Object> monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);

    public OMemoryWatchDog() {
        super(Orient.getThreadGroup(), "OrientDB MemoryWatchDog");
        OProfiler.getInstance().registerHookValue("system.memory.alerts", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMemoryWatchDog.this.alertTimes;
            }
        });
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object var14_10;
            try {
                try {
                    this.monitorQueue.remove();
                    ++this.alertTimes;
                    long maxMemory = Runtime.getRuntime().maxMemory();
                    long freeMemory = Runtime.getRuntime().freeMemory();
                    int freeMemoryPer = (int)(freeMemory * 100L / maxMemory);
                    if (OLogManager.instance().isDebugEnabled()) {
                        OLogManager.instance().debug((Object)this, "Free memory is low %s of %s (%d%%), calling listeners to free memory...", OFileUtils.getSizeAsString(freeMemory), OFileUtils.getSizeAsString(maxMemory), freeMemoryPer);
                    }
                    long timer = OProfiler.getInstance().startChrono();
                    Set<Listener> set = this.listeners;
                    synchronized (set) {
                        for (Listener listener : this.listeners) {
                            try {
                                listener.memoryUsageLow(freeMemory, freeMemoryPer);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    OProfiler.getInstance().stopChrono("OMemoryWatchDog.freeResources", timer);
                }
                catch (Exception exception) {
                    var14_10 = null;
                    this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
                    continue;
                }
                var14_10 = null;
                this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
            }
            catch (Throwable throwable) {
                var14_10 = null;
                this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Listener> getListeners() {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            return this.listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener addListener(Listener listener) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Listener listener) {
        Set<Listener> set = this.listeners;
        synchronized (set) {
            return this.listeners.remove(listener);
        }
    }

    public static void freeMemory(long iDelayTime) {
        System.gc();
        if (iDelayTime > 0L) {
            try {
                Thread.sleep(iDelayTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface Listener {
        public void memoryUsageLow(long var1, long var3);
    }
}

