/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordIteratorClusters<REC extends ORecordInternal<?>>
extends OIdentifiableIterator<REC> {
    protected int[] clusterIds;
    protected int currentClusterIdx;
    protected ORecord<?> currentRecord;
    protected ORID beginRange;
    protected ORID endRange;

    public ORecordIteratorClusters(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, int[] iClusterIds) {
        super(iDatabase, iLowLevelDatabase);
        this.clusterIds = iClusterIds;
        this.config();
    }

    protected ORecordIteratorClusters(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase) {
        super(iDatabase, iLowLevelDatabase);
    }

    public ORecordIteratorClusters<REC> setRange(ORID iBegin, ORID iEnd) {
        this.beginRange = iBegin;
        this.endRange = iEnd;
        this.updateClusterRange();
        this.current.clusterPosition = this.firstClusterPosition - 1L;
        return this;
    }

    @Override
    public boolean hasPrevious() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.firstClusterPosition = this.database.getStorage().getClusterDataRange(this.current.clusterId)[0];
        }
        ORecordInternal<?> record = this.getRecord();
        while (this.currentClusterIdx > -1) {
            while (this.current.clusterPosition > this.firstClusterPosition) {
                this.currentRecord = this.readCurrentRecord(record, -1);
                if (this.currentRecord == null || !this.include(this.currentRecord)) continue;
                return true;
            }
            --this.currentClusterIdx;
            this.updateClusterRange();
            this.current.clusterPosition = this.lastClusterPosition + 1L;
        }
        if (this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0) {
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        this.checkDirection(true);
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.lastClusterPosition = this.database.getStorage().getClusterDataRange(this.current.clusterId)[1];
        }
        ORecordInternal<?> record = this.getRecord();
        while (this.currentClusterIdx < this.clusterIds.length) {
            long recordsToBrowse;
            long l = recordsToBrowse = this.current.clusterPosition > -2L && this.lastClusterPosition > -1L ? this.lastClusterPosition - this.current.clusterPosition : 0L;
            while (recordsToBrowse > 0L) {
                this.currentRecord = this.readCurrentRecord(record, 1);
                if (this.currentRecord != null && this.include(this.currentRecord)) {
                    return true;
                }
                --recordsToBrowse;
            }
            ++this.currentClusterIdx;
            if (this.currentClusterIdx >= this.clusterIds.length) break;
            this.updateClusterRange();
            this.current.clusterPosition = this.firstClusterPosition - 1L;
        }
        if (this.txEntries != null && this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0) {
            return true;
        }
        this.currentRecord = null;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REC next() {
        this.checkDirection(true);
        if (this.currentRecord != null) {
            ORecordInternal oRecordInternal;
            try {
                oRecordInternal = (ORecordInternal)this.currentRecord;
                Object var3_3 = null;
                this.currentRecord = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.currentRecord = null;
                throw throwable;
            }
            return (REC)oRecordInternal;
        }
        ORecordInternal<?> record = this.getRecord();
        while (this.hasNext()) {
            if (this.currentRecord != null) {
                ORecordInternal oRecordInternal;
                try {
                    oRecordInternal = (ORecordInternal)this.currentRecord;
                    Object var5_7 = null;
                    this.currentRecord = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.currentRecord = null;
                    throw throwable;
                }
                return (REC)oRecordInternal;
            }
            record = this.getTransactionEntry();
            if (record == null) {
                record = this.readCurrentRecord(null, 1);
            }
            if (record == null || !this.include(record)) continue;
            return (REC)record;
        }
        record = this.getTransactionEntry();
        if (record != null) {
            return (REC)record;
        }
        throw new NoSuchElementException("Direction: forward, last position was: " + this.current + ", range: " + this.beginRange + "-" + this.endRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REC previous() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            ORecordInternal oRecordInternal;
            try {
                oRecordInternal = (ORecordInternal)this.currentRecord;
                Object var3_3 = null;
                this.currentRecord = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.currentRecord = null;
                throw throwable;
            }
            return (REC)oRecordInternal;
        }
        ORecordInternal<?> record = this.getRecord();
        while (this.hasPrevious()) {
            if (this.currentRecord != null) {
                ORecordInternal oRecordInternal;
                try {
                    oRecordInternal = (ORecordInternal)this.currentRecord;
                    Object var5_7 = null;
                    this.currentRecord = null;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.currentRecord = null;
                    throw throwable;
                }
                return (REC)oRecordInternal;
            }
            if (record == null) {
                record = this.readCurrentRecord(null, -1);
            }
            if (record == null || !this.include(record)) continue;
            return (REC)record;
        }
        record = this.getTransactionEntry();
        if (record != null) {
            return (REC)record;
        }
        throw new NoSuchElementException("Direction: backward, last position was: " + this.current + ", range: " + this.beginRange + "-" + this.endRange);
    }

    protected boolean include(ORecord<?> iRecord) {
        return true;
    }

    @Override
    public ORecordIteratorClusters<REC> begin() {
        this.currentClusterIdx = 0;
        this.current.clusterPosition = -1L;
        return this;
    }

    @Override
    public ORecordIteratorClusters<REC> last() {
        this.currentClusterIdx = this.clusterIds.length - 1;
        this.current.clusterPosition = this.liveUpdated ? this.database.countClusterElements(this.clusterIds[this.currentClusterIdx]) : this.lastClusterPosition + 1L;
        return this;
    }

    @Override
    public ORecordIteratorClusters<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        long l = this.lastClusterPosition = iLiveUpdated ? -1L : this.database.countClusterElements(this.current.clusterId);
        if (iLiveUpdated) {
            this.firstClusterPosition = -1L;
            this.lastClusterPosition = -1L;
        } else {
            this.updateClusterRange();
        }
        return this;
    }

    protected void updateClusterRange() {
        this.current.clusterId = this.clusterIds[this.currentClusterIdx];
        long[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
        this.firstClusterPosition = this.beginRange != null && this.beginRange.getClusterId() == this.current.clusterId ? this.beginRange.getClusterPosition() : range[0];
        this.lastClusterPosition = this.endRange != null && this.endRange.getClusterId() == this.current.clusterId ? this.endRange.getClusterPosition() : range[1];
    }

    protected void config() {
        this.currentClusterIdx = 0;
        this.updateClusterRange();
        this.current.clusterPosition = this.firstClusterPosition - 1L;
        this.totalAvailableRecords = this.database.countClusterElements(this.clusterIds);
        this.txEntries = this.database.getTransaction().getRecordEntriesByClusterIds(this.clusterIds);
        if (this.txEntries != null) {
            for (ORecordOperation entry : this.txEntries) {
                if (entry.getRecord().getIdentity().isTemporary() && entry.type != 2) {
                    ++this.totalAvailableRecords;
                    continue;
                }
                if (entry.type != 2) continue;
                --this.totalAvailableRecords;
            }
        }
    }

    public String toString() {
        return String.format("ORecordIteratorCluster.clusters(%s).currentRecord(%s).range(%s-%s)", Arrays.toString(this.clusterIds), this.currentRecord, this.beginRange, this.endRange);
    }
}

