/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OIndexes {
    private static Set<OIndexFactory> FACTORIES = null;
    private static ClassLoader orientClassLoader = OIndexes.class.getClassLoader();

    private OIndexes() {
    }

    private static synchronized Set<OIndexFactory> getFactories() {
        if (FACTORIES == null) {
            Iterator<OIndexFactory> ite = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OIndexFactory.class, orientClassLoader);
            HashSet<OIndexFactory> factories = new HashSet<OIndexFactory>();
            while (ite.hasNext()) {
                factories.add(ite.next());
            }
            FACTORIES = Collections.unmodifiableSet(factories);
        }
        return FACTORIES;
    }

    public static Iterator<OIndexFactory> getAllFactories() {
        return OIndexes.getFactories().iterator();
    }

    public static Set<String> getIndexTypes() {
        HashSet<String> types = new HashSet<String>();
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            types.addAll(ite.next().getTypes());
        }
        return types;
    }

    public static OIndexInternal<?> createIndex(ODatabaseRecord iDatabase, String iIndexType) throws OConfigurationException, OIndexException {
        Iterator<OIndexFactory> ite = OIndexes.getAllFactories();
        while (ite.hasNext()) {
            OIndexFactory factory = ite.next();
            if (!factory.getTypes().contains(iIndexType)) continue;
            return factory.createIndex(iDatabase, iIndexType);
        }
        throw new OIndexException("Index type : " + iIndexType + " is not supported. " + "Types are " + OCollections.toString(OIndexes.getIndexTypes()));
    }

    public static synchronized void scanForPlugins() {
        FACTORIES = null;
    }
}

