/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexTxAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexTxAwareMultiValue
extends OIndexTxAware<Collection<OIdentifiable>> {
    public OIndexTxAwareMultiValue(ODatabaseRecord iDatabase, OIndex<Collection<OIdentifiable>> iDelegate) {
        super(iDatabase, iDelegate);
    }

    @Override
    public Collection<OIdentifiable> get(Object iKey) {
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        TreeSet<OIdentifiable> result = indexChanges == null || !indexChanges.cleared ? new TreeSet((Collection)super.get(iKey)) : new TreeSet<OIdentifiable>();
        return this.filterIndexChanges(indexChanges, iKey, result);
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        ArrayList keys = new ArrayList(iKeys);
        TreeSet<OIdentifiable> result = new TreeSet<OIdentifiable>();
        TreeSet keysToRemove = new TreeSet();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            result.addAll(super.getValues(keys));
            return result;
        }
        for (Object key : keys) {
            TreeSet<OIdentifiable> keyResult;
            if (!indexChanges.cleared) {
                if (!indexChanges.containsChangesPerKey(key)) continue;
                keyResult = new TreeSet((Collection)super.get(key));
            } else {
                keyResult = new TreeSet<OIdentifiable>();
            }
            keysToRemove.add(key);
            this.filterIndexChanges(indexChanges, key, keyResult);
            result.addAll(keyResult);
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getValues(keys));
        }
        return result;
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        ArrayList keys = new ArrayList(iKeys);
        ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
        HashSet keysToRemove = new HashSet();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return super.getEntries(keys);
        }
        for (Object key : keys) {
            TreeSet<OIdentifiable> keyResult;
            if (!indexChanges.cleared) {
                if (!indexChanges.containsChangesPerKey(key)) continue;
                keyResult = new TreeSet((Collection)super.get(key));
            } else {
                keyResult = new TreeSet<OIdentifiable>();
            }
            keysToRemove.add(key);
            this.filterIndexChanges(indexChanges, key, keyResult);
            for (OIdentifiable id : keyResult) {
                ODocument document = new ODocument();
                document.field("key", key);
                document.field("rid", id.getIdentity());
                document.unsetDirty();
                result.add(document);
            }
        }
        keys.removeAll(keysToRemove);
        if (!keys.isEmpty()) {
            result.addAll(super.getEntries(keys));
        }
        return result;
    }

    protected Collection<OIdentifiable> filterIndexChanges(OTransactionIndexChanges indexChanges, Object key, Collection<OIdentifiable> keyResult) {
        OTransactionIndexChangesPerKey value;
        if (indexChanges == null) {
            return keyResult;
        }
        if (indexChanges.containsChangesPerKey(key) && (value = indexChanges.getChangesPerKey(key)) != null) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                    if (entry.value == null) {
                        keyResult.clear();
                        break;
                    }
                    keyResult.remove(entry.value);
                    continue;
                }
                if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                keyResult.add(entry.value);
            }
        }
        if (indexChanges.containsChangesCrossKey() && (value = indexChanges.getChangesCrossKey()) != null) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : value.entries) {
                if (entry.operation == OTransactionIndexChanges.OPERATION.REMOVE) {
                    if (entry.value == null) {
                        keyResult.clear();
                        break;
                    }
                    keyResult.remove(entry.value);
                    continue;
                }
                if (entry.operation != OTransactionIndexChanges.OPERATION.PUT) continue;
                keyResult.add(entry.value);
            }
        }
        return keyResult;
    }
}

