/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexRemote<T>
implements OIndex<T> {
    private final String wrappedType;
    private final ORID rid;
    protected OIndexDefinition indexDefinition;
    protected String name;
    protected ODocument configuration;
    protected Set<String> clustersToIndex;
    protected static final String QUERY_ENTRIES = "select key, rid from index:%s";
    private static final String QUERY_GET_MAJOR = "select from index:%s where key > ?";
    private static final String QUERY_GET_MAJOR_EQUALS = "select from index:%s where key >= ?";
    private static final String QUERY_GET_VALUE_MAJOR = "select FLATTEN( rid ) from index:%s where key > ?";
    private static final String QUERY_GET_VALUE_MAJOR_EQUALS = "select FLATTEN( rid ) from index:%s where key >= ?";
    private static final String QUERY_GET_MINOR = "select from index:%s where key < ?";
    private static final String QUERY_GET_MINOR_EQUALS = "select from index:%s where key <= ?";
    private static final String QUERY_GET_VALUE_MINOR = "select FLATTEN( rid ) from index:%s where key < ?";
    private static final String QUERY_GET_VALUE_MINOR_EQUALS = "select FLATTEN( rid ) from index:%s where key <= ?";
    private static final String QUERY_GET_RANGE = "select from index:%s where key between ? and ?";
    private static final String QUERY_GET_VALUES = "select FLATTEN( rid ) from index:%s where key in [%s]";
    private static final String QUERY_GET_ENTRIES = "select from index:%s where key in [%s]";
    private static final String QUERY_GET_VALUE_RANGE = "select FLATTEN( rid ) from index:%s where key between ? and ?";
    private static final String QUERY_PUT = "insert into index:%s (key,rid) values (?,?)";
    private static final String QUERY_REMOVE = "delete from index:%s where key = ?";
    private static final String QUERY_REMOVE2 = "delete from index:%s where key = ? and rid = ?";
    private static final String QUERY_REMOVE3 = "delete from index:%s where rid = ?";
    private static final String QUERY_CONTAINS = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_COUNT = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_SIZE = "select count(*) as size from index:%s";
    private static final String QUERY_KEY_SIZE = "select count(distinct( key )) as size from index:%s";
    private static final String QUERY_KEYS = "select key from index:%s";
    private static final String QUERY_REBUILD = "rebuild index %s";
    private static final String QUERY_CLEAR = "delete from index:%s";
    public static final String QUERY_GET_VALUES_BEETWEN_SELECT = "select from index:%s where ";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION = "key >= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION = "key > ?";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION = "key <= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION = "key < ?";
    public static final String QUERY_GET_VALUES_AND_OPERATOR = " and ";
    public static final String QUERY_GET_VALUES_LIMIT = " limit ";

    public OIndexRemote(String iName, String iWrappedType, ORID iRid, OIndexDefinition iIndexDefinition, ODocument iConfiguration, Set<String> clustersToIndex) {
        this.name = iName;
        this.wrappedType = iWrappedType;
        this.rid = iRid;
        this.indexDefinition = iIndexDefinition;
        this.configuration = iConfiguration;
        this.clustersToIndex = new HashSet<String>(clustersToIndex);
    }

    @Override
    public OIndexRemote<T> create(String iName, OIndexDefinition iIndexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        this.name = iName;
        return this;
    }

    @Override
    public OIndexRemote<T> delete() {
        return this;
    }

    public Set<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_RANGE, this.name);
        return (Set)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_VALUE_RANGE, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive) {
        StringBuilder query = new StringBuilder(QUERY_GET_VALUES_BEETWEN_SELECT);
        if (iFromInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION);
        }
        query.append(QUERY_GET_VALUES_AND_OPERATOR);
        if (iToInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION);
        }
        OCommandRequest cmd = this.formatCommand(query.toString(), new Object[0]);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo) {
        OCommandRequest cmd = this.formatCommand(QUERY_GET_RANGE, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_VALUE_MAJOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_VALUE_MAJOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_MAJOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_MAJOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_VALUE_MINOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_VALUE_MINOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        OCommandRequest cmd = isInclusive ? this.formatCommand(QUERY_GET_MINOR_EQUALS, this.name) : this.formatCommand(QUERY_GET_MINOR, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public boolean contains(Object iKey) {
        OCommandRequest cmd = this.formatCommand("select count(*) as size from index:%s where key = ?", this.name);
        List result = (List)this.getDatabase().command(cmd).execute(iKey);
        return (Long)((ODocument)result.get(0)).field("size") > 0L;
    }

    @Override
    public long count(Object iKey) {
        OCommandRequest cmd = this.formatCommand("select count(*) as size from index:%s where key = ?", this.name);
        List result = (List)this.getDatabase().command(cmd).execute(iKey);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public OIndexRemote<T> put(Object iKey, OIdentifiable iValue) {
        if (iValue instanceof ORecord && !iValue.getIdentity().isValid()) {
            ((ORecord)iValue).save();
        }
        OCommandRequest cmd = this.formatCommand(QUERY_PUT, this.name);
        this.getDatabase().command(cmd).execute(iKey, iValue.getIdentity());
        return this;
    }

    @Override
    public boolean remove(Object iKey) {
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE, this.name);
        return Boolean.parseBoolean((String)this.getDatabase().command(cmd).execute(iKey));
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        int deleted;
        if (iRID != null) {
            OCommandRequest cmd = this.formatCommand(QUERY_REMOVE2, this.name);
            deleted = (Integer)this.getDatabase().command(cmd).execute(iKey, iRID);
        } else {
            OCommandRequest cmd = this.formatCommand(QUERY_REMOVE, this.name);
            deleted = (Integer)this.getDatabase().command(cmd).execute(iKey);
        }
        return deleted > 0;
    }

    @Override
    public int remove(OIdentifiable iRecord) {
        OCommandRequest cmd = this.formatCommand(QUERY_REMOVE3, this.name, iRecord.getIdentity());
        return (Integer)this.getDatabase().command(cmd).execute(iRecord);
    }

    @Override
    public long rebuild() {
        OCommandRequest cmd = this.formatCommand(QUERY_REBUILD, this.name);
        return (Long)this.getDatabase().command(cmd).execute(new Object[0]);
    }

    @Override
    public OIndexRemote<T> clear() {
        OCommandRequest cmd = this.formatCommand(QUERY_CLEAR, this.name);
        this.getDatabase().command(cmd).execute(new Object[0]);
        return this;
    }

    @Override
    public Iterable<Object> keys() {
        OCommandRequest cmd = this.formatCommand(QUERY_KEYS, this.name);
        return (Iterable)this.getDatabase().command(cmd).execute(new Object[0]);
    }

    @Override
    public long getSize() {
        OCommandRequest cmd = this.formatCommand(QUERY_SIZE, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public long getKeySize() {
        OCommandRequest cmd = this.formatCommand(QUERY_KEY_SIZE, this.name);
        List result = (List)this.getDatabase().command(cmd).execute(new Object[0]);
        return (Long)((ODocument)result.get(0)).field("size");
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean isAutomatic() {
        return this.indexDefinition != null && this.indexDefinition.getClassName() != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OIndexRemote<T> lazySave() {
        return this;
    }

    @Override
    public String getType() {
        return this.wrappedType;
    }

    @Override
    public ODocument getConfiguration() {
        return this.configuration;
    }

    @Override
    public ORID getIdentity() {
        return this.rid;
    }

    protected OCommandRequest formatCommand(String iTemplate, Object ... iArgs) {
        String text = String.format(iTemplate, iArgs);
        return new OCommandSQL(text);
    }

    @Override
    public void commit(ODocument iDocument) {
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return null;
    }

    protected ODatabaseComplex<ORecordInternal<?>> getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        return this.rebuild();
    }

    @Override
    public OType[] getKeyTypes() {
        if (this.indexDefinition != null) {
            return this.indexDefinition.getTypes();
        }
        return null;
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand(QUERY_GET_VALUES, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand(QUERY_GET_ENTRIES, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexRemote that = (OIndexRemote)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValuesBetween(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive);
        }
        StringBuilder query = new StringBuilder(QUERY_GET_VALUES_BEETWEN_SELECT);
        if (iFromInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION);
        }
        query.append(QUERY_GET_VALUES_AND_OPERATOR);
        if (iToInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION);
        }
        query.append(QUERY_GET_VALUES_LIMIT).append(maxValuesToFetch);
        OCommandRequest cmd = this.formatCommand(query.toString(), new Object[0]);
        return (Collection)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValuesMajor(fromKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select FLATTEN( rid ) from index:%s where key >= ? limit " + maxValuesToFetch, this.name) : this.formatCommand("select FLATTEN( rid ) from index:%s where key > ? limit " + maxValuesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValuesMinor(toKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select FLATTEN( rid ) from index:%s where key <= ? limit " + maxValuesToFetch, this.name) : this.formatCommand("select FLATTEN( rid ) from index:%s where key < ? limit " + maxValuesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntriesMajor(fromKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select from index:%s where key >= ? limit " + maxEntriesToFetch, this.name) : this.formatCommand("select from index:%s where key > ? limit " + maxEntriesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(fromKey);
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntriesMinor(toKey, isInclusive);
        }
        OCommandRequest cmd = isInclusive ? this.formatCommand("select from index:%s where key <= ? limit " + maxEntriesToFetch, this.name) : this.formatCommand("select from index:%s where key < ? limit " + maxEntriesToFetch, this.name);
        return (Collection)this.getDatabase().command(cmd).execute(toKey);
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntriesBetween(iRangeFrom, iRangeTo, iInclusive);
        }
        OCommandRequest cmd = this.formatCommand("select from index:%s where key between ? and ? limit " + maxEntriesToFetch, this.name);
        return (Set)this.getDatabase().command(cmd).execute(iRangeFrom, iRangeTo);
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToFetch) {
        if (maxValuesToFetch < 0) {
            return this.getValues(iKeys);
        }
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand("select FLATTEN( rid ) from index:%s where key in [%s] limit " + maxValuesToFetch, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        if (maxEntriesToFetch < 0) {
            return this.getEntries(iKeys);
        }
        StringBuilder params = new StringBuilder();
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        OCommandRequest cmd = this.formatCommand("select from index:%s where key in [%s] limit " + maxEntriesToFetch, this.name, params.toString());
        return (Collection)this.getDatabase().command(cmd).execute(iKeys.toArray());
    }

    @Override
    public Set<String> getClusters() {
        return Collections.unmodifiableSet(this.clustersToIndex);
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
    }
}

