/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexOneValue
extends OIndexMVRBTreeAbstract<OIdentifiable> {
    public OIndexOneValue(String iType) {
        super(iType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIdentifiable get(Object iKey) {
        OIdentifiable oIdentifiable;
        this.acquireExclusiveLock();
        try {
            oIdentifiable = (OIdentifiable)this.map.get(iKey);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIdentifiable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Object iKey) {
        long l;
        this.acquireExclusiveLock();
        try {
            l = this.map.containsKey(iKey) ? 1L : 0L;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int remove(OIdentifiable iRecord) {
        this.modificationLock.requestModificationLock();
        try {
            int n;
            this.acquireExclusiveLock();
            try {
                int tot = 0;
                for (Map.Entry entries : this.map.entrySet()) {
                    if (!((OIdentifiable)entries.getValue()).equals(iRecord)) continue;
                    this.remove(entries.getKey(), iRecord);
                    ++tot;
                }
                n = tot;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            Object var8_8 = null;
            this.modificationLock.releaseModificationLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.modificationLock.releaseModificationLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                if (!((OIdentifiable)entries.getValue()).equals(iRecord)) continue;
                ++tot;
            }
            n = tot;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
        OIdentifiable indexedRID = this.get(iKey);
        if (indexedRID != null && !indexedRID.getIdentity().equals(iRecord.getIdentity())) {
            OTransactionIndexChangesPerKey keyChanges;
            OTransactionIndexChanges indexChanges = ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().getIndexChanges(this.getName());
            if (indexChanges != null && (keyChanges = indexChanges.getChangesPerKey(iKey)) != null) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry entry : keyChanges.entries) {
                    if (entry.operation != OTransactionIndexChanges.OPERATION.REMOVE) continue;
                    return;
                }
            }
            OLogManager.instance().exception("Found duplicated key '%s' previously assigned to the record %s", null, OIndexException.class, iKey, indexedRID);
        }
    }

    public OIndexOneValue create(String iName, OIndexDefinition iIndexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        return (OIndexOneValue)super.create(iName, iIndexDefinition, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, OStreamSerializerRID.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        OMVRBTreeEntry firstEntry;
        block5: {
            if (iRangeFrom.getClass() != iRangeTo.getClass()) {
                throw new IllegalArgumentException("Range from-to parameters are of different types");
            }
            this.acquireExclusiveLock();
            firstEntry = iFromInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
            if (firstEntry != null) break block5;
            Set<OIdentifiable> set = Collections.emptySet();
            Object var14_9 = null;
            this.releaseExclusiveLock();
            return set;
        }
        try {
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = iToInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (!(entry == null || entry == lastEntry && this.map.getPageIndex() == lastEntryIndex || maxValuesToFetch > -1 && result.size() == maxValuesToFetch)) {
                result.add((OIdentifiable)entry.getValue());
                entry = OMVRBTree.next(entry);
            }
            hashSet = result;
            Object var14_10 = null;
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        OMVRBTreeEntry firstEntry;
        block4: {
            this.acquireExclusiveLock();
            firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry != null) break block4;
            Set<OIdentifiable> set = Collections.emptySet();
            Object var9_7 = null;
            this.releaseExclusiveLock();
            return set;
        }
        try {
            OMVRBTreeEntry entry = firstEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null && (maxValuesToFetch <= -1 || result.size() != maxValuesToFetch)) {
                result.add((OIdentifiable)entry.getValue());
                entry = OMVRBTree.next(entry);
            }
            hashSet = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        OMVRBTreeEntry lastEntry;
        block4: {
            this.acquireExclusiveLock();
            lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry != null) break block4;
            Set<OIdentifiable> set = Collections.emptySet();
            Object var9_7 = null;
            this.releaseExclusiveLock();
            return set;
        }
        try {
            OMVRBTreeEntry entry = lastEntry;
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            while (entry != null && (maxValuesToFetch <= -1 || result.size() != maxValuesToFetch)) {
                result.add((OIdentifiable)entry.getValue());
                entry = OMVRBTree.previous(entry);
            }
            hashSet = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToSearch) {
        HashSet<OIdentifiable> hashSet;
        block5: {
            HashSet<OIdentifiable> hashSet2;
            block4: {
                ArrayList sortedKeys = new ArrayList(iKeys);
                Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
                this.acquireExclusiveLock();
                HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
                try {
                    for (Object key : sortedKeys) {
                        if (maxValuesToSearch > -1 && result.size() == maxValuesToSearch) {
                            hashSet2 = result;
                            Object var9_8 = null;
                            break block4;
                        }
                        OIdentifiable val = (OIdentifiable)this.map.get(key);
                        if (val == null) continue;
                        result.add(val);
                    }
                    hashSet = result;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return hashSet2;
        }
        Object var9_9 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        OMVRBTreeEntry firstEntry;
        block4: {
            this.acquireExclusiveLock();
            firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
            if (firstEntry != null) break block4;
            Set<ODocument> set = Collections.emptySet();
            Object var9_7 = null;
            this.releaseExclusiveLock();
            return set;
        }
        try {
            OMVRBTreeEntry entry = firstEntry;
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null && (maxEntriesToFetch <= -1 || result.size() != maxEntriesToFetch)) {
                ODocument document = new ODocument();
                document.field("key", entry.getKey());
                document.field("rid", ((OIdentifiable)entry.getValue()).getIdentity());
                document.unsetDirty();
                result.add(document);
                entry = OMVRBTree.next(entry);
            }
            oDocumentFieldsHashSet = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        OMVRBTreeEntry lastEntry;
        block4: {
            this.acquireExclusiveLock();
            lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
            if (lastEntry != null) break block4;
            Set<ODocument> set = Collections.emptySet();
            Object var9_7 = null;
            this.releaseExclusiveLock();
            return set;
        }
        try {
            OMVRBTreeEntry entry = lastEntry;
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (entry != null && (maxEntriesToFetch <= -1 || result.size() != maxEntriesToFetch)) {
                ODocument document = new ODocument();
                document.field("key", entry.getKey());
                document.field("rid", ((OIdentifiable)entry.getValue()).getIdentity());
                document.unsetDirty();
                result.add(document);
                entry = OMVRBTree.previous(entry);
            }
            oDocumentFieldsHashSet = result;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        OMVRBTreeEntry firstEntry;
        block5: {
            if (iRangeFrom.getClass() != iRangeTo.getClass()) {
                throw new IllegalArgumentException("Range from-to parameters are of different types");
            }
            this.acquireExclusiveLock();
            firstEntry = iInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
            if (firstEntry != null) break block5;
            Set<ODocument> set = Collections.emptySet();
            Object var13_8 = null;
            this.releaseExclusiveLock();
            return set;
        }
        try {
            int firstEntryIndex = this.map.getPageIndex();
            OMVRBTreeEntry lastEntry = iInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
            int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
            OMVRBTreeEntry entry = firstEntry;
            this.map.setPageIndex(firstEntryIndex);
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            while (!(entry == null || entry == lastEntry && this.map.getPageIndex() == lastEntryIndex || maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch)) {
                ODocument document = new ODocument();
                document.field("key", entry.getKey());
                document.field("rid", ((OIdentifiable)entry.getValue()).getIdentity());
                document.unsetDirty();
                result.add(document);
                entry = OMVRBTree.next(entry);
            }
            oDocumentFieldsHashSet = result;
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        block5: {
            ODocumentFieldsHashSet oDocumentFieldsHashSet2;
            block4: {
                ArrayList sortedKeys = new ArrayList(iKeys);
                Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
                this.acquireExclusiveLock();
                ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
                try {
                    for (Object key : sortedKeys) {
                        if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                            oDocumentFieldsHashSet2 = result;
                            Object var10_9 = null;
                            break block4;
                        }
                        OIdentifiable val = (OIdentifiable)this.map.get(key);
                        if (val == null) continue;
                        ODocument document = new ODocument();
                        document.field("key", key);
                        document.field("rid", val.getIdentity());
                        document.unsetDirty();
                        result.add(document);
                    }
                    oDocumentFieldsHashSet = result;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return oDocumentFieldsHashSet2;
        }
        Object var10_10 = null;
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.map.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getKeySize() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.map.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }
}

