/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.ODocumentFieldsHashSet;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OIndexMultiValues
extends OIndexMVRBTreeAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String iType) {
        super(iType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object iKey) {
        OMVRBTreeRIDSet values;
        block3: {
            Set<OIdentifiable> set;
            this.acquireExclusiveLock();
            try {
                values = (OMVRBTreeRIDSet)this.map.get(iKey);
                if (values != null) break block3;
                set = Collections.emptySet();
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return set;
        }
        HashSet<OIdentifiable> hashSet = new HashSet<OIdentifiable>(values);
        Object var5_6 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(Object iKey) {
        OMVRBTreeRIDSet values;
        block3: {
            long l;
            this.acquireExclusiveLock();
            try {
                values = (OMVRBTreeRIDSet)this.map.get(iKey);
                if (values != null) break block3;
                l = 0L;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return l;
        }
        long l = values.size();
        Object var6_6 = null;
        this.releaseExclusiveLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OIndexMultiValues put(Object iKey, OIdentifiable iSingleValue) {
        this.modificationLock.requestModificationLock();
        try {
            OIndexMultiValues oIndexMultiValues;
            this.acquireExclusiveLock();
            try {
                this.checkForKeyType(iKey);
                Set values = (Set)this.map.get(iKey);
                if (values == null) {
                    values = new OMVRBTreeRIDSet().setAutoConvert(false);
                }
                if (!iSingleValue.getIdentity().isValid()) {
                    ((ORecord)iSingleValue).save();
                }
                values.add(iSingleValue.getIdentity());
                this.map.put(iKey, values);
                oIndexMultiValues = this;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            Object var8_7 = null;
            this.modificationLock.releaseModificationLock();
            return oIndexMultiValues;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.modificationLock.releaseModificationLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object iKey, OIdentifiable iValue) {
        this.modificationLock.requestModificationLock();
        try {
            block9: {
                Set recs;
                block8: {
                    boolean bl;
                    this.acquireExclusiveLock();
                    try {
                        recs = (Set)this.map.get(iKey);
                        if (recs != null) break block8;
                        bl = false;
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        this.releaseExclusiveLock();
                        throw throwable;
                    }
                    this.releaseExclusiveLock();
                    Object var8_11 = null;
                    this.modificationLock.releaseModificationLock();
                    return bl;
                }
                if (!recs.remove(iValue)) break block9;
                if (recs.isEmpty()) {
                    this.map.remove(iKey);
                } else {
                    this.map.put(iKey, recs);
                }
                boolean bl = true;
                Object var6_8 = null;
                this.releaseExclusiveLock();
                Object var8_12 = null;
                this.modificationLock.releaseModificationLock();
                return bl;
            }
            boolean bl = false;
            Object var6_9 = null;
            this.releaseExclusiveLock();
            Object var8_13 = null;
            this.modificationLock.releaseModificationLock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.modificationLock.releaseModificationLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                this.remove(entries.getKey(), iRecord);
                ++tot;
            }
            n = tot;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(OIdentifiable iRecord) {
        int n;
        this.acquireExclusiveLock();
        try {
            int tot = 0;
            for (Map.Entry entries : this.map.entrySet()) {
                Set rids = (Set)entries.getValue();
                if (rids == null || !rids.contains(iRecord)) continue;
                ++tot;
            }
            n = tot;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return n;
    }

    public OIndexMultiValues create(String iName, OIndexDefinition indexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        return (OIndexMultiValues)super.create(iName, indexDefinition, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, OStreamSerializerListRID.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        block7: {
            Set<OIdentifiable> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = iFromInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var17_9 = null;
                        break block6;
                    }
                    int firstEntryIndex = this.map.getPageIndex();
                    OMVRBTreeEntry lastEntry = iToInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
                    int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
                    OMVRBTreeEntry entry = firstEntry;
                    this.map.setPageIndex(firstEntryIndex);
                    HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
                    while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxValuesToFetch > -1 && maxValuesToFetch == result.size()) {
                                HashSet<OIdentifiable> hashSet2 = result;
                                Object var17_10 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            result.add(value);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var17_12 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var17_11 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        block7: {
            Set<OIdentifiable> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var12_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = firstEntry;
                    HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
                    while (entry != null) {
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                                HashSet<OIdentifiable> hashSet2 = result;
                                Object var12_8 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            result.add(value);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var12_9 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        block7: {
            Set<OIdentifiable> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
                    if (lastEntry == null) {
                        set = Collections.emptySet();
                        Object var12_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = lastEntry;
                    HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
                    while (entry != null) {
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxValuesToFetch > -1 && result.size() == maxValuesToFetch) {
                                HashSet<OIdentifiable> hashSet2 = result;
                                Object var12_8 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            result.add(value);
                        }
                        entry = OMVRBTree.previous(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var12_9 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToFetch) {
        HashSet<OIdentifiable> hashSet;
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        this.acquireExclusiveLock();
        try {
            HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.map.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxValuesToFetch > -1 && maxValuesToFetch == result.size()) {
                        HashSet<OIdentifiable> hashSet2 = result;
                        Object var12_11 = null;
                        this.releaseExclusiveLock();
                        return hashSet2;
                    }
                    result.add(value);
                }
            }
            hashSet = result;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        Object var12_12 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        HashSet<ODocument> hashSet;
        block7: {
            Set<ODocument> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = isInclusive ? this.map.getCeilingEntry(fromKey, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(fromKey);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var13_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = firstEntry;
                    HashSet<ODocument> result = new HashSet<ODocument>();
                    while (entry != null) {
                        Object key = entry.getKey();
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                                HashSet<ODocument> hashSet2 = result;
                                Object var13_8 = null;
                                this.releaseExclusiveLock();
                                return hashSet2;
                            }
                            ODocument document = new ODocument();
                            document.field("key", key);
                            document.field("rid", value.getIdentity());
                            document.unsetDirty();
                            result.add(document);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    hashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var13_9 = null;
        this.releaseExclusiveLock();
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        block7: {
            Set<ODocument> set;
            block6: {
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry lastEntry = isInclusive ? this.map.getFloorEntry(toKey, OMVRBTree.PartialSearchMode.HIGHEST_BOUNDARY) : this.map.getLowerEntry(toKey);
                    if (lastEntry == null) {
                        set = Collections.emptySet();
                        Object var13_7 = null;
                        break block6;
                    }
                    OMVRBTreeEntry entry = lastEntry;
                    ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
                    while (entry != null) {
                        Object key = entry.getKey();
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxEntriesToFetch > -1 && result.size() == maxEntriesToFetch) {
                                ODocumentFieldsHashSet oDocumentFieldsHashSet2 = result;
                                Object var13_8 = null;
                                this.releaseExclusiveLock();
                                return oDocumentFieldsHashSet2;
                            }
                            ODocument document = new ODocument();
                            document.field("key", key);
                            document.field("rid", value.getIdentity());
                            document.unsetDirty();
                            result.add(document);
                        }
                        entry = OMVRBTree.previous(entry);
                    }
                    oDocumentFieldsHashSet = result;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var13_9 = null;
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        block8: {
            Set<ODocument> set;
            block7: {
                OType[] types = this.getDefinition().getTypes();
                if (types.length == 1) {
                    iRangeFrom = OType.convert(iRangeFrom, types[0].getDefaultJavaType());
                    iRangeTo = OType.convert(iRangeTo, types[0].getDefaultJavaType());
                }
                this.acquireExclusiveLock();
                try {
                    OMVRBTreeEntry firstEntry = iInclusive ? this.map.getCeilingEntry(iRangeFrom, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY) : this.map.getHigherEntry(iRangeFrom);
                    if (firstEntry == null) {
                        set = Collections.emptySet();
                        Object var18_9 = null;
                        break block7;
                    }
                    int firstEntryIndex = this.map.getPageIndex();
                    OMVRBTreeEntry lastEntry = iInclusive ? this.map.getHigherEntry(iRangeTo) : this.map.getCeilingEntry(iRangeTo, OMVRBTree.PartialSearchMode.LOWEST_BOUNDARY);
                    int lastEntryIndex = lastEntry != null ? this.map.getPageIndex() : -1;
                    OMVRBTreeEntry entry = firstEntry;
                    this.map.setPageIndex(firstEntryIndex);
                    ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
                    while (entry != null && (entry != lastEntry || this.map.getPageIndex() != lastEntryIndex)) {
                        Object key = entry.getKey();
                        OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)entry.getValue();
                        if (values.isEmpty()) continue;
                        for (OIdentifiable value : values) {
                            if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                                ODocumentFieldsHashSet oDocumentFieldsHashSet2 = result;
                                Object var18_10 = null;
                                this.releaseExclusiveLock();
                                return oDocumentFieldsHashSet2;
                            }
                            ODocument document = new ODocument();
                            document.field("key", key);
                            document.field("rid", value.getIdentity());
                            document.unsetDirty();
                            result.add(document);
                        }
                        entry = OMVRBTree.next(entry);
                    }
                    oDocumentFieldsHashSet = result;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var18_12 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return set;
        }
        Object var18_11 = null;
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        ODocumentFieldsHashSet oDocumentFieldsHashSet;
        ArrayList sortedKeys = new ArrayList(iKeys);
        Collections.sort(sortedKeys, ODefaultComparator.INSTANCE);
        this.acquireExclusiveLock();
        try {
            ODocumentFieldsHashSet result = new ODocumentFieldsHashSet();
            for (Object key : sortedKeys) {
                OMVRBTreeRIDSet values = (OMVRBTreeRIDSet)this.map.get(key);
                if (values == null || values.isEmpty()) continue;
                for (OIdentifiable value : values) {
                    if (maxEntriesToFetch > -1 && maxEntriesToFetch == result.size()) {
                        ODocumentFieldsHashSet oDocumentFieldsHashSet2 = result;
                        Object var12_11 = null;
                        this.releaseExclusiveLock();
                        return oDocumentFieldsHashSet2;
                    }
                    ODocument document = new ODocument();
                    document.field("key", key);
                    document.field("rid", value.getIdentity());
                    document.unsetDirty();
                    result.add(document);
                }
            }
            oDocumentFieldsHashSet = result;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        Object var12_12 = null;
        this.releaseExclusiveLock();
        return oDocumentFieldsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        long l;
        if (this.map.size() == 0) {
            return 0L;
        }
        this.acquireExclusiveLock();
        try {
            OMVRBTreeEntry rootEntry = this.map.getRoot();
            long size = 0L;
            OMVRBTreeEntry currentEntry = rootEntry;
            this.map.setPageIndex(0);
            while (currentEntry != null) {
                size += (long)((Set)currentEntry.getValue()).size();
                currentEntry = OMVRBTree.next(currentEntry);
            }
            this.map.setPageIndex(0);
            currentEntry = OMVRBTree.previous(rootEntry);
            while (currentEntry != null) {
                size += (long)((Set)currentEntry.getValue()).size();
                currentEntry = OMVRBTree.previous(currentEntry);
            }
            l = size;
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getKeySize() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.map.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }
}

