/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMultiKey;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexManagerShared
extends OIndexManagerAbstract
implements OIndexManager {
    public OIndexManagerShared(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndex<?> getIndexInternal(String iName) {
        OIndex<?> oIndex;
        this.acquireSharedLock();
        try {
            OIndex index = (OIndex)this.indexes.get(iName.toLowerCase());
            oIndex = this.getIndexInstance(index);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return oIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        OIndex<?> oIndex;
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot create a new index inside a transaction");
        }
        Character c = OSchemaShared.checkNameIfValid(iName);
        if (c != null) {
            throw new IllegalArgumentException("Invalid index name '" + iName + "'. Character '" + c + "' is invalid");
        }
        this.acquireExclusiveLock();
        try {
            OIndexInternal<?> index = OIndexes.createIndex(this.getDatabase(), iType);
            index.create(iName, indexDefinition, this.getDatabase(), this.defaultClusterName, iClusterIdsToIndex, iProgressListener);
            this.addIndexInternal(index);
            this.setDirty();
            this.save();
            oIndex = this.getIndexInstance(index);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexManager dropIndex(String iIndexName) {
        OIndexManagerShared oIndexManagerShared;
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop an index inside a transaction");
        }
        this.acquireExclusiveLock();
        try {
            OIndex idx = (OIndex)this.indexes.remove(iIndexName.toLowerCase());
            if (idx != null) {
                this.removeClassPropertyIndex(idx);
                idx.delete();
                this.setDirty();
                this.save();
            }
            oIndexManagerShared = this;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oIndexManagerShared;
    }

    private void removeClassPropertyIndex(OIndex<?> idx) {
        OIndexDefinition indexDefinition = idx.getDefinition();
        if (indexDefinition == null || indexDefinition.getClassName() == null) {
            return;
        }
        Map map = (Map)this.classPropertyIndex.get(indexDefinition.getClassName().toLowerCase());
        if (map == null) {
            return;
        }
        int paramCount = indexDefinition.getParamCount();
        for (int i = 1; i <= paramCount; ++i) {
            List<String> fields = this.normalizeFieldNames(indexDefinition.getFields().subList(0, i));
            OMultiKey multiKey = new OMultiKey(fields);
            Set indexSet = (Set)map.get(multiKey);
            if (indexSet == null) continue;
            indexSet.remove(idx);
            if (!indexSet.isEmpty()) continue;
            map.remove(multiKey);
        }
        if (map.isEmpty()) {
            this.classPropertyIndex.remove(indexDefinition.getClassName().toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            Collection idxs = (Collection)this.document.field("indexes");
            if (idxs != null) {
                for (ODocument d : idxs) {
                    try {
                        OIndexInternal<?> index = OIndexes.createIndex(this.getDatabase(), (String)d.field("type"));
                        index.loadFromConfiguration(d);
                        this.addIndexInternal(index);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on loading index by configuration: %s", (Throwable)e, d);
                    }
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        ODocument oDocument;
        this.acquireExclusiveLock();
        try {
            this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            try {
                ORecordTrackedSet idxs = new ORecordTrackedSet(this.document);
                for (OIndexInternal i : this.indexes.values()) {
                    idxs.add(i.updateConfiguration());
                }
                this.document.field("indexes", idxs, OType.EMBEDDEDSET);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
                throw throwable;
            }
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            this.document.setDirty();
            oDocument = this.document;
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oDocument;
    }

    @Override
    protected OIndex<?> getIndexInstance(OIndex<?> iIndex) {
        return iIndex;
    }
}

