/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexFullText
extends OIndexMultiValues {
    public static final String TYPE_ID = OClass.INDEX_TYPE.FULLTEXT.toString();
    private static final String CONFIG_STOP_WORDS = "stopWords";
    private static final String CONFIG_IGNORE_CHARS = "ignoreChars";
    private static String DEF_IGNORE_CHARS = " \r\n\t:;,.|+*/\\=!?[]()'\"";
    private static String DEF_STOP_WORDS = "the in a at as and or for his her him this that what which while up with be was is";
    private final String ignoreChars = DEF_IGNORE_CHARS;
    private final Set<String> stopWords = new HashSet<String>(OStringSerializerHelper.split(DEF_STOP_WORDS, ' ', new char[0]));

    public OIndexFullText() {
        super(TYPE_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexDocument(ODocument iDocument) {
        this.modificationLock.requestModificationLock();
        try {
            for (String fieldName : iDocument.fieldNames()) {
                Object fieldValue = iDocument.field(fieldName);
                this.put(fieldValue, iDocument);
            }
            this.acquireExclusiveLock();
            try {
                this.map.save();
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            Object var10_10 = null;
            this.modificationLock.releaseModificationLock();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.modificationLock.releaseModificationLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexFullText put(Object iKey, OIdentifiable iSingleValue) {
        if (iKey == null) {
            return this;
        }
        this.modificationLock.requestModificationLock();
        try {
            List<String> words = this.splitIntoWords(iKey.toString());
            for (String word : words) {
                Object var8_7;
                this.acquireExclusiveLock();
                try {
                    Set refs = (Set)this.map.get(word);
                    if (refs == null) {
                        refs = new OMVRBTreeRIDSet().setAutoConvert(false);
                    }
                    refs.add(iSingleValue);
                    this.map.put(word, refs);
                    var8_7 = null;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
                this.releaseExclusiveLock();
                {
                }
            }
            OIndexFullText oIndexFullText = this;
            Object var10_9 = null;
            this.modificationLock.releaseModificationLock();
            return oIndexFullText;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.modificationLock.releaseModificationLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object iKey, OIdentifiable value) {
        this.modificationLock.requestModificationLock();
        try {
            List<String> words = this.splitIntoWords(iKey.toString());
            boolean removed = false;
            for (String word : words) {
                Object var9_9;
                this.acquireExclusiveLock();
                try {
                    Set recs = (Set)this.map.get(word);
                    if (recs != null && !recs.isEmpty() && recs.remove(value)) {
                        if (recs.isEmpty()) {
                            this.map.remove(word);
                        } else {
                            this.map.put(word, recs);
                        }
                        removed = true;
                    }
                    var9_9 = null;
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
                this.releaseExclusiveLock();
                {
                }
            }
            boolean bl = removed;
            Object var11_11 = null;
            this.modificationLock.releaseModificationLock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.modificationLock.releaseModificationLock();
            throw throwable;
        }
    }

    @Override
    public OIndexInternal<?> create(String iName, OIndexDefinition iIndexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener, OStreamSerializer iValueSerializer) {
        if (iIndexDefinition.getFields().size() > 1) {
            throw new OIndexException(TYPE_ID + " indexes cannot be used as composite ones.");
        }
        return super.create(iName, iIndexDefinition, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener, iValueSerializer);
    }

    @Override
    public OIndexMultiValues create(String iName, OIndexDefinition indexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        if (indexDefinition.getFields().size() > 1) {
            throw new OIndexException(TYPE_ID + " indexes cannot be used as composite ones.");
        }
        return super.create(iName, indexDefinition, iDatabase, iClusterIndexName, iClusterIdsToIndex, iProgressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument updateConfiguration() {
        super.updateConfiguration();
        this.configuration.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.configuration.field(CONFIG_IGNORE_CHARS, this.ignoreChars);
            this.configuration.field(CONFIG_STOP_WORDS, this.stopWords);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        this.configuration.setInternalStatus(ORecordElement.STATUS.LOADED);
        return this.configuration;
    }

    private List<String> splitIntoWords(String iKey) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> words = OStringSerializerHelper.split(iKey, ' ', new char[0]);
        StringBuilder buffer = new StringBuilder();
        for (String word : words) {
            buffer.setLength(0);
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                boolean ignore = false;
                for (int k = 0; k < this.ignoreChars.length(); ++k) {
                    if (c != this.ignoreChars.charAt(k)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                buffer.append(c);
            }
            word = buffer.toString();
            if (this.stopWords.contains(word)) continue;
            result.add(word);
        }
        return result;
    }

    @Override
    public boolean canBeUsedInEqualityOperators() {
        return false;
    }
}

