/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyListIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexDefinitionFactory {
    private static final Pattern FILED_NAME_PATTERN = Pattern.compile("\\s+");

    public static OIndexDefinition createIndexDefinition(OClass oClass, List<String> fieldNames, List<OType> types) {
        OIndexDefinitionFactory.checkTypes(oClass, fieldNames, types);
        if (fieldNames.size() == 1) {
            return OIndexDefinitionFactory.createSingleFieldIndexDefinition(oClass, fieldNames.get(0), types.get(0));
        }
        return OIndexDefinitionFactory.createMultipleFieldIndexDefinition(oClass, fieldNames, types);
    }

    public static String extractFieldName(String fieldDefinition) {
        String[] fieldNameParts = FILED_NAME_PATTERN.split(fieldDefinition);
        if (fieldNameParts.length == 1) {
            return fieldDefinition;
        }
        if (fieldNameParts.length == 3 && "by".equalsIgnoreCase(fieldNameParts[1])) {
            return fieldNameParts[0];
        }
        throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldDefinition + '\'');
    }

    private static OIndexDefinition createMultipleFieldIndexDefinition(OClass oClass, List<String> fieldsToIndex, List<OType> types) {
        String className = oClass.getName();
        OCompositeIndexDefinition compositeIndex = new OCompositeIndexDefinition(className);
        int fieldsToIndexSize = fieldsToIndex.size();
        for (int i = 0; i < fieldsToIndexSize; ++i) {
            compositeIndex.addIndex(OIndexDefinitionFactory.createSingleFieldIndexDefinition(oClass, fieldsToIndex.get(i), types.get(i)));
        }
        return compositeIndex;
    }

    private static void checkTypes(OClass oClass, List<String> fieldNames, List<OType> types) {
        if (fieldNames.size() != types.size()) {
            throw new IllegalArgumentException("Count of field names doesn't match count of field types. It was " + fieldNames.size() + " fields, but " + types.size() + " types.");
        }
        int fieldNamesSize = fieldNames.size();
        for (int i = 0; i < fieldNamesSize; ++i) {
            String fieldName = fieldNames.get(i);
            OType type = types.get(i);
            OProperty property = oClass.getProperty(fieldName);
            if (property == null || type.equals((Object)property.getType())) continue;
            throw new IllegalArgumentException("Property type list not match with real property types");
        }
    }

    private static OIndexDefinition createSingleFieldIndexDefinition(OClass oClass, String field, OType type) {
        OPropertyIndexDefinition indexDefinition;
        String fieldName = OIndexDefinitionFactory.adjustFieldName(oClass, OIndexDefinitionFactory.extractFieldName(field));
        if (type == OType.EMBEDDEDMAP || type == OType.LINKMAP) {
            OType indexType;
            OPropertyMapIndexDefinition.INDEX_BY indexBy = OIndexDefinitionFactory.extractMapIndexSpecifier(field);
            if (indexBy.equals((Object)OPropertyMapIndexDefinition.INDEX_BY.KEY)) {
                indexType = OType.STRING;
            } else if (type == OType.LINKMAP) {
                indexType = OType.LINK;
            } else {
                OProperty propertyToIndex = oClass.getProperty(fieldName);
                indexType = propertyToIndex.getLinkedType();
                if (indexType == null) {
                    throw new OIndexException("Linked type was not provided. You should provide linked type for embedded collections that are going to be indexed.");
                }
            }
            indexDefinition = new OPropertyMapIndexDefinition(oClass.getName(), fieldName, indexType, indexBy);
        } else if (type.equals((Object)OType.EMBEDDEDLIST) || type.equals((Object)OType.EMBEDDEDSET) || type.equals((Object)OType.LINKLIST) || type.equals((Object)OType.LINKSET)) {
            OType indexType;
            if (type.equals((Object)OType.LINKSET)) {
                throw new OIndexException("LINKSET indexing is not supported.");
            }
            if (type.equals((Object)OType.LINKLIST)) {
                indexType = OType.LINK;
            } else {
                OProperty propertyToIndex = oClass.getProperty(fieldName);
                indexType = propertyToIndex.getLinkedType();
                if (indexType == null) {
                    throw new OIndexException("Linked type was not provided. You should provide linked type for embedded collections that are going to be indexed.");
                }
            }
            indexDefinition = new OPropertyListIndexDefinition(oClass.getName(), fieldName, indexType);
        } else {
            indexDefinition = new OPropertyIndexDefinition(oClass.getName(), fieldName, type);
        }
        return indexDefinition;
    }

    private static OPropertyMapIndexDefinition.INDEX_BY extractMapIndexSpecifier(String fieldName) {
        String[] fieldNameParts = FILED_NAME_PATTERN.split(fieldName);
        if (fieldNameParts.length == 1) {
            return OPropertyMapIndexDefinition.INDEX_BY.KEY;
        }
        if (fieldNameParts.length == 3 && "by".equals(fieldNameParts[1].toLowerCase())) {
            try {
                return OPropertyMapIndexDefinition.INDEX_BY.valueOf(fieldNameParts[2].toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + '\'');
            }
        }
        throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + '\'');
    }

    private static String adjustFieldName(OClass clazz, String fieldName) {
        OProperty property = clazz.getProperty(fieldName);
        if (property != null) {
            return property.getName();
        }
        return fieldName;
    }
}

