/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OClassIndexManager
extends ODocumentHookAbstract {
    @Override
    public boolean onRecordBeforeCreate(ODocument iRecord) {
        iRecord = OClassIndexManager.checkForLoading(iRecord);
        OClassIndexManager.checkIndexedPropertiesOnCreation(iRecord);
        OClassIndexManager.acquireModificationLock(iRecord);
        return false;
    }

    @Override
    public void onRecordAfterCreate(ODocument iRecord) {
        ORecord<Object> rid = (iRecord = OClassIndexManager.checkForLoading(iRecord)).getIdentity().isPersistent() ? iRecord.placeholder() : iRecord;
        OClass cls = iRecord.getSchemaClass();
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.put(keyItem, rid);
                    }
                    continue;
                }
                if (key == null) continue;
                oIndex.put(key, rid);
            }
            OClassIndexManager.releaseModificationLock(iRecord);
        }
    }

    @Override
    public void onRecordCreateFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public boolean onRecordBeforeUpdate(ODocument iRecord) {
        iRecord = OClassIndexManager.checkForLoading(iRecord);
        OClassIndexManager.checkIndexedPropertiesOnUpdate(iRecord);
        OClassIndexManager.acquireModificationLock(iRecord);
        return false;
    }

    @Override
    public void onRecordAfterUpdate(ODocument iRecord) {
        HashSet<String> dirtyFields;
        OClass cls = (iRecord = OClassIndexManager.checkForLoading(iRecord)).getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()))).isEmpty()) {
            for (OIndex oIndex : indexes) {
                if (oIndex.getDefinition() instanceof OCompositeIndexDefinition) {
                    OClassIndexManager.processCompositeIndexUpdate(oIndex, dirtyFields, iRecord);
                    continue;
                }
                OClassIndexManager.processSingleIndexUpdate(oIndex, dirtyFields, iRecord);
            }
        }
        OClassIndexManager.releaseModificationLock(iRecord);
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
    }

    @Override
    public void onRecordUpdateFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    @Override
    public boolean onRecordBeforeDelete(ODocument iDocument) {
        int version = iDocument.getVersion();
        if (iDocument.fields() == 0) {
            iDocument.reload();
            if (version > -1 && iDocument.getVersion() != version) {
                throw new OConcurrentModificationException("Cannot delete the record " + iDocument.getIdentity() + " because the version is not the latest. Probably you are deleting an old record or it has been modified by another user (db=v" + iDocument.getVersion() + " your=v" + version + ")", iDocument.getIdentity(), iDocument.getVersion(), version);
            }
        }
        OClassIndexManager.acquireModificationLock(iDocument);
        return false;
    }

    @Override
    public void onRecordAfterDelete(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator indexIterator = indexes.iterator();
                while (indexIterator.hasNext()) {
                    OIndex oIndex = (OIndex)indexIterator.next();
                    boolean result = oIndex.getDefinition() instanceof OCompositeIndexDefinition ? OClassIndexManager.processCompositeIndexDelete(oIndex, dirtyFields, iRecord) : OClassIndexManager.processSingleIndexDelete(oIndex, dirtyFields, iRecord);
                    if (!result) continue;
                    indexIterator.remove();
                }
            }
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                OClassIndexManager.deleteIndexKey(oIndex, iRecord, key);
            }
        }
        OClassIndexManager.releaseModificationLock(iRecord);
        if (iRecord.isTrackingChanges()) {
            iRecord.setTrackingChanges(false);
            iRecord.setTrackingChanges(true);
        }
    }

    @Override
    public void onRecordDeleteFailed(ODocument iDocument) {
        OClassIndexManager.releaseModificationLock(iDocument);
    }

    private static void processCompositeIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        String multiValueField = indexDefinition.getMultiValueField();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField == null) {
                Object origValue = indexDefinition.createValue(origValues);
                Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                if (origValue != null) {
                    index.remove(origValue, iRecord);
                }
                if (newValue != null) {
                    index.put(newValue, iRecord.placeholder());
                }
            } else {
                OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine == null) {
                    if (dirtyFields.contains(multiValueField)) {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                    } else {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                } else if (dirtyFields.size() == 1) {
                    HashMap<OCompositeKey, Integer> keysToAdd = new HashMap<OCompositeKey, Integer>();
                    HashMap<OCompositeKey, Integer> keysToRemove = new HashMap<OCompositeKey, Integer>();
                    for (OMultiValueChangeEvent<String, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                        indexDefinition.processChangeEvent(changeEvent, keysToAdd, keysToRemove, origValues.toArray());
                    }
                    for (OMultiValueChangeEvent<String, Object> keyToRemove : keysToRemove.keySet()) {
                        index.remove(keyToRemove, iRecord);
                    }
                    for (OMultiValueChangeEvent<String, Object> keyToAdd : keysToAdd.keySet()) {
                        index.put(keyToAdd, iRecord.placeholder());
                    }
                } else {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                }
            }
            return;
        }
    }

    private static void processSingleIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap<Object, Integer> keysToAdd = new HashMap<Object, Integer>();
            HashMap<Object, Integer> keysToRemove = new HashMap<Object, Integer>();
            for (OMultiValueChangeEvent<String, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (OMultiValueChangeEvent<String, Object> keyToRemove : keysToRemove.keySet()) {
                index.remove(keyToRemove, iRecord);
            }
            for (OMultiValueChangeEvent<String, Object> keyToAdd : keysToAdd.keySet()) {
                index.put(keyToAdd, iRecord.placeholder());
            }
        } else {
            Object origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
        }
    }

    private static void processIndexUpdateFieldAssignment(OIndex<?> index, ODocument iRecord, Object origValue, Object newValue) {
        if (origValue instanceof Collection && newValue instanceof Collection) {
            HashSet valuesToRemove = new HashSet((Collection)origValue);
            HashSet valuesToAdd = new HashSet((Collection)newValue);
            valuesToRemove.removeAll((Collection)newValue);
            valuesToAdd.removeAll((Collection)origValue);
            for (Object valueToRemove : valuesToRemove) {
                if (valueToRemove == null) continue;
                index.remove(valueToRemove, iRecord);
            }
            for (Object valueToAdd : valuesToAdd) {
                if (valueToAdd == null) continue;
                index.put(valueToAdd, iRecord);
            }
        } else {
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            if (newValue instanceof Collection) {
                for (Object newValueItem : (Collection)newValue) {
                    index.put(newValueItem, iRecord.placeholder());
                }
            } else if (newValue != null) {
                index.put(newValue, iRecord.placeholder());
            }
        }
    }

    private static boolean processCompositeIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        String multiValueField = indexDefinition.getMultiValueField();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField != null) {
                OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine != null) {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                } else if (dirtyFields.contains(multiValueField)) {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                } else {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                }
            }
            Object origValue = indexDefinition.createValue(origValues);
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private static void deleteIndexKey(OIndex<?> index, ODocument iRecord, Object origValue) {
        if (origValue instanceof Collection) {
            for (Object valueItem : (Collection)origValue) {
                if (valueItem == null) continue;
                index.remove(valueItem, iRecord);
            }
        } else if (origValue != null) {
            index.remove(origValue, iRecord);
        }
    }

    private static boolean processSingleIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine<String, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(restoredMultiValue);
            } else {
                origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            }
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private static void checkIndexedPropertiesOnCreation(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        for (OIndex oIndex : indexes) {
            Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
            if (key instanceof Collection) {
                for (Object keyItem : (Collection)key) {
                    if (keyItem == null) continue;
                    oIndex.checkEntry(iRecord, keyItem);
                }
                continue;
            }
            if (key == null) continue;
            oIndex.checkEntry(iRecord, key);
        }
    }

    private static void acquireModificationLock(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        TreeSet indexesToLock = new TreeSet(new Comparator<OIndex<?>>(){

            @Override
            public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                return indexOne.getName().compareTo(indexTwo.getName());
            }
        });
        indexesToLock.addAll(indexes);
        for (OIndex oIndex : indexesToLock) {
            oIndex.getInternal().acquireModificationLock();
        }
    }

    private static void releaseModificationLock(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        for (OIndex oIndex : indexes) {
            oIndex.getInternal().releaseModificationLock();
        }
    }

    private static void checkIndexedPropertiesOnUpdate(ODocument iRecord) {
        OClass cls = iRecord.getSchemaClass();
        if (cls == null) {
            return;
        }
        HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
        if (dirtyFields.isEmpty()) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        block0: for (OIndex oIndex : indexes) {
            OIndexDefinition indexDefinition = oIndex.getDefinition();
            List<String> indexFields = indexDefinition.getFields();
            for (String indexField : indexFields) {
                if (!dirtyFields.contains(indexField)) continue;
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (keyItem == null) continue;
                        oIndex.checkEntry(iRecord, keyItem);
                    }
                    continue block0;
                }
                if (key == null) continue block0;
                oIndex.checkEntry(iRecord, key);
                continue block0;
            }
        }
    }

    private static ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OIndexException("Error during loading of record with id : " + iRecord.getIdentity());
            }
        }
        return iRecord;
    }
}

