/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.hook;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODocumentHookAbstract
implements ORecordHook {
    public boolean onRecordBeforeCreate(ODocument iDocument) {
        return false;
    }

    public void onRecordAfterCreate(ODocument iDocument) {
    }

    public void onRecordCreateFailed(ODocument iDocument) {
    }

    public void onRecordBeforeRead(ODocument iDocument) {
    }

    public void onRecordAfterRead(ODocument iDocument) {
    }

    public boolean onRecordBeforeUpdate(ODocument iDocument) {
        return false;
    }

    public void onRecordAfterUpdate(ODocument iDocument) {
    }

    public void onRecordUpdateFailed(ODocument iDocument) {
    }

    public boolean onRecordBeforeDelete(ODocument iDocument) {
        return false;
    }

    public void onRecordAfterDelete(ODocument iDocument) {
    }

    public void onRecordDeleteFailed(ODocument iDocument) {
    }

    @Override
    public boolean onTrigger(ORecordHook.TYPE iType, ORecord<?> iRecord) {
        if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && ODatabaseRecordThreadLocal.INSTANCE.get().getStatus() != ODatabase.STATUS.OPEN) {
            return false;
        }
        if (!(iRecord instanceof ODocument)) {
            return false;
        }
        ODocument document = (ODocument)iRecord;
        switch (iType) {
            case BEFORE_CREATE: {
                return this.onRecordBeforeCreate(document);
            }
            case AFTER_CREATE: {
                this.onRecordAfterCreate(document);
                break;
            }
            case CREATE_FAILED: {
                this.onRecordCreateFailed(document);
                break;
            }
            case BEFORE_READ: {
                this.onRecordBeforeRead(document);
                break;
            }
            case AFTER_READ: {
                this.onRecordAfterRead(document);
                break;
            }
            case BEFORE_UPDATE: {
                return this.onRecordBeforeUpdate(document);
            }
            case AFTER_UPDATE: {
                this.onRecordAfterUpdate(document);
                break;
            }
            case UPDATE_FAILED: {
                this.onRecordUpdateFailed(document);
                break;
            }
            case BEFORE_DELETE: {
                return this.onRecordBeforeDelete(document);
            }
            case AFTER_DELETE: {
                this.onRecordAfterDelete(document);
                break;
            }
            case DELETE_FAILED: {
                this.onRecordDeleteFailed(document);
            }
        }
        return false;
    }
}

