/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OMemoryLockException;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OEngineLocal
extends OEngineAbstract {
    public static final String NAME = "local";
    private static final AtomicBoolean memoryLocked = new AtomicBoolean(false);

    @Override
    public OStorage createStorage(String iDbName, Map<String, String> iConfiguration) {
        if (memoryLocked.compareAndSet(false, true)) {
            this.lockMemory();
        }
        try {
            return new OStorageLocal(iDbName, iDbName, this.getMode(iConfiguration));
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on opening database: " + iDbName + ". Current location is: " + new File(".").getAbsolutePath(), t, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    private void lockMemory() {
        if (!OGlobalConfiguration.FILE_MMAP_USE_OLD_MANAGER.getValueAsBoolean() && OGlobalConfiguration.FILE_MMAP_LOCK_MEMORY.getValueAsBoolean()) {
            try {
                Class<?> MemoryLocker = ClassLoader.getSystemClassLoader().loadClass("com.orientechnologies.nio.MemoryLocker");
                Method lockMemory = MemoryLocker.getMethod("lockMemory", Boolean.TYPE);
                lockMemory.invoke(null, OGlobalConfiguration.JNA_DISABLE_USE_SYSTEM_LIBRARY.getValueAsBoolean());
            }
            catch (ClassNotFoundException e) {
                OLogManager.instance().config(null, "[OEngineLocal.createStorage] Cannot lock virtual memory, the orientdb-nativeos.jar is not in classpath or there is not a native implementation for the current OS: " + System.getProperty("os.name") + " v." + System.getProperty("os.name"), new Object[0]);
            }
            catch (Exception e) {
                throw new OMemoryLockException("Error while locking memory", e);
            }
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isShared() {
        return true;
    }
}

