/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLazyRecordIterator
implements OLazyIterator<OIdentifiable> {
    private final ORecord<?> sourceRecord;
    private final Iterator<? extends OIdentifiable> underlying;
    private final boolean autoConvert2Record;

    public OLazyRecordIterator(Iterator<? extends OIdentifiable> iIterator, boolean iConvertToRecord) {
        this.sourceRecord = null;
        this.underlying = iIterator;
        this.autoConvert2Record = iConvertToRecord;
    }

    public OLazyRecordIterator(ORecord<?> iSourceRecord, Iterator<? extends OIdentifiable> iIterator, boolean iConvertToRecord) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iIterator;
        this.autoConvert2Record = iConvertToRecord;
    }

    @Override
    public OIdentifiable next() {
        OIdentifiable value = this.underlying.next();
        if (value == null) {
            return null;
        }
        if (value instanceof ORecordId && this.autoConvert2Record) {
            Object rec = ((ORecordId)value).getRecord();
            if (this.underlying instanceof OLazyIterator) {
                ((OLazyIterator)this.underlying).update(rec);
            }
            value = rec;
        }
        return value;
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public OIdentifiable update(OIdentifiable iValue) {
        if (this.underlying instanceof OLazyIterator) {
            OIdentifiable old = ((OLazyIterator)this.underlying).update(iValue);
            if (this.sourceRecord != null && !old.equals(iValue)) {
                this.sourceRecord.setDirty();
            }
            return old;
        }
        throw new UnsupportedOperationException("Underlying iterator not supports lazy updates (Interface OLazyIterator");
    }

    @Override
    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }
}

