/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OTransactionBlockedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseRecordTx
extends ODatabaseRecordAbstract {
    public static final String TYPE = "record";
    private OTransaction currentTx;

    public ODatabaseRecordTx(String iURL, byte iRecordType) {
        super(iURL, iRecordType);
        this.init();
    }

    public ODatabaseRecord begin() {
        return this.begin(OTransaction.TXTYPE.OPTIMISTIC);
    }

    public ODatabaseRecord begin(OTransaction.TXTYPE iType) {
        this.setCurrentDatabaseinThreadLocal();
        if (this.currentTx.isActive()) {
            this.currentTx.rollback();
        }
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
            try {
                listener.onBeforeTxBegin(this.underlying);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", t, new Object[0]);
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimistic(this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public ODatabaseRecord begin(OTransaction iTx) {
        this.currentTx.rollback();
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
            try {
                listener.onBeforeTxBegin(this.underlying);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before the transaction begin", t, OTransactionBlockedException.class, new Object[0]);
            }
        }
        this.currentTx = iTx;
        this.currentTx.begin();
        return this;
    }

    public ODatabaseRecord commit() {
        this.setCurrentDatabaseinThreadLocal();
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
            try {
                listener.onBeforeTxCommit(this);
            }
            catch (Throwable t) {
                try {
                    this.rollback();
                }
                catch (Exception e) {
                    // empty catch block
                }
                OLogManager.instance().debug((Object)this, "Cannot commit the transaction: caught exception on execution of %s.onBeforeTxCommit()", t, OTransactionBlockedException.class, listener.getClass());
            }
        }
        try {
            this.currentTx.commit();
        }
        catch (RuntimeException e) {
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
                try {
                    listener.onBeforeTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before tx rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback();
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
                try {
                    listener.onAfterTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after tx rollback", t, new Object[0]);
                }
            }
            throw e;
        }
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
            try {
                listener.onAfterTxCommit(this.underlying);
            }
            catch (Throwable t) {
                OLogManager.instance().debug((Object)this, "Error after the transaction has been committed. The transaction remains valid. The exception caught was on execution of %s.onAfterTxCommit()", t, OTransactionBlockedException.class, listener.getClass());
            }
        }
        return this;
    }

    public ODatabaseRecord rollback() {
        if (this.currentTx.isActive()) {
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
                try {
                    listener.onBeforeTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before tx rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback();
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).getListeners()) {
                try {
                    listener.onAfterTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after tx rollback", t, new Object[0]);
                }
            }
        }
        return this;
    }

    @Override
    public OTransaction getTransaction() {
        return this.currentTx;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return (RET)this.currentTx.loadRecord(iRecordId, null, null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return this.save(iContent, (String)null, iMode, iCallback);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent) {
        return this.save(iContent, (String)null, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName) {
        return this.save(iContent, iClusterName, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, (ORecordCallback<? extends Number>)null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        this.currentTx.saveRecord(iContent, iClusterName, iMode, iCallback);
        return (RET)iContent;
    }

    @Override
    public ODatabaseRecord delete(ORecordInternal<?> iRecord) {
        this.currentTx.deleteRecord(iRecord, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS);
        return this;
    }

    @Override
    public ODatabaseRecord delete(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.currentTx.deleteRecord(iRecord, iMode);
        return this;
    }

    public void executeRollback(OTransaction iTransaction) {
    }

    protected void checkTransaction() {
        if (this.currentTx == null || this.currentTx.getStatus() == OTransaction.TXSTATUS.INVALID) {
            throw new OTransactionException("Transaction not started");
        }
    }

    private void init() {
        this.currentTx = new OTransactionNoTx(this);
    }

    @Override
    public ORecordInternal<?> getRecordByUserObject(Object iUserObject, boolean iCreateIfNotAvailable) {
        return (ORecordInternal)iUserObject;
    }

    @Override
    public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
    }

    @Override
    public void registerUserObjectAfterLinkSave(ORecordInternal<?> iRecord) {
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable record, String iFetchPlan) {
        return record;
    }

    @Override
    public boolean existsUserObjectByRID(ORID iRID) {
        return true;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setDefaultTransactionMode() {
        if (!(this.currentTx instanceof OTransactionNoTx)) {
            this.currentTx = new OTransactionNoTx(this);
        }
    }
}

