/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.raw;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel1RecordCache;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseRaw
implements ODatabase {
    protected String url;
    protected OStorage storage;
    protected ODatabase.STATUS status;
    protected OIntent currentIntent;
    private ODatabaseRecord databaseOwner;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<ODatabaseListener> listeners = new ArrayList<ODatabaseListener>();

    public ODatabaseRaw(String iURL) {
        try {
            this.url = iURL.replace('\\', '/');
            this.status = ODatabase.STATUS.CLOSED;
            this.setProperty("fetch-max", 50);
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on opening database '" + iURL + "'", t);
        }
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.open(iUserName, iUserPassword, this.properties);
            this.status = ODatabase.STATUS.OPEN;
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onOpen(this.getDatabaseOwner());
            }
            for (ODatabaseListener listener : this.listeners) {
                try {
                    listener.onOpen(this);
                }
                catch (Throwable t) {}
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot open database", e);
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB create() {
        try {
            if (this.status == ODatabase.STATUS.OPEN) {
                throw new IllegalStateException("Database " + this.getName() + " is already open");
            }
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.create(this.properties);
            Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onOpen(this.getDatabaseOwner());
            }
            for (ODatabaseListener listener : this.listeners) {
                try {
                    listener.onCreate(this);
                }
                catch (Throwable throwable) {}
            }
            this.status = ODatabase.STATUS.OPEN;
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot create database", e);
        }
        return (DB)this;
    }

    @Override
    @Deprecated
    public void delete() {
        this.drop();
    }

    @Override
    public void drop() {
        ArrayList<ODatabaseListener> tmpListeners = new ArrayList<ODatabaseListener>(this.listeners);
        this.close();
        try {
            if (this.storage == null) {
                this.storage = Orient.instance().loadStorage(this.url);
            }
            this.storage.delete();
            this.storage = null;
            for (ODatabaseListener listener : tmpListeners) {
                try {
                    listener.onDelete(this);
                }
                catch (Throwable t) {}
            }
            this.status = ODatabase.STATUS.CLOSED;
            ODatabaseRecordThreadLocal.INSTANCE.set(null);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ODatabaseException("Cannot delete database", e);
        }
    }

    @Override
    public void reload() {
        this.storage.reload();
    }

    @Override
    public ODatabase.STATUS getStatus() {
        return this.status;
    }

    @Override
    public <DB extends ODatabase> DB setStatus(ODatabase.STATUS status) {
        this.status = status;
        return (DB)this;
    }

    public <DB extends ODatabase> DB setDefaultClusterId(int iDefClusterId) {
        this.storage.setDefaultClusterId(iDefClusterId);
        return (DB)this;
    }

    @Override
    public boolean exists() {
        if (this.status == ODatabase.STATUS.OPEN) {
            return true;
        }
        if (this.storage == null) {
            this.storage = Orient.instance().loadStorage(this.url);
        }
        return this.storage.exists();
    }

    @Override
    public long countClusterElements(String iClusterName) {
        int clusterId = this.getClusterIdByName(iClusterName);
        if (clusterId < 0) {
            throw new IllegalArgumentException("Cluster '" + iClusterName + "' was not found");
        }
        return this.storage.count(clusterId);
    }

    @Override
    public long countClusterElements(int iClusterId) {
        return this.storage.count(iClusterId);
    }

    @Override
    public long countClusterElements(int[] iClusterIds) {
        return this.storage.count(iClusterIds);
    }

    public ORawBuffer read(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache) {
        if (!iRid.isValid()) {
            return null;
        }
        OFetchHelper.checkFetchPlanValid(iFetchPlan);
        try {
            return this.storage.readRecord(iRid, iFetchPlan, iIgnoreCache, null);
        }
        catch (Throwable t) {
            if (iRid.isTemporary()) {
                throw new ODatabaseException("Error on retrieving record using temporary RecordId: " + iRid, t);
            }
            throw new ODatabaseException("Error on retrieving record " + iRid + " (cluster: " + this.storage.getPhysicalClusterNameById(iRid.clusterId) + ")", t);
        }
    }

    public int save(int iDataSegmentId, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<? extends Number> iCallBack) {
        Orient.instance().getRecordFactoryManager().getRecordTypeClass(iRecordType);
        try {
            if (iRid.clusterPosition < 0L) {
                return this.storage.createRecord((int)iDataSegmentId, (ORecordId)iRid, (byte[])iContent, (int)iVersion, (byte)iRecordType, (int)iMode, iCallBack).recordVersion;
            }
            return this.storage.updateRecord(iRid, iContent, iVersion, iRecordType, iMode, iCallBack);
        }
        catch (OException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ODatabaseException("Error on saving record " + iRid, t);
        }
    }

    public void delete(ORecordId iRid, int iVersion, boolean iRequired, int iMode) {
        try {
            if (!this.storage.deleteRecord(iRid, iVersion, iMode, null) && iRequired) {
                throw new ORecordNotFoundException("The record with id " + iRid + " was not found");
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on deleting record " + iRid, e, ODatabaseException.class, new Object[0]);
        }
    }

    @Override
    public OStorage getStorage() {
        return this.storage;
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        this.storage = iNewStorage;
    }

    @Override
    public boolean isClosed() {
        return this.status == ODatabase.STATUS.CLOSED || this.storage.isClosed();
    }

    @Override
    public String getName() {
        return this.storage != null ? this.storage.getName() : this.url;
    }

    @Override
    public String getURL() {
        return this.url != null ? this.url : this.storage.getURL();
    }

    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        return this.storage.getDataSegmentIdByName(iDataSegmentName);
    }

    @Override
    public String getDataSegmentNameById(int dataSegmentId) {
        return this.storage.getDataSegmentById(dataSegmentId).getName();
    }

    @Override
    public int getClusters() {
        return this.storage.getClusters();
    }

    @Override
    public boolean existsCluster(String iClusterName) {
        return this.storage.getClusterNames().contains(iClusterName);
    }

    @Override
    public String getClusterType(String iClusterName) {
        return this.storage.getClusterTypeByName(iClusterName);
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        return this.storage.getClusterIdByName(iClusterName);
    }

    @Override
    public String getClusterNameById(int iClusterId) {
        if (iClusterId == -1) {
            return null;
        }
        return this.storage.getPhysicalClusterNameById(iClusterId);
    }

    @Override
    public long getClusterRecordSizeById(int iClusterId) {
        try {
            return this.storage.getClusterById(iClusterId).getRecordsSize();
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on reading records size for cluster with id '" + iClusterId + "'", e, ODatabaseException.class, new Object[0]);
            return 0L;
        }
    }

    @Override
    public long getClusterRecordSizeByName(String iClusterName) {
        try {
            return this.storage.getClusterById(this.getClusterIdByName(iClusterName)).getRecordsSize();
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on reading records size for cluster '" + iClusterName + "'", e, ODatabaseException.class, new Object[0]);
            return 0L;
        }
    }

    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iType, Object ... iParameters) {
        return this.addCluster(iType.toString(), iClusterName, null, null, iParameters);
    }

    @Override
    public int addCluster(String iType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        return this.storage.addCluster(iType, iClusterName, iLocation, iDataSegmentName, iParameters);
    }

    @Override
    public int addPhysicalCluster(String iClusterName, String iLocation, int iStartSize) {
        return this.storage.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), iClusterName, null, null, iLocation, iStartSize);
    }

    @Override
    public boolean dropCluster(String iClusterName) {
        return this.storage.dropCluster(iClusterName);
    }

    @Override
    public boolean dropCluster(int iClusterId) {
        return this.storage.dropCluster(iClusterId);
    }

    @Override
    public int addDataSegment(String iSegmentName, String iLocation) {
        return this.storage.addDataSegment(iSegmentName, iLocation);
    }

    @Override
    public boolean dropDataSegment(String iName) {
        return this.storage.dropDataSegment(iName);
    }

    @Override
    public Collection<String> getClusterNames() {
        return this.storage.getClusterNames();
    }

    @Override
    public OLevel1RecordCache getLevel1Cache() {
        return null;
    }

    @Override
    public int getDefaultClusterId() {
        return this.storage.getDefaultClusterId();
    }

    @Override
    public boolean declareIntent(OIntent iIntent) {
        if (this.currentIntent != null) {
            if (iIntent != null && iIntent.getClass().equals(this.currentIntent.getClass())) {
                return false;
            }
            this.currentIntent.end(this);
        }
        this.currentIntent = iIntent;
        if (iIntent != null) {
            iIntent.begin(this, new Object[0]);
        }
        return true;
    }

    public ODatabaseRecord getDatabaseOwner() {
        return this.databaseOwner;
    }

    public ODatabaseRaw setOwner(ODatabaseRecord iOwner) {
        this.databaseOwner = iOwner;
        return this;
    }

    @Override
    public Object setProperty(String iName, Object iValue) {
        if (iValue == null) {
            return this.properties.remove(iName.toLowerCase());
        }
        return this.properties.put(iName.toLowerCase(), iValue);
    }

    @Override
    public Object getProperty(String iName) {
        return this.properties.get(iName.toLowerCase());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> getProperties() {
        return this.properties.entrySet().iterator();
    }

    @Override
    public void registerListener(ODatabaseListener iListener) {
        if (!this.listeners.contains(iListener)) {
            this.listeners.add(iListener);
        }
    }

    @Override
    public void unregisterListener(ODatabaseListener iListener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != iListener) continue;
            this.listeners.remove(i);
            break;
        }
    }

    public List<ODatabaseListener> getListeners() {
        return this.listeners;
    }

    @Override
    public OLevel2RecordCache getLevel2Cache() {
        return this.storage.getLevel2Cache();
    }

    @Override
    public void close() {
        if (this.status != ODatabase.STATUS.OPEN) {
            return;
        }
        if (this.currentIntent != null) {
            this.currentIntent.end(this);
            this.currentIntent = null;
        }
        this.callOnCloseListeners();
        this.listeners.clear();
        if (this.storage != null) {
            this.storage.close();
        }
        this.storage = null;
        this.status = ODatabase.STATUS.CLOSED;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("OrientDB[");
        buffer.append(this.url != null ? this.url : "?");
        buffer.append(']');
        if (this.getStorage() != null) {
            buffer.append(" (users: ");
            buffer.append(this.getStorage().getUsers());
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public Object get(ODatabase.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case STATUS: {
                return this.getStatus();
            }
            case DEFAULTCLUSTERID: {
                return this.getDefaultClusterId();
            }
            case TYPE: {
                ODatabaseRecord db = this.getDatabaseOwner() instanceof ODatabaseRecord ? this.getDatabaseOwner() : new OGraphDatabase(this.url);
                return db.getMetadata().getSchema().existsClass("OGraphVertex");
            }
        }
        return null;
    }

    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case STATUS: {
                this.setStatus(ODatabase.STATUS.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case DEFAULTCLUSTERID: {
                if (iValue == null) break;
                if (iValue instanceof Number) {
                    this.storage.setDefaultClusterId(((Number)iValue).intValue());
                    break;
                }
                this.storage.setDefaultClusterId(this.storage.getClusterIdByName(iValue.toString()));
                break;
            }
            case TYPE: {
                if (stringValue.equalsIgnoreCase("graph")) {
                    if (this.getDatabaseOwner() instanceof OGraphDatabase) {
                        ((OGraphDatabase)this.getDatabaseOwner()).checkForGraphSchema();
                        break;
                    }
                    if (this.getDatabaseOwner() instanceof ODatabaseRecordTx) {
                        new OGraphDatabase((ODatabaseRecordTx)this.getDatabaseOwner()).checkForGraphSchema();
                        break;
                    }
                    new OGraphDatabase(this.url).checkForGraphSchema();
                    break;
                }
                throw new IllegalArgumentException("Database type '" + stringValue + "' is not supported");
            }
            default: {
                throw new IllegalArgumentException("Option '" + (Object)((Object)iAttribute) + "' not supported on alter database");
            }
        }
        return (DB)this;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return this.storage.callInLock(iCallable, iExclusiveLock);
    }

    public void callOnCloseListeners() {
        Iterator<ODatabaseLifecycleListener> it = Orient.instance().getDbLifecycleListeners();
        while (it.hasNext()) {
            it.next().onClose(this.getDatabaseOwner());
        }
        for (ODatabaseListener listener : new ArrayList<ODatabaseListener>(this.listeners)) {
            try {
                listener.onClose(this.getDatabaseOwner());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected boolean isClusterBoundedToClass(int iClusterId) {
        return false;
    }

    @Override
    public long getSize() {
        return this.storage.getSize();
    }

    @Override
    public void freeze() {
        if (!(this.getStorage() instanceof OStorageLocal)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OStorageLocal storage = (OStorageLocal)this.getStorage();
        storage.freeze(false);
    }

    @Override
    public void freeze(boolean throwException) {
        if (!(this.getStorage() instanceof OStorageLocal)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OStorageLocal storage = (OStorageLocal)this.getStorage();
        storage.freeze(throwException);
    }

    @Override
    public void release() {
        if (!(this.getStorage() instanceof OStorageLocal)) {
            OLogManager.instance().error((Object)this, "We can not freeze non local storage.", new Object[0]);
            return;
        }
        OStorageLocal storage = (OStorageLocal)this.getStorage();
        storage.release();
    }
}

